/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.trustedapps;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.File;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.sourceforge.jwebunit.TestContext;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestTrustedApplicationClientVersion1
extends JIRAWebTest {
    private static final String ID = "TestTrustedApplicationClient.id";
    private static final String REQUEST_STRING = "/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml";

    public TestTrustedApplicationClientVersion1(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestTrustedAppsWithIssues.xml");
        this.gotoAdmin();
        this.gotoPage("/secure/admin/trustedapps/ViewTrustedApplications.jspa");
        File file = new File(this.getEnvironmentData().getXMLDataLocation(), "/trustedapp/");
        this.setFormElement("trustedAppBaseUrl", file.toURI().toASCIIString());
        this.submit("Send Request");
        this.setWorkingForm("jiraform");
        this.setFormElement("name", "TestTrustedApplicationClient");
        this.setFormElement("timeout", "500");
        this.submit("Add");
        this.logout();
    }

    public void testAll() throws Exception {
        this._testClientNotLoggedIn();
        this._testUnknownClientLoggedInFred();
        this._testClientLoggedInUnknown();
        this._testClientLoggedInFred();
        this._testClientLoggedInAdmin();
        this._testInvalidCertData();
        this._testInvalidCertSecretKey();
        this._testCertificateExpires();
        this._testUrlNotMatched();
    }

    public void _testClientNotLoggedIn() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("nothing", request);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testClientLoggedInUnknown() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("unknown-user", request);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testClientLoggedInFred() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        Token token = new Token();
        token.populateRequest("FreD", request);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testClientLoggedInAdmin() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        Token token = new Token();
        token.populateRequest("aDmIn", request);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testUnknownClientLoggedInFred() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("fred", request);
        request.setHeaderField("X-Seraph-Trusted-App-ID", "TestTrustedApplicationClient.id.unknown");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testInvalidCertData() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("blah", request);
        request.setHeaderField("X-Seraph-Trusted-App-Cert", ID);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testInvalidCertSecretKey() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("fred", request);
        request.setHeaderField("X-Seraph-Trusted-App-Key", ID);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testCertificateExpires() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        new Token().populateRequest("fred", request);
        Thread.sleep(550L);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
        this.assertResponseContainsBadProtocolError(response);
    }

    public void _testUrlNotMatched() throws Exception {
        this.logout();
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/browse/MKY-1");
        new Token().populateRequest("fred", request);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        TestTrustedApplicationClientVersion1.assertTrue((String)response.getText(), (response.getText().indexOf("You must log in to access this page.") >= 0 ? 1 : 0) != 0);
    }

    private void assertResponseContainsError(WebResponse response) {
        TestTrustedApplicationClientVersion1.assertNotNull((Object)response);
        TestTrustedApplicationClientVersion1.assertNotNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClientVersion1.assertEquals((String)"ERROR", (String)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClientVersion1.assertNotNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Error"));
    }

    private void assertResponseContainsBadProtocolError(WebResponse response) {
        TestTrustedApplicationClientVersion1.assertEquals((String)"BAD_PROTOCOL_VERSION; Unsupported protocol version: {0}. required {1}; [\"1\",\"2\"]", (String)response.getHeaderField("X-Seraph-Trusted-App-Error"));
    }

    private void assertResponseContainsNoItems(WebResponse response) throws SAXException {
        TestTrustedApplicationClientVersion1.assertNotNull((Object)response);
        Document doc = response.getDOM();
        NodeList nodes = doc.getElementsByTagName("item");
        TestTrustedApplicationClientVersion1.assertEquals((int)0, (int)nodes.getLength());
    }

    static {
        try {
            Security.addProvider((Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class Token {
        final PrivateKey privateKey;
        final PublicKey publicKey;
        final SecretKey secretKey;
        String unencoded;

        Token() {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
                this.privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((byte[])"MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALJKm1u6AcDNZQljcAtaG5II+FVefBtQF+xETFhCK0EJWfLhXUNxTZIDHbZsf11IzRfs10w5sXviv5Z3vtCg8C1rJKoUuoJ5EJsWaEeBVKL6kZ4KKlOm5559KTPYBfwCP73Hbu2qMGxfUu01ZUsOyKcSEFY3rxH6IQ6Z//qMZY5tAgMBAAECgYB4QXJAkFmWXfOEPZnZTlHCUmKN0kkLcx5vsjF8ZkUefNw6wl9Rmh6kGY30+YF+vhf3xzwAoflggjSPnP0LY0Ibf0XxMcNjR1zBsl9X7gKfXghIunS6gbcwrEwBNc5GR4zkYjYaZQ4zVvm3oMS2glV9NlXAUl41VL2XAQC/ENwbUQJBAOdoAz4hZGgke9AxoKLZh215gY+PLXqVLlWf14Ypk70Efk/bVvF10EsAOuAm9queCyr0qNf/vgHrm4HHXwJz4SsCQQDFPXir5qs+Kf2Y0KQ+WO5IRaNmrOlNvWDqJP/tDGfF/TYo6nSI0dGtWNfwZyDB47PbUq3zxCHYjExBJ9vQNZLHAkEA4JlCtHYCl1X52jug1w7c9DN/vc/Q626J909aB3ypSUdoNagFPf0EexcxDcijmDSgUEQA8Qzm5cRBPfg9Tgsc2wJBAIKbiv2hmEFowtHfTvMuJlNbMbF6zF67CaLib0oEDe+QFb4QSqyS69py20MItytM4btYy3GArbzcYl4+y5La9t8CQE2BkMV3MLcpAKjxtK5SYwCyLT591k35isGxmIlSQBQbDmGP9L5ZeXmVGVxRCGbBQjCzeoafPvUZo65kaRQHUJc=".getBytes())));
                this.publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((byte[])"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCySptbugHAzWUJY3ALWhuSCPhVXnwbUBfsRExYQitBCVny4V1DcU2SAx22bH9dSM0X7NdMObF74r+Wd77QoPAtaySqFLqCeRCbFmhHgVSi+pGeCipTpueefSkz2AX8Aj+9x27tqjBsX1LtNWVLDsinEhBWN68R+iEOmf/6jGWObQIDAQAB".getBytes())));
                this.secretKey = new SecretKeyGenerator().generateKey();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        String getSecretKey() {
            return this.encrypt(this.secretKey.getEncoded());
        }

        private String encrypt(byte[] input) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/NONE/NoPadding", "BC");
                cipher.init(1, this.privateKey);
                return new String(Base64.encodeBase64((byte[])cipher.doFinal(input)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        String getCert(String userName) {
            try {
                Cipher cipher = Cipher.getInstance("RC4", "BC");
                cipher.init(1, this.secretKey);
                StringWriter writer = new StringWriter();
                writer.write(String.valueOf(System.currentTimeMillis()));
                writer.write(10);
                writer.write(userName);
                writer.write(10);
                writer.write(KeyData.MAGIC_NUMBER);
                writer.flush();
                this.unencoded = writer.toString();
                byte[] encryptedData = cipher.doFinal(this.unencoded.getBytes("UTF-8"));
                return new String(Base64.encodeBase64((byte[])encryptedData));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        void populateRequest(String userName, GetMethodWebRequest request) {
            request.setHeaderField("X-Seraph-Trusted-App-ID", TestTrustedApplicationClientVersion1.ID);
            request.setHeaderField("X-Seraph-Trusted-App-Key", this.getSecretKey());
            request.setHeaderField("X-Seraph-Trusted-App-Cert", this.getCert(userName));
            request.setHeaderField("X-Seraph-Trusted-App-Version", String.valueOf(1));
            request.setHeaderField("X-Seraph-Trusted-App-Magic", this.encrypt(KeyData.MAGIC_NUMBER.getBytes()));
        }

        public String toString() {
            return this.unencoded;
        }

        class SecretKeyGenerator {
            SecretKeyGenerator() {
            }

            SecretKey generateKey() {
                SecretKey result = this.generateSecretKey();
                while (!this.isValid(result)) {
                    result = this.generateSecretKey();
                }
                return result;
            }

            private boolean isValid(SecretKey secretKey) {
                byte[] encoded = secretKey.getEncoded();
                return encoded.length == 16 && encoded[0] != 0;
            }

            private SecretKey generateSecretKey() {
                try {
                    return KeyGenerator.getInstance("RC4", "BC").generateKey();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static final class KeyData {
            private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCySptbugHAzWUJY3ALWhuSCPhVXnwbUBfsRExYQitBCVny4V1DcU2SAx22bH9dSM0X7NdMObF74r+Wd77QoPAtaySqFLqCeRCbFmhHgVSi+pGeCipTpueefSkz2AX8Aj+9x27tqjBsX1LtNWVLDsinEhBWN68R+iEOmf/6jGWObQIDAQAB";
            private static final String PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALJKm1u6AcDNZQljcAtaG5II+FVefBtQF+xETFhCK0EJWfLhXUNxTZIDHbZsf11IzRfs10w5sXviv5Z3vtCg8C1rJKoUuoJ5EJsWaEeBVKL6kZ4KKlOm5559KTPYBfwCP73Hbu2qMGxfUu01ZUsOyKcSEFY3rxH6IQ6Z//qMZY5tAgMBAAECgYB4QXJAkFmWXfOEPZnZTlHCUmKN0kkLcx5vsjF8ZkUefNw6wl9Rmh6kGY30+YF+vhf3xzwAoflggjSPnP0LY0Ibf0XxMcNjR1zBsl9X7gKfXghIunS6gbcwrEwBNc5GR4zkYjYaZQ4zVvm3oMS2glV9NlXAUl41VL2XAQC/ENwbUQJBAOdoAz4hZGgke9AxoKLZh215gY+PLXqVLlWf14Ypk70Efk/bVvF10EsAOuAm9queCyr0qNf/vgHrm4HHXwJz4SsCQQDFPXir5qs+Kf2Y0KQ+WO5IRaNmrOlNvWDqJP/tDGfF/TYo6nSI0dGtWNfwZyDB47PbUq3zxCHYjExBJ9vQNZLHAkEA4JlCtHYCl1X52jug1w7c9DN/vc/Q626J909aB3ypSUdoNagFPf0EexcxDcijmDSgUEQA8Qzm5cRBPfg9Tgsc2wJBAIKbiv2hmEFowtHfTvMuJlNbMbF6zF67CaLib0oEDe+QFb4QSqyS69py20MItytM4btYy3GArbzcYl4+y5La9t8CQE2BkMV3MLcpAKjxtK5SYwCyLT591k35isGxmIlSQBQbDmGP9L5ZeXmVGVxRCGbBQjCzeoafPvUZo65kaRQHUJc=";
            private static final String ALGORITHM = "RSA";
            private static final String BOUNCY_CASTLE_PROVIDER = "BC";
            private static final String STREAM_CIPHER = "RC4";
            private static final String ASYM_CIPHER = "RSA/NONE/NoPadding";
            private static final String CHARSET_NAME = "UTF-8";
            private static final String MAGIC_NUMBER = String.valueOf(-1159983122);

            private KeyData() {
            }
        }
    }

    private static final class Status {
        static final String ERROR = "ERROR";
        static final String OK = "OK";

        private Status() {
        }
    }

    private static final class TrustedAppHeader {
        static final String APP_ID = "X-Seraph-Trusted-App-ID";
        static final String CERTIFICATE = "X-Seraph-Trusted-App-Cert";
        static final String ERROR = "X-Seraph-Trusted-App-Error";
        static final String STATUS = "X-Seraph-Trusted-App-Status";
        static final String SECRET_KEY = "X-Seraph-Trusted-App-Key";
        public static final String VERSION = "X-Seraph-Trusted-App-Version";
        public static final String MAGIC = "X-Seraph-Trusted-App-Magic";

        private TrustedAppHeader() {
        }
    }
}

