/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.trustedapps;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import net.sourceforge.jwebunit.TestContext;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestTrustedApplicationClient
extends FuncTestCase {
    private static final String ID = "TestTrustedApplicationClient.id";
    private static final String REQUEST_STRING = "/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml";
    private static final String PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALJKm1u6AcDNZQljcAtaG5II+FVefBtQF+xETFhCK0EJWfLhXUNxTZIDHbZsf11IzRfs10w5sXviv5Z3vtCg8C1rJKoUuoJ5EJsWaEeBVKL6kZ4KKlOm5559KTPYBfwCP73Hbu2qMGxfUu01ZUsOyKcSEFY3rxH6IQ6Z//qMZY5tAgMBAAECgYB4QXJAkFmWXfOEPZnZTlHCUmKN0kkLcx5vsjF8ZkUefNw6wl9Rmh6kGY30+YF+vhf3xzwAoflggjSPnP0LY0Ibf0XxMcNjR1zBsl9X7gKfXghIunS6gbcwrEwBNc5GR4zkYjYaZQ4zVvm3oMS2glV9NlXAUl41VL2XAQC/ENwbUQJBAOdoAz4hZGgke9AxoKLZh215gY+PLXqVLlWf14Ypk70Efk/bVvF10EsAOuAm9queCyr0qNf/vgHrm4HHXwJz4SsCQQDFPXir5qs+Kf2Y0KQ+WO5IRaNmrOlNvWDqJP/tDGfF/TYo6nSI0dGtWNfwZyDB47PbUq3zxCHYjExBJ9vQNZLHAkEA4JlCtHYCl1X52jug1w7c9DN/vc/Q626J909aB3ypSUdoNagFPf0EexcxDcijmDSgUEQA8Qzm5cRBPfg9Tgsc2wJBAIKbiv2hmEFowtHfTvMuJlNbMbF6zF67CaLib0oEDe+QFb4QSqyS69py20MItytM4btYy3GArbzcYl4+y5La9t8CQE2BkMV3MLcpAKjxtK5SYwCyLT591k35isGxmIlSQBQbDmGP9L5ZeXmVGVxRCGbBQjCzeoafPvUZo65kaRQHUJc=";
    private String localProtocolVersion;
    private String remoteProtocolVersion;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        try {
            this.localProtocolVersion = System.getProperty("trustedapps.protocol.version");
            this.remoteProtocolVersion = this.backdoor.systemProperties().getProperty("trustedapps.protocol.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.administration.restoreData("TestTrustedAppsWithIssues.xml");
        this.navigation.gotoAdmin();
        this.navigation.gotoPage("/secure/admin/trustedapps/ViewTrustedApplications.jspa");
        File file = new File(this.getEnvironmentData().getXMLDataLocation(), "/trustedapp/");
        this.tester.setFormElement("trustedAppBaseUrl", file.toURI().toASCIIString());
        this.tester.submit("Send Request");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", "TestTrustedApplicationClient");
        this.tester.setFormElement("timeout", "500");
        this.tester.submit("Add");
        this.navigation.logout();
    }

    @Override
    protected void tearDownTest() {
        if (this.localProtocolVersion != null) {
            System.setProperty("trustedapps.protocol.version", this.localProtocolVersion);
        } else {
            System.clearProperty("trustedapps.protocol.version");
        }
        if (this.remoteProtocolVersion != null) {
            this.backdoor.systemProperties().setProperty("trustedapps.protocol.version", this.remoteProtocolVersion);
        }
    }

    public void testAllWithV2TrustedProtocol() throws Exception {
        this.backdoor.systemProperties().setProperty("trustedapps.protocol.version", TrustedApplicationUtils.Constant.VERSION_TWO.toString());
        System.setProperty("trustedapps.protocol.version", TrustedApplicationUtils.Constant.VERSION_TWO.toString());
        this._testClientNotLoggedIn();
        this._testUnknownClientLoggedInFred();
        this._testClientLoggedInUnknown();
        this._testClientLoggedInFred();
        this._testClientLoggedInAdmin();
        this._testInvalidCertData();
        this._testInvalidCertSecretKey();
        this._testUrlNotMatched();
    }

    public void testAllWithV3TrustedProtocol() throws Exception {
        this.backdoor.systemProperties().setProperty("trustedapps.protocol.version", TrustedApplicationUtils.Constant.VERSION_THREE.toString());
        System.setProperty("trustedapps.protocol.version", TrustedApplicationUtils.Constant.VERSION_THREE.toString());
        this._testClientNotLoggedIn();
        this._testUnknownClientLoggedInFred();
        this._testClientLoggedInUnknown();
        this._testClientLoggedInFred();
        this._testClientLoggedInAdmin();
        this._testInvalidCertData();
        this._testInvalidCertSecretKeyWithV3Protocol();
        this._testUrlNotMatched();
    }

    public void _testClientNotLoggedIn() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("nothing");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testClientLoggedInUnknown() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("unknown-user", this.getEnvironmentData().getBaseUrl() + REQUEST_STRING);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testClientLoggedInFred() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("FreD");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsNoErrors(response);
        Document doc = response.getDOM();
        NodeList nodes = doc.getElementsByTagName("item");
        TestTrustedApplicationClient.assertEquals((int)1, (int)nodes.getLength());
        Node title = ((Element)nodes.item(0)).getElementsByTagName("title").item(0);
        String text = title.getFirstChild().getNodeValue();
        TestTrustedApplicationClient.assertNotNull((Object)text);
        TestTrustedApplicationClient.assertTrue((text.indexOf("HSP-1") >= 0 ? 1 : 0) != 0);
        TestTrustedApplicationClient.assertTrue((text.indexOf("A bug anyone can see") >= 0 ? 1 : 0) != 0);
    }

    public void _testClientLoggedInAdmin() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("aDmIn");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsNoErrors(response);
        Document doc = response.getDOM();
        NodeList nodes = doc.getElementsByTagName("item");
        TestTrustedApplicationClient.assertEquals((int)2, (int)nodes.getLength());
        Node title = ((Element)nodes.item(0)).getElementsByTagName("title").item(0);
        String text = title.getFirstChild().getNodeValue();
        TestTrustedApplicationClient.assertNotNull((Object)text);
        TestTrustedApplicationClient.assertTrue((String)text, (text.indexOf("MKY-1") >= 0 ? 1 : 0) != 0);
        TestTrustedApplicationClient.assertTrue((String)text, (text.indexOf("A bug only admin can see") >= 0 ? 1 : 0) != 0);
        title = ((Element)nodes.item(1)).getElementsByTagName("title").item(0);
        text = title.getFirstChild().getNodeValue();
        TestTrustedApplicationClient.assertNotNull((Object)text);
        TestTrustedApplicationClient.assertTrue((String)text, (text.indexOf("HSP-1") >= 0 ? 1 : 0) != 0);
        TestTrustedApplicationClient.assertTrue((String)text, (text.indexOf("A bug anyone can see") >= 0 ? 1 : 0) != 0);
    }

    public void _testUnknownClientLoggedInFred() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("fred");
        request.setHeaderField("X-Seraph-Trusted-App-ID", "TestTrustedApplicationClient.id.unknown");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testInvalidCertData() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("blah");
        request.setHeaderField("X-Seraph-Trusted-App-Cert", ID);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testInvalidCertSecretKey() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("fred");
        request.setHeaderField("X-Seraph-Trusted-App-Key", ID);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testInvalidCertSecretKeyWithV3Protocol() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("fred");
        request.setHeaderField("X-Seraph-Trusted-App-Key", ID);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsNoErrors(response);
        Document doc = response.getDOM();
        NodeList nodes = doc.getElementsByTagName("item");
        TestTrustedApplicationClient.assertEquals((int)1, (int)nodes.getLength());
        Node title = ((Element)nodes.item(0)).getElementsByTagName("title").item(0);
        String text = title.getFirstChild().getNodeValue();
        TestTrustedApplicationClient.assertNotNull((Object)text);
        TestTrustedApplicationClient.assertTrue((text.indexOf("HSP-1") >= 0 ? 1 : 0) != 0);
        TestTrustedApplicationClient.assertTrue((text.indexOf("A bug anyone can see") >= 0 ? 1 : 0) != 0);
    }

    public void _testCertificateExpires() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("fred");
        Thread.sleep(550L);
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        this.assertResponseContainsError(response);
        this.assertResponseContainsNoItems(response);
    }

    public void _testUrlNotMatched() throws Exception {
        GetMethodWebRequest request = this.getGetMethodWebRequest("fred", this.getEnvironmentData().getBaseUrl() + "/browse/MKY-1");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        WebResponse response = webClient.sendRequest((WebRequest)request);
        TestTrustedApplicationClient.assertNotNull((Object)response);
        TestTrustedApplicationClient.assertTrue((String)response.getText(), (response.getText().indexOf("You must log in to access this page.") >= 0 ? 1 : 0) != 0);
    }

    private GetMethodWebRequest getGetMethodWebRequest(String username) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        String url = this.getEnvironmentData().getBaseUrl() + REQUEST_STRING;
        return this.getGetMethodWebRequest(username, url);
    }

    private GetMethodWebRequest getGetMethodWebRequest(String username, String url) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        BouncyCastleEncryptionProvider encryptionProvider = new BouncyCastleEncryptionProvider();
        EncryptedCertificate encryptedCertificate = encryptionProvider.createEncryptedCertificate(username, encryptionProvider.toPrivateKey(Base64.decodeBase64((byte[])PRIVATE_KEY.getBytes())), ID, url);
        this.populateRequest(encryptedCertificate, request);
        return request;
    }

    private void assertResponseContainsError(WebResponse response) {
        TestTrustedApplicationClient.assertNotNull((Object)response);
        TestTrustedApplicationClient.assertNotNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClient.assertEquals((String)"ERROR", (String)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClient.assertNotNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Error"));
    }

    private void assertResponseContainsNoItems(WebResponse response) throws SAXException {
        TestTrustedApplicationClient.assertNotNull((Object)response);
        Document doc = response.getDOM();
        NodeList nodes = doc.getElementsByTagName("item");
        TestTrustedApplicationClient.assertEquals((int)0, (int)nodes.getLength());
    }

    private void assertResponseContainsNoErrors(WebResponse response) {
        TestTrustedApplicationClient.assertNotNull((Object)response);
        TestTrustedApplicationClient.assertNotNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClient.assertEquals((String)"OK", (String)response.getHeaderField("X-Seraph-Trusted-App-Status"));
        TestTrustedApplicationClient.assertNull((Object)response.getHeaderField("X-Seraph-Trusted-App-Error"));
    }

    private void populateRequest(EncryptedCertificate certificate, final GetMethodWebRequest request) {
        TrustedRequest trustedRequest = new TrustedRequest(){

            public void addRequestParameter(String name, String value) {
                if (value != null) {
                    request.setHeaderField(name, value);
                }
            }
        };
        TrustedApplicationUtils.addRequestParameters((EncryptedCertificate)certificate, (TrustedRequest)trustedRequest);
    }
}

