/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.services;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestBackupService
extends FuncTestCase {
    public void testAddAndEditBackupService() throws Exception {
        this.administration.restoreData("TestBackupService.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.tester.assertTextPresent("Add a new service by entering a name and class below. You can then edit it to set properties");
        this.tester.setFormElement("name", "My Backup Service");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.export.ExportService");
        this.tester.checkRadioOption("service.schedule.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("service.schedule.cronString", "0 0 2 1/2 * ?");
        this.tester.submit("Add Service");
        this.tester.assertTextPresent("Edit Service: My Backup Service");
        this.tester.assertFormElementEquals("service.schedule.cronString", "0 0 2 1/2 * ?");
        this.tester.checkRadioOption("service.schedule.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("service.schedule.cronString", "0 0 2 * * ?");
        this.tester.submit("Update");
        WebTable tbl_services = this.tester.getDialog().getWebTableBySummaryOrId("tbl_services");
        TestBackupService.assertEquals((String)"Cell (0, 1) in table 'tbl_services' should be 'Name / Class'.", (String)"Name / Class", (String)tbl_services.getCellAsText(0, 1).trim());
        TestBackupService.assertEquals((String)"Cell (0, 2) in table 'tbl_services' should be 'Properties'.", (String)"Properties", (String)tbl_services.getCellAsText(0, 2).trim());
        TestBackupService.assertEquals((String)"Cell (0, 3) in table 'tbl_services' should be 'Schedule'.", (String)"Schedule", (String)tbl_services.getCellAsText(0, 3).trim());
        TableLocator tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "My Backup Service", "com.atlassian.jira.service.services.export.ExportService", "Daily at 2:00 am");
        this.text.assertTextNotPresent(tableLocator, "DIR_NAME");
        this.administration.services().clickEdit("My Backup Service");
        this.tester.checkRadioOption("service.schedule.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("service.schedule.cronString", "0 0 0/3 * * ?");
        this.tester.submit("Update");
        tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "My Backup Service", "com.atlassian.jira.service.services.export.ExportService", "Daily every 3 hours");
        this.text.assertTextNotPresent(tableLocator, "USE_DEFAULT_DIRECTORY");
    }

    public void testWhenDataHasLegacyPathInIt() throws IOException {
        File attachment = TempDirectoryUtil.createTempDirectory("tWDHLPII");
        File indexes = TempDirectoryUtil.createTempDirectory("tWDHLPII");
        File fileservice = TempDirectoryUtil.createTempDirectory("tWDHLPII");
        File backup = TempDirectoryUtil.createTempDirectory("tWDHLPII");
        this.administration.restoreDataWithReplacedTokens("TestCustomPathInLegacyData.xml", (Map<String, String>)ImmutableMap.of((Object)"@INDEX_DIR@", (Object)indexes.getAbsolutePath(), (Object)"@ATTACHMENT_DIR@", (Object)attachment.getAbsolutePath(), (Object)"@BACKUP_DIR@", (Object)backup.getAbsolutePath(), (Object)"@FILESERVICE_DIR@", (Object)fileservice.getAbsolutePath()));
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        TableLocator tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "File Service", "com.atlassian.jira.service.services.file.FileService", "directory", fileservice.getAbsolutePath(), "handler", "Add a comment from the non quoted email body");
        this.text.assertTextSequence(tableLocator, "Backup Service", "com.atlassian.jira.service.services.export.ExportService", "DIR_NAME", backup.getAbsolutePath());
        this.navigation.gotoPage(this.page.addXsrfToken("secure/admin/EditService!default.jspa?id=10021"));
        this.text.assertTextPresent(fileservice.getAbsolutePath());
        this.tester.submit("Update");
        this.navigation.gotoPage(this.page.addXsrfToken("secure/admin/EditService!default.jspa?id=10001"));
        this.text.assertTextPresent(backup.getAbsolutePath());
        this.tester.submit("Update");
        this.text.assertTextSequence(tableLocator, "File Service", "com.atlassian.jira.service.services.file.FileService", "directory", fileservice.getAbsolutePath(), "handler", "Add a comment from the non quoted email body");
        this.text.assertTextSequence(tableLocator, "Backup Service", "com.atlassian.jira.service.services.export.ExportService", "DIR_NAME", backup.getAbsolutePath());
        this.administration.restoreBlankInstance();
        FileUtils.deleteDirectory((File)attachment);
        try {
            FileUtils.deleteDirectory((File)indexes);
        }
        catch (IOException ex) {
            this.log("Failed to delete indexes directory. " + ex.getMessage());
            ex.printStackTrace();
        }
        FileUtils.deleteDirectory((File)fileservice);
        FileUtils.deleteDirectory((File)backup);
    }

    private void setupDirectory(String directoryName) throws Exception {
        File directory = new File(directoryName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

