/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.SubmitButton;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfSystemOps
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testSystemOps() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Integrity Checker", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
            }
        }, new XsrfCheck.FormSubmission("check")), new XsrfCheck("License Details", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Add Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Edit Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
                TestXsrfSystemOps.this.tester.setFormElement("name", "l1");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                XPathLocator xPathLocator = TestXsrfSystemOps.this.locator.xpath("//tr[td/b/text()='l1']//ul[@class='operations-list']//a[text()='Edit']");
                String editId = xPathLocator.getNodes()[0].getAttributes().getNamedItem("id").getNodeValue();
                TestXsrfSystemOps.this.tester.clickLink(editId);
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
                TestXsrfSystemOps.this.tester.setFormElement("name", "ldel");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")), new XsrfCheck("Mail Queue Flush", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            }
        }, new XsrfCheck.LinkWithTextSubmission("Flush mail queue")), new XsrfCheck("Add Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
                TestXsrfSystemOps.this.tester.setFormElement("name", "name");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.export.ExportService");
            }
        }, new XsrfCheck.FormSubmission("Add Service")), new XsrfCheck("Edit Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
                TestXsrfSystemOps.this.tester.clickLink("edit_10000");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")), new XsrfCheck("ReIndex", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.INDEXING);
            }
        }, new XsrfCheck.AsynchFormSubmission("reindex", 30000L){

            @Override
            public boolean isOperationFinished() {
                TestXsrfSystemOps.this.tester.setWorkingForm("jiraform");
                SubmitButton button = TestXsrfSystemOps.this.tester.getDialog().getSubmitButton("Refresh");
                if (button != null) {
                    TestXsrfSystemOps.this.tester.submit("Refresh");
                }
                return TestXsrfSystemOps.this.tester.getDialog().getResponseText().contains("Re-indexing is 100% complete.");
            }
        })).run(this.funcTestHelperFactory);
    }

    private void gotoHome() {
        this.tester.gotoPage("");
    }
}

