/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfSchemes
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testPermissionSchemeAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddPermissionScheme", new PermissionSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("Add Permission Scheme");
                TestXsrfSchemes.this.tester.setFormElement("name", "New Permission Scheme 1");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditPermissionSchemeDetails", new PermissionSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("10000_edit_details");
                TestXsrfSchemes.this.tester.setFormElement("description", "This is New Permission Scheme 1!");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("CopyPermissionScheme", new PermissionSchemeSetup(), new XsrfCheck.LinkWithIdSubmission("10000_copy")), new XsrfCheck("DeletePermissionScheme", new PermissionSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("del_Copy of New Permission Scheme 1");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("AddPermission", new PermissionSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("New Permission Scheme 1");
                TestXsrfSchemes.this.tester.clickLink("add_perm_" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey());
                TestXsrfSchemes.this.tester.checkCheckbox("type", "reporter");
            }
        }, new XsrfCheck.FormSubmission(" Add ")), new XsrfCheck("DeletePermission", new PermissionSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("New Permission Scheme 1");
                TestXsrfSchemes.this.tester.clickLink("del_perm_" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey() + "_");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    public void testWorkflowSchemeAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddWorkflowScheme", new WorkflowSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("add_workflowscheme");
                TestXsrfSchemes.this.tester.setFormElement("name", "name");
                TestXsrfSchemes.this.tester.setFormElement("description", "desc");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("CopyWorkflowScheme", new WorkflowSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
            }
        }, new XsrfCheck.LinkWithTextSubmission("Copy")), new XsrfCheck("DeleteWorkflowScheme", new WorkflowSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    public void testNotificationSchemeAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddNotificationScheme", new NotificationSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("Add Notification Scheme");
                TestXsrfSchemes.this.tester.setFormElement("name", "name");
                TestXsrfSchemes.this.tester.setFormElement("description", "desc");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditNotificationScheme", new NotificationSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("10010_rename");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("CopyNotificationScheme", new NotificationSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
            }
        }, new XsrfCheck.LinkWithTextSubmission("Copy")), new XsrfCheck("DeleteNotificationScheme", new NotificationSchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    public void testIssueSecuritySchemeAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddIssueSecurityScheme", new IssueSecuritySchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("add_securityscheme");
                TestXsrfSchemes.this.tester.setFormElement("name", "name");
                TestXsrfSchemes.this.tester.setFormElement("description", "desc");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditIssueSecurityScheme", new IssueSecuritySchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLink("edit_10000");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("CopyIssueSecurityScheme", new IssueSecuritySchemeSetup(){

            @Override
            public void setup() {
                super.setup();
            }
        }, new XsrfCheck.LinkWithTextSubmission("Copy")), new XsrfCheck("DeleteIssueSecurityScheme", new IssueSecuritySchemeSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfSchemes.this.tester.clickLinkWithText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    private void gotoDashboard() {
        if (!this.page.isLinkPresentWithExactText("Administration")) {
            this.navigation.gotoDashboard();
        }
    }

    private class IssueSecuritySchemeSetup
    implements XsrfCheck.Setup {
        private IssueSecuritySchemeSetup() {
        }

        @Override
        public void setup() {
            TestXsrfSchemes.this.gotoDashboard();
            TestXsrfSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        }
    }

    private class NotificationSchemeSetup
    implements XsrfCheck.Setup {
        private NotificationSchemeSetup() {
        }

        @Override
        public void setup() {
            TestXsrfSchemes.this.gotoDashboard();
            TestXsrfSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        }
    }

    private class WorkflowSchemeSetup
    implements XsrfCheck.Setup {
        private WorkflowSchemeSetup() {
        }

        @Override
        public void setup() {
            TestXsrfSchemes.this.gotoDashboard();
            TestXsrfSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        }
    }

    private class PermissionSchemeSetup
    implements XsrfCheck.Setup {
        private PermissionSchemeSetup() {
        }

        @Override
        public void setup() {
            TestXsrfSchemes.this.gotoDashboard();
            TestXsrfSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        }
    }
}

