/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfProject
extends FuncTestCase {
    private static final String SUBMIT_ASSOCIATE = "Associate";
    private static final String SUBMIT_SELECT = "Select";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestXsrfProject.xml");
    }

    public void testProjectAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("DeleteProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=10000");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("AddProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
                TestXsrfProject.this.tester.clickLink("add_project");
                TestXsrfProject.this.tester.setFormElement("name", "Test Project");
                TestXsrfProject.this.tester.setFormElement("key", "TST");
                TestXsrfProject.this.tester.setFormElement("lead", "admin");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=10001");
                TestXsrfProject.this.tester.setFormElement("description", "PROJECT FOR MONKEYS");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("EditProjectEmail", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/project/ProjectEmail!default.jspa?projectId=10001");
                TestXsrfProject.this.tester.setFormElement("fromAddress", "mailserver@mailserver");
            }
        }, new XsrfCheck.FormSubmission("update")), new ProjectAssociationXsrfCheck("SelectIssueTypeScheme", "secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=10001", "schemeId", "Copy of Default Issue Type Scheme", null, " OK "), new ProjectAssociationXsrfCheck("SelectNotificationScheme", "/secure/project/SelectProjectScheme!default.jspa?projectId=10001", "schemeIds", "Default Notification Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectPermissionScheme", "/secure/project/SelectProjectPermissionScheme!default.jspa?projectId=10001", "schemeIds", "Copy of Default Permission Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectIssueSecurityScheme", "/secure/project/SelectProjectIssueSecurityScheme!default.jspa?projectId=10001", "newSchemeId", "Test Scheme", "Next >>", SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectFieldConfigurationScheme", "/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=10001", "schemeId", "New Field Config Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectIssueTypeScreenScheme", "/secure/project/SelectIssueTypeScreenScheme!default.jspa?projectId=10001", "schemeId", "Copy of Default Issue Type Screen Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("EditWorkflowScheme", "/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=10001", "schemeId", "New Workflow Scheme", SUBMIT_ASSOCIATE, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectProjectCategory", "/secure/project/SelectProjectCategory!default.jspa?pid=10001", "pcid", "Category One", null, SUBMIT_SELECT)).run(this.funcTestHelperFactory);
    }

    class ProjectAssociationSetup
    implements XsrfCheck.Setup {
        private final String uri;
        private final String inputName;
        private final String inputValue;
        private final String optionalStepSubmit;

        ProjectAssociationSetup(String uri, String inputName, String inputValue, String optionalStepSubmit) {
            this.uri = uri;
            this.inputName = inputName;
            this.inputValue = inputValue;
            this.optionalStepSubmit = optionalStepSubmit;
        }

        @Override
        public void setup() {
            TestXsrfProject.this.tester.gotoPage(this.uri);
            TestXsrfProject.this.tester.selectOption(this.inputName, this.inputValue);
            if (this.optionalStepSubmit != null) {
                TestXsrfProject.this.tester.submit(this.optionalStepSubmit);
            }
        }
    }

    class ProjectAssociationXsrfCheck
    extends XsrfCheck {
        public ProjectAssociationXsrfCheck(String description, String uri, String inputName, String inputValue, String optionalStepSubmit, String formSubmit) {
            super(description, new ProjectAssociationSetup(uri, inputName, inputValue, optionalStepSubmit), new XsrfCheck.FormSubmission(formSubmit));
        }
    }
}

