/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfManageDashboards
extends FuncTestCase {
    private Dashboard addSharedPublicDashboard() {
        return this.navigation.dashboard().addPage(Data.SHARED_PUBLIC_DASHBOARD, null);
    }

    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    public void testDasboardManagementOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Adding Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("create_page");
                TestXsrfManageDashboards.this.tester.setWorkingForm("add-dashboard");
            }
        }, new XsrfCheck.FormSubmissionWithId("add-dashboard-submit")), new XsrfCheck("Restore Default Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("restore_defaults");
                TestXsrfManageDashboards.this.tester.setWorkingForm("jiraform");
            }
        }, new XsrfCheck.FormSubmissionWithId("restore_submit"))).run(this.funcTestHelperFactory);
    }

    public void testDasboardOperations() throws Exception {
        this.addSharedPublicDashboard();
        new XsrfTestSuite(new XsrfCheck("Editing Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("edit_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("edit-dashboard");
            }
        }, new XsrfCheck.FormSubmission("update_submit")), new XsrfCheck("Copy Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("clone_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("add-dashboard");
                TestXsrfManageDashboards.this.tester.setFormElement("portalPageName", "New Name");
            }
        }, new XsrfCheck.FormSubmissionWithId("add-dashboard-submit")), new XsrfCheck("Delete Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("delete_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("delete-portal-page");
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-portal-page-submit"))).run(this.funcTestHelperFactory);
    }

    private static class Data {
        private static final DashboardPageInfo SHARED_PUBLIC_DASHBOARD = new DashboardPageInfo(10014L, "Public - Owner: Admin", null, true, TestSharingPermissionUtils.createPublicPermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);

        private Data() {
        }
    }
}

