/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfAdminSharedFilters
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    private String addFilterSharedWithAllJiraUsers() {
        return this.backdoor.filters().createFilter("", "Public Filter - Owner: Admin", "admin", "jira-users");
    }

    public void testSharedFilterOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Delete Shared Filter", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String filterId = TestXsrfAdminSharedFilters.this.addFilterSharedWithAllJiraUsers();
                TestXsrfAdminSharedFilters.this.administration.sharedFilters().goTo();
                TestXsrfAdminSharedFilters.this.tester.clickLink("delete_" + filterId);
                TestXsrfAdminSharedFilters.this.tester.setWorkingForm("delete-filter-confirm-form-" + filterId);
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-filter-submit"))).run(this.funcTestHelperFactory);
    }

    private static class Data {
        private static final String SHARED_PUBLIC_FILTER_NAME = "Public Filter - Owner: Admin";

        private Data() {
        }
    }
}

