/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.DashboardControl;
import com.google.common.collect.Iterables;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfAdminSharedDashboards
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    private Dashboard addSharedPublicDashboard() {
        return this.navigation.dashboard().addPage(Data.SHARED_PUBLIC_DASHBOARD, null);
    }

    public void testSharedDasboardOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Delete Shared Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminSharedDashboards.this.addSharedPublicDashboard();
                TestXsrfAdminSharedDashboards.this.backdoor.permissions().addGlobalPermission(22, "jira-users");
                Long dashboardId = ((DashboardControl.Dashboard)Iterables.getFirst((Iterable)TestXsrfAdminSharedDashboards.this.backdoor.dashboard().getOwnedDashboard("admin"), null)).getId();
                TestXsrfAdminSharedDashboards.this.administration.sharedDashboards().goTo();
                TestXsrfAdminSharedDashboards.this.tester.clickLink("delete_" + dashboardId);
                TestXsrfAdminSharedDashboards.this.tester.setWorkingForm("delete-portal-page");
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-portal-page-submit"))).run(this.funcTestHelperFactory);
    }

    private static class Data {
        private static final DashboardPageInfo SHARED_PUBLIC_DASHBOARD = new DashboardPageInfo(10014L, "Public - Owner: Admin", null, true, TestSharingPermissionUtils.createPublicPermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);

        private Data() {
        }
    }
}

