/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfAdminScreenSchemes
extends FuncTestCase {
    private static final String SCREEN_SCHEME_NAME = "villainous scheme";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEditCustomFieldDescription.xml");
    }

    public void testScreenSchemeOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Screen Scheme", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
                TestXsrfAdminScreenSchemes.this.tester.clickLink("add-field-screen-scheme");
                TestXsrfAdminScreenSchemes.this.tester.setFormElement("fieldScreenSchemeName", TestXsrfAdminScreenSchemes.SCREEN_SCHEME_NAME);
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Edit Screen Scheme", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
                TestXsrfAdminScreenSchemes.this.tester.clickLink("edit_fieldscreenscheme_villainous scheme");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Copy Screen Scheme", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
                TestXsrfAdminScreenSchemes.this.tester.clickLink("copy_fieldscreenscheme_villainous scheme");
            }
        }, new XsrfCheck.FormSubmission("Copy")), new XsrfCheck("Delete Screen Scheme", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
                TestXsrfAdminScreenSchemes.this.tester.clickLink("delete_fieldscreenscheme_villainous scheme");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    public void testScreenSchemeConfigOperations() throws Exception {
        this.addScreen();
        new XsrfTestSuite(new XsrfCheck("Configure Screen Scheme Add", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.gotoConfigure();
                TestXsrfAdminScreenSchemes.this.tester.clickLink("add-screen-scheme-item");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Configure Screen Scheme Edit", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.gotoConfigure();
                TestXsrfAdminScreenSchemes.this.tester.clickLink("edit_fieldscreenscheme_Create Issue");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Configure Screen Scheme Delete", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminScreenSchemes.this.gotoConfigure();
            }
        }, new XsrfCheck.LinkWithIdSubmission("delete_fieldscreenscheme_Create Issue"))).run(this.funcTestHelperFactory);
    }

    private void addScreen() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
        this.tester.clickLink("add-field-screen-scheme");
        this.tester.setFormElement("fieldScreenSchemeName", SCREEN_SCHEME_NAME);
        this.tester.submit("Add");
    }

    private void gotoConfigure() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_SCREEN_SCHEME);
        this.tester.clickLink("configure_fieldscreenscheme_villainous scheme");
    }
}

