/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfAdminCustomFields
extends FuncTestCase {
    private static final String FIELD_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEditCustomFieldDescription.xml");
    }

    public void testCustomFieldOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Custom Field", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
                TestXsrfAdminCustomFields.this.tester.clickLink("add_custom_fields");
                TestXsrfAdminCustomFields.this.tester.setFormElement("fieldType", TestXsrfAdminCustomFields.FIELD_TYPE);
            }
        }, new XsrfCheck.FormSubmission("nextBtn")), new XsrfCheck("Edit Custom Field", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.addCustomField();
                TestXsrfAdminCustomFields.this.tester.clickLink("edit_superAwesomeField");
                TestXsrfAdminCustomFields.this.tester.setFormElement("name", "superMoreAwesomeField");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Custom Field", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String customFieldId = TestXsrfAdminCustomFields.this.addCustomField();
                TestXsrfAdminCustomFields.this.tester.clickLink("del_" + customFieldId);
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    public void testCustomFieldConfigurationOperations() throws Exception {
        final String customFieldId = this.addCustomField();
        String numericCustomFieldId = customFieldId.split("_")[1];
        final String contextId = this.addCustomFieldContext(numericCustomFieldId);
        new XsrfTestSuite(new XsrfCheck("Configure Custom Field - Add", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
                TestXsrfAdminCustomFields.this.tester.clickLink("config_" + customFieldId);
                TestXsrfAdminCustomFields.this.tester.clickLink("add_new_context");
                TestXsrfAdminCustomFields.this.tester.setFormElement("name", "my context");
                TestXsrfAdminCustomFields.this.tester.selectOption("projects", "homosapien");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Configure Custom Field - Edit", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
                TestXsrfAdminCustomFields.this.tester.clickLink("config_" + customFieldId);
                TestXsrfAdminCustomFields.this.tester.clickLink("edit_" + contextId);
            }
        }, new XsrfCheck.FormSubmission("Modify")), new XsrfCheck("Configure Custom Field - Set Default", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
                TestXsrfAdminCustomFields.this.tester.clickLink("config_" + customFieldId);
                TestXsrfAdminCustomFields.this.tester.clickLink(customFieldId + "-edit-default");
            }
        }, new XsrfCheck.FormSubmission("Set Default")), new XsrfCheck("Configure Custom Field - Delete", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminCustomFields.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
                TestXsrfAdminCustomFields.this.tester.clickLink("config_" + customFieldId);
            }
        }, new XsrfCheck.LinkWithIdSubmission("delete_" + contextId))).run(this.funcTestHelperFactory);
    }

    private String addCustomField() {
        return this.administration.customFields().addCustomField(FIELD_TYPE, "superAwesomeField");
    }

    private String addCustomFieldContext(String numericCustomFieldId) {
        return this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "my context", new String[0], new String[]{"10001"});
    }
}

