/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.priorities;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.Priority;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestPriorities
extends FuncTestCase {
    private void addNewPriority(String name) {
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("iconurl", "/images/icons/priorities/blocker.png");
        this.tester.setFormElement("statusColor", "#efefef");
        this.tester.submit();
    }

    private void assertDuplicatePriorityError() {
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("A priority with that name already exists.");
    }

    private Matcher<Priority> hasPriority(final String id, final String name) {
        return new TypeSafeMatcher<Priority>(){

            public void describeTo(Description description) {
                description.appendText(String.format("Priority(id=%s, name=%s)", id, name));
            }

            protected boolean matchesSafely(Priority priority) {
                return id.equals(priority.getId()) && name.equals(priority.getName());
            }
        };
    }

    public void testDefaultPriorities() {
        this.administration.restoreData("TestPriorities.xml");
        List priorities = this.backdoor.getTestkit().priorities().getPriorities();
        MatcherAssert.assertThat((Object)priorities, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)priorities, (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.hasPriority("1", "Highest"), this.hasPriority("2", "High"), this.hasPriority("3", "Medium"), this.hasPriority("4", "Low"), this.hasPriority("5", "Lowest")}));
    }

    public void testSameName() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PRIORITIES);
        this.addNewPriority("Blocker");
        this.assertDuplicatePriorityError();
        this.addNewPriority("BlocKER");
        this.assertDuplicatePriorityError();
        this.tester.gotoPage("secure/admin/EditPriority!default.jspa?id=2");
        this.tester.setFormElement("name", "Blocker");
        this.tester.submit();
        this.assertDuplicatePriorityError();
        this.tester.setFormElement("name", "blocker");
        this.tester.submit();
        this.assertDuplicatePriorityError();
    }
}

