/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.SCHEMES, Category.ISSUE_TYPES})
public class TestIssueTypeSchemes
extends JIRAWebTest {
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_NAME = "Default Issue Type Scheme";
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_DESC = "Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.";

    public void testIssueTypeSchemesSelectOrder() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemes_Order.xml");
        this.navigation.gotoAdmin();
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        WebForm select = this.tester.getDialog().getResponse().getFormWithName("jiraform");
        String[] values = select.getOptionValues("schemeId");
        TestIssueTypeSchemes.assertEquals((String)"10000", (String)values[0]);
        TestIssueTypeSchemes.assertEquals((String)"10010", (String)values[1]);
        TestIssueTypeSchemes.assertEquals((String)"10013", (String)values[2]);
        TestIssueTypeSchemes.assertEquals((String)"10012", (String)values[3]);
        TestIssueTypeSchemes.assertEquals((String)"10011", (String)values[4]);
    }

    public TestIssueTypeSchemes(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestIssueTypeSchemes.xml");
    }

    public void testIssueTypeSchemesView() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable();
    }

    public void testIssueTypeSchemeCopy() {
        this._testIssueTypeSchemeCopyValidation();
        this._testIssueTypeSchemeCopy();
    }

    public void testIssueTypeSchemeEdit() {
        this._testIssueTypeSchemeEditValidation();
    }

    public void testIssueTypeSchemeDelete() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("delete_10011");
        this.assertTextPresent("Delete Issue Type Scheme: Associated Issue Type Scheme");
        this.assertTextSequence(new String[]{"You are about to delete the Issue Type Scheme named", "Associated Issue Type Scheme"});
        this.assertTextPresent("There is one project (monkey) currently using this scheme. This project will revert to using the default global issue type scheme.");
        this.tester.submit("Delete");
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)3, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.text.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("delete_10010");
        this.assertTextPresent("Delete Issue Type Scheme: Test Issue Type Scheme");
        this.assertTextSequence(new String[]{"You are about to delete the Issue Type Scheme named", "Test Issue Type Scheme"});
        this.assertTextPresent("There are no projects currently using this scheme.");
        this.tester.submit("Delete");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)2, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.text.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.text.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void testIssueTypeSchemeAssociateDefaultScheme() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10000");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertTextPresent("Only projects not currently associated with the default scheme are displayed.");
        this.assertOptionsEqual("projects", new String[]{"monkey"});
        this.tester.selectOption("projects", "monkey");
        this.tester.submit("Associate");
        try {
            Node[] nodes;
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                String schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                String projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                TestIssueTypeSchemes.assertEquals((String)projects, (String)"No projects");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.tester.clickLink("associate_10000");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertTextSequence(new String[]{"No projects available to be associated with scheme", DEFAULT_ISSUE_TYPE_SCHEME_NAME});
        this.assertFormElementNotPresent("projects");
        this.assertSubmitButtonNotPresent("Associate");
    }

    public void testIssueTypeSchemeAssociateSchemeWithProjectAssociation() {
        String projects;
        String schemeName;
        Node[] nodes;
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10011");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertOptionSelected("projects", "monkey");
        this.selectMultiOption("projects", "monkey");
        this.selectMultiOption("projects", "homosapien");
        this.tester.submit("Associate");
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                TestIssueTypeSchemes.assertEquals((String)projects, (String)"homosapien monkey");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.tester.clickLink("associate_10011");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertOptionSelected("projects", "monkey");
        this.assertOptionSelected("projects", "homosapien");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                TestIssueTypeSchemes.assertEquals((String)projects, (String)"homosapien");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void testIssueTypeSchemeAssociateSchemeWithNoProjectAssociation() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10010");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.selectMultiOption("projects", "monkey");
        this.tester.submit("Associate");
        try {
            String projects;
            String schemeName;
            Node[] nodes;
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                TestIssueTypeSchemes.assertEquals((String)projects, (String)"No projects");
            }
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Test Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                TestIssueTypeSchemes.assertEquals((String)projects, (String)"monkey");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void _testIssueTypeSchemeCopyValidation() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10000");
        this.tester.assertFormElementEquals("name", "Copy of Default Issue Type Scheme");
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10010");
        this.tester.assertFormElementEquals("name", "Copy of Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10011");
        this.tester.assertFormElementEquals("name", "Copy of Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    private void _testIssueTypeSchemeCopy() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable(4);
        this.tester.clickLink("copy_10000");
        this.text.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Default Issue Type Scheme");
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10010");
        this.text.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10011");
        this.text.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
    }

    private void _testIssueTypeSchemeEditValidation() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("edit_10000");
        this.tester.assertFormElementEquals("name", DEFAULT_ISSUE_TYPE_SCHEME_NAME);
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("edit_10010");
        this.tester.assertFormElementEquals("name", "Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.clickLink("edit_10011");
        this.tester.assertFormElementEquals("name", "Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    public void gotoIssueTypeSchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
    }

    public void assertCommonIssueTypeSchemesTable() {
        this.assertCommonIssueTypeSchemesTable(4);
    }

    public void assertCommonIssueTypeSchemesTable(int numberOfRows) {
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)numberOfRows, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Operations"});
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.text.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertIssueTypeSchemeFormValidation() {
        this.assertTextNotPresent("You must select at least one option");
        this.assertTextNotPresent("You must enter a valid name.");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("description", "");
        this.tester.submit("save");
        this.assertTextPresent("You must select at least one option");
        this.assertTextPresent("You must enter a valid name.");
        this.tester.setFormElement("name", "test name");
        this.tester.submit("save");
        this.assertTextPresent("You must select at least one option");
        this.assertTextNotPresent("You must enter a valid name.");
    }
}

