/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.SCHEMES})
public class TestIssueTypeSchemeMigration
extends JIRAWebTest {
    public TestIssueTypeSchemeMigration(String name) {
        super(name);
    }

    public void testI18n() {
        this.administration.restoreI18nData("TestIssueTypeSchemeMigrationGerman.xml");
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        TestIssueTypeSchemeMigration.log("Setting baseurl to '" + baseUrl + "'");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.assertions.assertNodeByIdHasText("edit-app-properties", "Einstellungen bearbeiten");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Aktualisieren");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "monkey");
        this.tester.submit(" OK ");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(2);
        this.tester.submit("previousBtn");
        this.assertCurrentStep(1);
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(4);
        XPathLocator finishLocator = this.locator.xpath("//*[@id=\"nextButton\" and @value=\"Fertigstellen\"]");
        TestIssueTypeSchemeMigration.assertNotNull((Object)finishLocator.getNode());
        this.tester.submit("nextBtn");
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    private void assertCurrentStep(int step) {
        XPathLocator locator = new XPathLocator(this.tester, "//*[@id=\"currentStep\" and @value=" + step + " ]");
        TestIssueTypeSchemeMigration.assertNotNull((Object)locator.getNode());
    }

    public void testIssueTypeOptionsCorrectForIssueTypeMapping() {
        this.administration.restoreData("TestIssueTypeSchemeMigration.xml");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.tester.submit(" OK ");
        this.assertTextPresent("Issue Type Migration");
        this.text.assertTextPresent(this.locator.id("summary_table"), "New Feature");
        this.text.assertTextPresent(this.locator.id("summary_table"), "Sub-task ORIG");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(this.locator.css(".jiraform .instructions"), "Sub-task ORIG");
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Another Subtask", "Sub-task DIFFERENT"});
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(this.locator.css(".jiraform .instructions"), "New Feature");
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Improvement", "Bug"});
    }

    public void testIssueTypeSchemeMigrationNoSubtasksMultiProjects() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemeMigrationNoSubtasks.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTableCellHasImage(issueTable, 1, 0, "issuetypes/subtask_alternate.png");
        this.assertTableCellHasImage(issueTable, 2, 0, "issuetypes/newfeature.png");
        this.assertTableCellHasImage(issueTable, 3, 0, "issuetypes/genericissue.png");
        this.assertTableCellHasImage(issueTable, 4, 0, "issuetypes/bug.png");
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertTextPresentAfterText("Another Subtask", "Type:");
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertTextPresentAfterText("New Feature", "Type:");
        this.navigation.issue().gotoIssue("HSP-2");
        this.assertTextPresentAfterText("Sub-task ORIG", "Type:");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertTextPresentAfterText("Bug", "Type:");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10030");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10001");
        this.tester.submit("Associate");
        this.assertTextPresent("There are 2 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10020");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10001");
        this.tester.submit("Associate");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Overview (Step 1 of 6)", "homosapien", "New Feature", "1", "homosapien", "Sub-task ORIG", "1"});
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 2 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien"});
        this.navigation.issue().selectIssueType("Sub-task DIFFERENT");
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 3 of 6)", "Update fields for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien."});
        this.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "New Feature", " in project ", "homosapien"});
        this.navigation.issue().selectIssueType("Bug");
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 5 of 6)", "Update fields for issues with current issue type ", "New Feature", " in project ", "homosapien."});
        this.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.waitAndReloadBulkOperationProgressPage(true);
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTableCellHasImage(issueTable, 1, 0, "issuetypes/subtask_alternate.png");
        this.assertTableCellHasImage(issueTable, 2, 0, "issuetypes/bug.png");
        this.assertTableCellHasImage(issueTable, 3, 0, "issuetypes/genericissue.png");
        this.assertTableCellHasImage(issueTable, 4, 0, "issuetypes/bug.png");
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertTextPresentAfterText("Another Subtask", "Type:");
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertTextPresentAfterText("Bug", "Type:");
        this.navigation.issue().gotoIssue("HSP-2");
        this.assertTextPresentAfterText("Sub-task DIFFERENT", "Type:");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertTextPresentAfterText("Bug", "Type:");
    }

    public void testIssueTypeSchemeMigrationMultiProjectsSecurityLevels() {
        this.administration.restoreData("TestIssueTypeSchemeMigrationSecurityLevel.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertPrecondition();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10060");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10020");
        this.selectMultiOptionByValue("projects", "10021");
        this.selectMultiOptionByValue("projects", "10022");
        this.tester.submit("Associate");
        this.assertTextPresent("There are 5 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.assertPrecondition();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10061");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10020");
        this.selectMultiOptionByValue("projects", "10021");
        this.selectMultiOptionByValue("projects", "10022");
        this.tester.submit("Associate");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Overview (Step 1 of 6)", "Bovine", "Sub-task", "3", "Rattus", "Sub-task", "2"});
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Select a new issue type for issues with current issue type ", "Sub-task", "in project ", "Bovine"});
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 3 of 6)", "All field values will be retained."});
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task", "in project", "Rattus"});
        this.tester.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 5 of 6)", "All field values will be retained."});
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.assertPrecondition();
        this.navigation.issue().gotoIssue("RAT-7");
        this.assertTextPresentAfterText("Level Mouse", "Security");
        this.assertTextPresentAfterText("DIFFERENT SUBTASK", "Type");
        this.navigation.issue().gotoIssue("COW-36");
        this.assertTextPresentAfterText("MyFriendsOnly", "Security");
        this.assertTextPresentAfterText("DIFFERENT SUBTASK", "Type");
    }

    public void testIssueTypeMigrationWithNumericCustomField() {
        this.administration.restoreData("TestIssueTypeMigrationWithNumericCustomField.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10001");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("customfield_10000", "LOREM_IPSUM");
        this.tester.submit("nextBtn");
        this.assertTextPresent("&#39;LOREM_IPSUM&#39; is an invalid number");
        this.assertTextPresent("Issue Type Migration: Update Fields (Step 3 of 4)");
        this.tester.setFormElement("customfield_10000", "857");
        this.tester.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration: Confirmation (Step 4 of 4)");
        this.assertTextPresent("857");
    }

    public void testIssueTypeSchemeMigrationWithSubtasks() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemeMigrationWithSubtasks.xml");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.tester.submit(" OK ");
        this.assertTextPresent("Issue Type Migration");
        WebTable summaryTable = this.getDialog().getResponse().getTableWithID("summary_table");
        TestIssueTypeSchemeMigration.assertTrue((boolean)this.tableCellHasText(summaryTable, 1, 1, "Bug"));
        TestIssueTypeSchemeMigration.assertTrue((boolean)this.tableCellHasText(summaryTable, 2, 1, "Sub-task ORIG"));
        this.tester.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration");
        this.navigation.issue().selectIssueType("New Feature");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration");
        this.navigation.issue().selectIssueType("Sub-task DIFFERENT");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertTextPresent("New Feature");
        this.navigation.issue().gotoIssue("HSP-2");
        this.assertTextPresent("Sub-task DIFFERENT");
    }

    private void assertPrecondition() {
        this.navigation.issueNavigator().displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
    }
}

