/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.IssueTypeControl;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING, Category.ISSUE_TYPES})
public class TestIssueTypeDeleteFieldConfig
extends FuncTestCase {
    public void testIssueTypeDeleteWithDanglingFieldConfigs() {
        this.administration.restoreData("TestDeleteIssueTypeWithDanglingFieldConfig.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.assertTextPresent("Issue Type To Delete");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=5");
        this.tester.submit("Delete");
        this.text.assertTextPresent(this.locator.css("h2"), "Issue Types");
        this.tester.assertTextNotPresent("Issue Type To Delete");
    }

    public void testIssueTypeDeleteWithExistingFieldConfigs() {
        this.administration.restoreBlankInstance();
        IssueTypeControl.IssueType type = this.backdoor.issueType().createIssueType("Defunkt Issue Type");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Silly Field");
        this.tester.selectOption("issuetypes", "Defunkt Issue Type");
        this.tester.submit("nextBtn");
        this.tester.submit("Update");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=" + type.getId());
        this.tester.submit("Delete");
        this.text.assertTextPresent(this.locator.css("h2"), "Issue Types");
        this.tester.assertTextNotPresent("Defunkt Issue Type");
    }

    public void testIssueTypeDeleteWithDeletedFieldConfigs() {
        this.administration.restoreBlankInstance();
        IssueTypeControl.IssueType type = this.backdoor.issueType().createIssueType("Defunkt Issue Type");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Silly Field");
        this.tester.selectOption("issuetypes", "Defunkt Issue Type");
        this.tester.submit("nextBtn");
        this.tester.submit("Update");
        this.tester.clickLink("del_customfield_10000");
        this.tester.submit("Delete");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=" + type.getId());
        this.tester.submit("Delete");
        this.text.assertTextPresent(this.locator.css("h2"), "Issue Types");
        this.tester.assertTextNotPresent("Defunkt Issue Type");
    }
}

