/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.index;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING, Category.WORKLOGS})
public class TestIndexingInBackground
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.applicationProperties().setOption("jira.default.timezone", true);
    }

    public void testBackgroundReindexingSmokeTest() throws Exception {
        String summary = "first issue!";
        String reporter = "admin";
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        new BackgroundReindex().run().waitForCompletion();
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        SearchResult all = this.backdoor.search().getSearch(new SearchRequest());
        Assert.assertThat((Object)all.total, (Matcher)Matchers.equalTo((Object)1));
        Issue issue = (Issue)all.issues.get(0);
        Assert.assertThat((Object)issue.key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
        Assert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.equalTo((Object)"first issue!"));
        Assert.assertThat((Object)issue.fields.reporter.name, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    public void testEditingAnIssueDuringABackgroundReindexShouldNotCauseLostUpdates() throws Exception {
        final IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.runConcurrently(new Runnable(){

            @Override
            public void run() {
                TestIndexingInBackground.this.sleep(1100);
                TestIndexingInBackground.this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
                TestIndexingInBackground.this.backdoor.issues().assignIssue(testIssue.key(), "fred");
                SearchResult results = TestIndexingInBackground.this.backdoor.search().getSearch(new SearchRequest().jql("assignee = fred"));
                Assert.assertThat((String)"Single issue indexing during background reindex did not work", (Object)results.total, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((String)"Single issue indexing during background reindex did not work", (Object)((Issue)results.issues.get((int)0)).key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
            }
        }).waitForCompletion();
        SearchResult results = this.backdoor.search().getSearch(new SearchRequest().jql("assignee = fred"));
        Assert.assertThat((Object)results.total, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Detected lost update in index", (Object)((Issue)results.issues.get((int)0)).key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
    }

    public void testBackgroundReindexWillReindexIssueEvenIfPreviousIndexingOperationWasLost() throws Exception {
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.sleep(1100);
        this.backdoor.issueNavControl().touch(testIssue.key());
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)false));
        this.backdoor.indexing().startInBackground().waitForCompletion();
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)true));
    }

    public void testBackgroundReindexWithComments() throws Exception {
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        this.backdoor.issues().commentIssue(testIssue.key, "First searchable comment. Magic word is hamster");
        IssueCreateResponse testIssue2 = this.backdoor.issues().createIssue("HSP", "second issue!", "admin");
        this.backdoor.issues().commentIssue(testIssue2.key, "Second searchable comment. Magic word is Basil");
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deindex(testIssue.key);
        this.backdoor.indexing().deindex(testIssue2.key);
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("reporter WAS admin"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ISSUE_ONLY).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        TestIndexingInBackground.assertEquals((int)1, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ magic"));
        TestIndexingInBackground.assertEquals((int)2, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        TestIndexingInBackground.assertEquals((int)2, (int)result.issues.size());
    }

    public void testConfigChangeDuringIndexGetsNewMessage() throws Exception {
        this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        BackgroundReindex reindex = new BackgroundReindex();
        this.administration.generalConfiguration().disableVoting();
        this.administration.generalConfiguration().enableVoting();
        this.assertVotingMessage();
        reindex.runConcurrently(new Runnable(){

            @Override
            public void run() {
                TestIndexingInBackground.this.sleep(1100);
                TestIndexingInBackground.this.administration.generalConfiguration().disableVoting();
                TestIndexingInBackground.this.administration.generalConfiguration().enableVoting();
                TestIndexingInBackground.this.assertVotingMessage();
            }
        }).waitForCompletion();
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
    }

    public void testBackgroundReindexWithWorklogs() throws Exception {
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        IssueCreateResponse testIssue2 = this.backdoor.issues().createIssue("HSP", "second issue!", "admin");
        WorklogClient worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        Worklog worklog = new Worklog();
        worklog.started = "2014-08-06T10:49:43.421+0200";
        worklog.timeSpent = "1h";
        worklogClient.post(testIssue.key, worklog);
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deindex(testIssue.key);
        this.backdoor.indexing().deindex(testIssue2.key);
        this.backdoor.indexing().indexDummyIssue(Long.valueOf(testIssue.id), 10000L, "1", testIssue.key, "first issue!", "first issue!");
        this.backdoor.indexing().indexDummyIssue(Long.valueOf(testIssue2.id), 10000L, "1", testIssue2.key, "second issue!", "second issue!");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ISSUE_ONLY).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        TestIndexingInBackground.assertEquals((int)1, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogAuthor=admin"));
        TestIndexingInBackground.assertEquals((int)1, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        TestIndexingInBackground.assertEquals((int)2, (int)result.issues.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueIndexIsCorrupt() throws Exception {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().createIssue("HSP", "An issue which will be indexed " + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReindexWhenIssuesMissing() throws Exception {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().createIssue("HSP", "An issue which will be indexed " + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
            TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReindexWhenExtraIssues() throws Exception {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        try {
            for (int i = 0; i < 20; ++i) {
                this.backdoor.indexing().indexDummyIssue(1000 + i, 10000L, "1", "HSP-" + (1000 + i), "New issue summary " + i, "new issue description" + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)40, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            new BackgroundReindex().run().waitForCompletion();
            TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
            TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommentIndexIsCorrupt() throws Exception {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
        TestIndexingInBackground.assertEquals((int)20, (int)result.issues.size());
        TestIndexingInBackground.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().assignIssue("MKY-1", "admin");
                this.backdoor.issues().assignIssue("MKY-2", "admin");
                this.backdoor.issues().assignIssue("MKY-3", "admin");
                this.backdoor.issues().assignIssue("MKY-4", "admin");
                this.backdoor.issues().assignIssue("MKY-5", "admin");
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            TestIndexingInBackground.assertEquals((int)5, (int)result.issues.size());
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            TestIndexingInBackground.assertEquals((int)0, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            this.backdoor.issues().commentIssue("MKY-1", "This is a comment again");
            this.backdoor.issues().commentIssue("MKY-2", "This is a comment again");
            this.backdoor.issues().commentIssue("MKY-3", "This is a comment and again");
            this.backdoor.issues().commentIssue("MKY-4", "This is a comment");
            this.backdoor.issues().commentIssue("MKY-5", "This is a comment");
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            TestIndexingInBackground.assertEquals((int)3, (int)result.issues.size());
            TestIndexingInBackground.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    private void assertVotingMessage() {
        this.assertMessage("Voting");
    }

    private void assertMessage(String section) {
        this.assertions.getTextAssertions().assertTextPresent("configuration changes were made to \\'" + section + "\\' by " + "Administrator");
    }

    void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    class BackgroundReindex {
        final IssueIndexingParams issueIndexingParams;
        private IndexingControl.IndexingProgress progress;

        BackgroundReindex() {
            this.issueIndexingParams = IssueIndexingParams.INDEX_ISSUE_ONLY;
        }

        BackgroundReindex(IssueIndexingParams issueIndexingParams) {
            this.issueIndexingParams = issueIndexingParams;
        }

        public BackgroundReindex run() {
            this.progress = TestIndexingInBackground.this.backdoor.indexing().startInBackground(this.issueIndexingParams);
            return this;
        }

        public BackgroundReindex waitForCompletion() {
            this.progress.waitForCompletion();
            return this;
        }

        public BackgroundReindex runConcurrently(final Runnable testCode) {
            TestIndexingInBackground.this.backdoor.barrier().raiseBarrierAndRun("backgroundReindex", new Runnable(){

                @Override
                public void run() {
                    BackgroundReindex.this.run();
                    TestIndexingInBackground.this.backdoor.indexing().getInBackgroundProgress().waitForIndexingStarted();
                    testCode.run();
                }
            });
            return this;
        }
    }
}

