/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.WebTable;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestSystemInfoPage
extends FuncTestCase {
    @Override
    protected void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
        super.tearDownTest();
    }

    public void testInstallationType() {
        String installationType = this.getEnvironmentData().getReleaseInfo();
        TestSystemInfoPage.assertFalse((String)"You must have the 'jira.release.info' property set in your localtest.properties", (boolean)StringUtils.isBlank((String)installationType));
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Installation Type", installationType});
    }

    public void testSupportRequestContainsMemoryAndInputArgsInfo() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        if (!this.isSunJVM()) {
            if (this.isJvmWithPermGen()) {
                this.tester.assertTextNotPresent("PermGen Memory Graph");
            }
            this.tester.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.tester.assertTextPresent("JVM Input Arguments");
            if (this.isJvmWithPermGen()) {
                this.tester.assertTextPresent("Used PermGen Memory");
                this.tester.assertTextPresent("Free PermGen Memory");
                this.tester.assertTextPresent("PermGen Memory Graph");
            }
            this.tester.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    public void testSystemInfoContainsTimezoneInfo() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("system_info_table");
        String systemTime = table.getCellAsText(2, 1).trim();
        TestSystemInfoPage.assertTrue((String)("System time does not contain GMT offset '" + systemTime + "'"), (boolean)systemTime.matches(".*[-+]\\d{4}"));
        String timezoneLabel = table.getCellAsText(12, 0);
        TestSystemInfoPage.assertEquals((String)"User Timezone", (String)timezoneLabel.trim());
        String timezoneValue = table.getCellAsText(12, 1);
        TestSystemInfoPage.assertTrue((String)("Timezone value not present in text '" + timezoneValue + "'"), (timezoneValue.trim().length() > 0 ? 1 : 0) != 0);
    }

    public void testApplicationPropertiesPresent() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTextInTable("application_properties", "jira.baseurl");
        this.tester.assertTextInTable("application_properties", "jira.option.voting");
        this.tester.assertTextInTable("application_properties", "jira.option.watching");
        this.tester.assertTextNotInTable("application_properties", "License Hash 1");
        this.tester.assertTextNotInTable("application_properties", "License Hash 1 Text");
        this.tester.assertTextNotInTable("application_properties", "License Message");
        this.tester.assertTextNotInTable("application_properties", "License Message Text");
        this.tester.assertTextNotInTable("application_properties", "License20");
        this.tester.assertTextNotInTable("application_properties", "jira.sid.key");
        this.tester.assertTextNotInTable("application_properties", "org.apache.shindig.common.crypto.BlobCrypter:key");
    }

    public void testSystemInfoContainsJiraHome() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTextInTable("file_paths", "Location of JIRA Local Home");
    }

    public void testLicenseInfoMaintenanceStatus() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTableRowsEqual("license_info", 3, (String[][])new String[][]{{"Maintenance Status", "Supported"}});
        this.administration.switchToLicense(LicenseKeys.V2_EVAL_EXPIRED.getLicenseString(), "Evaluation");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTableRowsEqual("license_info", 3, (String[][])new String[][]{{"Maintenance Status", "Expired"}});
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTableRowsEqual("license_info", 4, (String[][])new String[][]{{"Maintenance Status", "Unsupported"}});
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        int lastRow = this.page.getHtmlTable("jirainfo").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow, 1), "Deutsch (Deutschland)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow - 1, 1), "Deutsch (Deutschland)");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        int lastRow = this.page.getHtmlTable("jirainfo").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow, 1), "alem\u00e1n (Alemania)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow - 1, 1), "espa\u00f1ol (Espa\u00f1a)");
    }

    private boolean isBeforeJdk15() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJavaBeforeJdk15();
    }

    private boolean isJvmWithPermGen() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJvmWithPermGen();
    }

    private boolean isSunJVM() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isSunJVM();
    }
}

