/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.PERMISSIONS})
public class TestSystemAdminAndAdminPermissions
extends FuncTestCase {
    private static final String MAIL_SERVER_ADMINISTRATION_URL = "/secure/admin/OutgoingMailServers.jspa";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_TEXT = "mail server";
    private static final String NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR = "//*[@id='no-mail-server-setup-warning']";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR = "//*[@id='no-mail-server-setup-warning']/a";
    private static final String CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR = "//*[@id='configure_mail_server']/../..[@class='desc-wrap']";
    private static final String CONFIGURE_MAIL_SERVER_LINK_TEXT = "configure";
    private static final String VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR = ".formtitle";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSystemAdminAndAdminPermissions.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAdminFromJiraUsers() {
        try {
            this.administration.usersAndGroups().removeUserFromGroup("nonsystemadmin", "jira-users");
            this.navigation.login("nonsystemadmin", "nonsystemadmin");
            this.tester.assertLinkPresent("log_out");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testRemoveSysAdminFromJiraUsers() {
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    public void testRemoveSysAdminFromAdminsAndJiraUsers() {
        this.administration.usersAndGroups().addGroup("systemadmins");
        this.administration.addGlobalPermission(44, "systemadmins");
        this.administration.usersAndGroups().addUserToGroup("admin", "systemadmins");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("back it up first");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("back it up first");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("", "backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("", "backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.administration.workflows().goTo();
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("do a full backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.administration.workflows().goTo();
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("do a full backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkNotPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkNotPresent("edituser_link_root");
            this.tester.assertLinkNotPresent("deleteuser_link_root");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkPresent("edituser_link_root");
            this.tester.assertLinkPresent("deleteuser_link_root");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
            this.tester.assertLinkNotPresentWithText("Edit Settings");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditAttachmentSettings.jspa?thumbnailsEnabled=true"));
            this.tester.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
            this.tester.assertLinkPresentWithText("Edit Settings");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanNotElevateHisPrivilegesBySettingSysAdminPassword() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=root");
            this.text.assertTextNotPresent(this.locator.page(), "Set Password");
            this.text.assertTextPresent(this.locator.page(), "This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.gotoPage("/secure/admin/user/SetPassword!default.jspa?name=root");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("user-edit-password-submit");
            this.text.assertTextNotPresent(this.locator.page(), "has successfully been set ");
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Must be a System Administrator to reset a System Administrator's password");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=admin");
            this.text.assertTextPresent(this.locator.page(), "Set Password");
            this.tester.gotoPage("secure/admin/user/SetPassword!default.jspa?name=admin");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("user-edit-password-submit");
            this.assertions.getJiraFormAssertions().assertFormSuccessMsg("has successfully been set");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanViewAllServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object)new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("A Debugging Service", "com.atlassian.jira.service.services.DebugService"), (Object)new ViewServices.Service("Backup JIRA", "com.atlassian.jira.service.services.export.ExportService"), (Object)new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("Mail Queue Service", "com.atlassian.jira.service.services.mail.MailQueueService"));
            this.navigation.logout();
            this.navigation.login("root", "root");
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)actualListOfServices.containsAll((Collection<?>)expectedListOfServices));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanOnlySeePopAndImapServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object)new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService"));
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)expectedListOfServices.equals(actualListOfServices));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanAddABuiltInServiceThatIsNeitherAnImapNorPop() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ViewServices.Service serviceToAdd = new ViewServices.Service("Another Backup JIRA", "com.atlassian.jira.service.services.export.ExportService");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo().add(serviceToAdd, "10");
            Set<ViewServices.Service> existingServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)existingServices.contains(serviceToAdd));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanOnlyAddPopAndImapServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.services().goTo();
            this.tester.assertFormNotPresent("jiraform");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanOnlySeePopServers() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            MailServerAdministration.MailServerConfiguration expectedPopConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "dummy", "dummy");
            this.navigation.gotoAdmin();
            TestSystemAdminAndAdminPermissions.assertFalse((String)"Admin should not be able to see list of smtp servers", (boolean)this.administration.mailServers().Smtp().goTo().isPresent());
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)this.administration.mailServers().Pop().goTo().isPresent());
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            TestSystemAdminAndAdminPermissions.assertEquals(actualListOfConfiguredPopServers, (Object)ImmutableList.of((Object)expectedPopConfiguration));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanSeeSmtpAndPopServers() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            MailServerAdministration.MailServerConfiguration expectedPopConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "dummy", "dummy");
            this.navigation.logout();
            this.navigation.login("root", "root");
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)this.administration.mailServers().Smtp().goTo().isPresent());
            TestSystemAdminAndAdminPermissions.assertFalse((boolean)this.administration.mailServers().Smtp().goTo().isConfigured());
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)this.administration.mailServers().Pop().goTo().isPresent());
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            TestSystemAdminAndAdminPermissions.assertEquals(actualListOfConfiguredPopServers, (Object)ImmutableList.of((Object)expectedPopConfiguration));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanAddAPopServer() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            MailServerAdministration.MailServerConfiguration mailServerConfigurationToBeAdded = new MailServerAdministration.MailServerConfiguration("New Pop Server", "dummy", "dummy");
            this.administration.mailServers().Pop().goTo().add(mailServerConfigurationToBeAdded.getName(), mailServerConfigurationToBeAdded.getHostName(), mailServerConfigurationToBeAdded.getUserName(), "dummy");
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)actualListOfConfiguredPopServers.contains(mailServerConfigurationToBeAdded));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanEditAPopServer() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            MailServerAdministration.MailServerConfiguration expectedUpdatedMailServerConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "PIRATES.AYE.AYE.COM", "Barbarossa");
            this.administration.mailServers().Pop().goTo().edit("Dummy POP Server").setHostName("PIRATES.AYE.AYE.COM").setUserName("Barbarossa").setPassword("secure-password").update();
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)Iterables.contains(actualListOfConfiguredPopServers, (Object)expectedUpdatedMailServerConfiguration));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanDeleteAPopServer() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.mailServers().Pop().goTo().delete("Dummy POP Server");
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)Iterables.isEmpty(actualListOfConfiguredPopServers));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanNotAccessSendTestMailByUrlHacking() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage("secure/admin/SendTestMail!default.jspa");
            this.text.assertTextPresent(this.locator.css(".aui-message.warning"), "'Administrator' does not have permission to access this page");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWorkflowFromXmlButtonShouldNotBeDisplayedForAdministrators() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            TestSystemAdminAndAdminPermissions.assertFalse((boolean)this.administration.workflows().goTo().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWorkflowFromXmlButtonShouldBeDisplayedForSystemAdministrators() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)this.administration.workflows().goTo().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    private void assertThatTheCurrentPageIsViewServices() {
        this.text.assertTextSequence(this.locator.css(VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR), "Services", "Add Service");
    }

    private void createNewWorkflowSchemeAndGotoAssociateProject() {
        this.navigation.gotoAdmin();
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("Test").setDefaultWorkflow("Copy of jira"));
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=10000");
    }
}

