/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestServices
extends FuncTestCase {
    private static final String SERVICE_CLASS = "com.atlassian.jira.service.services.DebugService";
    private static final String SERVICE_NAME = "Test Debug Service";
    private static final String SERVICE_PARAM_DESC_1 = "How long to run";
    private static final String SERVICE_PARAM_DESC_2 = "Debug param one";
    private static final String HELLO_WORLD_1 = "hello world 1";
    private static final String HELLO_WORLD_2 = "hello world 2";
    private static final String GOODBYE_WORLD_1 = "goodbye world 1";

    @Override
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testServiceRunner() {
        this.administration.utilities().runServiceNow(10000L);
    }

    public void testAddServiceWithParams() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.tester.setFormElement("name", SERVICE_NAME);
        this.tester.setFormElement("clazz", SERVICE_CLASS);
        this.tester.submit("Add Service");
        this.tester.assertTextPresent(SERVICE_PARAM_DESC_1);
        this.tester.assertTextPresent(SERVICE_PARAM_DESC_2);
        String urlString = this.tester.getDialog().getResponse().getURL().toExternalForm();
        Matcher matcher = Pattern.compile("EditService!default.jspa?.*id=(\\d+)").matcher(urlString);
        if (!matcher.find()) {
            TestServices.fail((String)"Did not get redirected to EditService!default.jspa");
        }
        long id = Long.parseLong(matcher.group(1));
        this.tester.setFormElement("debug param one", HELLO_WORLD_1);
        this.tester.setFormElement("debug param two", HELLO_WORLD_2);
        this.tester.selectOption("service.schedule.interval", "every 2 hours");
        this.tester.selectOption("service.schedule.runToHours", "5");
        this.tester.selectOption("service.schedule.runToMeridian", "pm");
        this.tester.submit("Update");
        this.tester.assertTextPresent(HELLO_WORLD_2);
        this.tester.assertTextPresent(HELLO_WORLD_1);
        this.tester.assertTextPresent("Daily every 2 hours from 1:00 am to 5:00 pm");
        this.tester.clickLink("edit_" + id);
        this.tester.setFormElement("debug param one", GOODBYE_WORLD_1);
        this.tester.checkRadioOption("service.schedule.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("service.schedule.cronString", "0 * * * * ?");
        this.tester.submit("Update");
        this.tester.assertTextPresent(GOODBYE_WORLD_1);
        this.tester.assertTextPresent("0 * * * * ?");
        this.tester.assertTextNotPresent(HELLO_WORLD_1);
        this.tester.clickLink("del_" + id);
        this.tester.assertTextNotPresent(HELLO_WORLD_2);
        this.tester.assertTextNotPresent(HELLO_WORLD_1);
    }
}

