/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.sun.jersey.api.client.UniformInterfaceException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.PERMISSIONS, Category.SCHEMES})
public class TestPermissionSchemes
extends JIRAWebTest {
    private static final String MOVE_TABLE_ID = "move_confirm_table";
    private static final int MOVE_TABLE_FIELD_NAME_COLUMN_INDEX = 0;
    private static final int MOVE_TABLE_OLD_VALUE_COLUMN_INDEX = 1;
    private static final int MOVE_TABLE_NEW_VALUE_COLUMN_INDEX = 2;

    public TestPermissionSchemes(String name) {
        super(name);
    }

    public void testPermissionSchemes() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.project().addProject("neanderthal", "NDT", "admin");
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description for permission schemes", null, null, null);
        this.permissionSchemesCreateScheme();
        this.permissionSchemeAssociateScheme();
        this.permissionSchemeAddDuplicateScheme();
        this.permissionSchemeAddInvalidScheme();
        this.permissionSchemesMoveIssueToProjectWithAssignablePermission(issueKeyNormal);
        this.permissionSchemesMoveIssueWithSchedulePermission(issueKeyNormal);
        this.permissionSchemesMoveIssueToProjectWithCreatePermission(issueKeyNormal);
        this.permissionSchemeDeleteScheme();
        this.navigation.issue().deleteIssue(issueKeyNormal);
    }

    public void testProjectRolePermissionScheme() {
        TestPermissionSchemes.logSection("Test to check that project role permission scheme works");
        this.administration.restoreData("TestSchemesProjectRoles.xml");
        this.gotoPermissionSchemes();
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.tester.clickLink("add_perm_" + ProjectPermissions.MOVE_ISSUES.permissionKey());
        this.tester.assertTextPresent("Choose a project role");
        this.tester.checkCheckbox("type", "projectrole");
        this.tester.selectOption("projectrole", "test role");
        this.tester.submit();
        this.tester.assertTextPresent("(test role)");
    }

    public void permissionSchemesCreateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Create a new permission scheme");
        this.createPermissionScheme("New Permission Scheme", "permission scheme for testing");
        this.tester.assertLinkPresentWithText("New Permission Scheme");
        this.tester.assertTextPresent("permission scheme for testing");
    }

    public void permissionSchemeDeleteScheme() {
        TestPermissionSchemes.log("Permission Schemes:Delete a permission scheme");
        this.deletePermissionScheme("New Permission Scheme");
        this.tester.assertLinkNotPresentWithText("New Permission Scheme");
    }

    public void permissionSchemeAssociateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Associate a permission scheme with a project");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((String)"NDT").permissionScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New Permission Scheme"));
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemeAddDuplicateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Attempt to create a scheme with a duplicate name");
        this.createPermissionScheme("New Permission Scheme", "");
        this.tester.assertTextPresent("Add Permission Scheme");
        this.tester.assertTextPresent("A Scheme with this name already exists.");
    }

    public void permissionSchemeAddInvalidScheme() {
        TestPermissionSchemes.log("Permission Schemes: Attempt to create a scheme with an invalid name");
        this.createPermissionScheme("", "");
        this.tester.assertTextPresent("Add Permission Scheme");
        this.tester.assertTextPresent("Please specify a name for this Scheme.");
    }

    private void permissionSchemesMoveIssueToProjectWithAssignablePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Assign Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.setUnassignedIssuesOption(true);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.setUnassignedIssuesOption(false);
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueWithSchedulePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Schedule Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        try {
            this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        }
        catch (UniformInterfaceException uniformInterfaceException) {
            // empty catch block
        }
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.setDueDateToRequried();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("&quot;Due Date&quot; field is required and you do not have permission to Schedule Issues for project &quot;neanderthal&quot;.");
        this.resetFields();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueToProjectWithCreatePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Create Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "neanderthal", "homosapien", "monkey", "neanderthal"});
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "homosapien", "monkey"});
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }
}

