/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestLookAndFeel
extends FuncTestCase {
    private static final String VERSION_ELEMENT_STR = "<dl style=\"display:none;\" id=\"jira.webresource.flushcounter\">";
    private static final String DEFAULT_LOGO_URL = "/images/icon-jira-logo.png";
    public static final String DEFAULT_FAVICON_URL = "/images/64jira.png";
    public static final String LOGO_PREVIEW_IMAGE_CSS_SELECTOR = "img.application-logo.logo-preview";
    public static final String FAVICON_PREVIEW_IMAGE_CSS_SELECTOR = "img.application-logo.favicon-preview";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.LOOKANDFEEL);
    }

    public void testHasDefaults() throws Exception {
        this.assertHasDefaultLookAndFeel();
    }

    private void assertHasDefaultLookAndFeel() {
        this.assertHasDefaultLogos();
    }

    private void assertHasDefaultLogos() {
        String logoUrlAsDisplayedInThePreview = this.locator.css(LOGO_PREVIEW_IMAGE_CSS_SELECTOR).getNode().getAttributes().getNamedItem("src").getTextContent();
        TestLookAndFeel.assertTrue((boolean)logoUrlAsDisplayedInThePreview.endsWith(DEFAULT_LOGO_URL));
        String favIconUrlAsDisplayedInThePreview = this.locator.css(FAVICON_PREVIEW_IMAGE_CSS_SELECTOR).getNode().getAttributes().getNamedItem("src").getTextContent();
        TestLookAndFeel.assertTrue((boolean)favIconUrlAsDisplayedInThePreview.endsWith(DEFAULT_FAVICON_URL));
    }
}

