/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestIssueType
extends FuncTestCase {
    public void testSameName() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.clickLink("add-issue-type");
        this.addIssueType("Bug");
        this.assertDuplicateIssueTypeErrorAui();
        this.addIssueType("bUG");
        this.assertDuplicateIssueTypeErrorAui();
        this.tester.gotoPage("secure/admin/EditIssueType!default.jspa?id=4");
        this.tester.setFormElement("name", "Bug");
        this.tester.submit();
        this.assertDuplicateIssueTypeErrorAui();
        this.tester.setFormElement("name", "BUG");
        this.tester.submit();
        this.assertDuplicateIssueTypeErrorAui();
    }

    private void assertDuplicateIssueTypeError() {
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("An issue type with this name already exists.");
    }

    private void assertDuplicateIssueTypeErrorAui() {
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("An issue type with this name already exists.");
    }

    private void addIssueType(String name) {
        this.tester.setFormElement("name", name);
        this.tester.submit();
    }
}

