/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestIntegrityChecker
extends FuncTestCase {
    private static final String INTEGRITY_CHECKBOX_TEXT_LOCATOR = "//table[@class='jiraform maxWidth']//td";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testAllIntegrityChecksPresent() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
        this.tester.assertTextPresent("Select one or more integrity checks from the list below to check for out of date information in the database.");
        this.assertIntegrityOptionDescriptionPresent("Select All");
        this.assertIntegrityOptionDescriptionPresent("Check Issue Relations");
        this.assertIntegrityOptionDescriptionPresent("Check Issue for Relation 'ParentProject'");
        this.assertIntegrityOptionDescriptionPresent("Check Issue for Relation 'RelatedOSWorkflowEntry'");
        this.assertIntegrityOptionDescriptionPresent("Check that all Issue Links are associated with valid issues");
        this.assertIntegrityOptionDescriptionPresent("Check Search Request");
        this.assertIntegrityOptionDescriptionPresent("Check search request references a valid project");
        this.assertIntegrityOptionDescriptionPresent("Check for Duplicate Permissions");
        this.assertIntegrityOptionDescriptionPresent("Check the permissions are not duplicated");
        this.assertIntegrityOptionDescriptionPresent("Check Workflow Integrity");
        this.assertIntegrityOptionDescriptionPresent("Check workflow entry states are correct");
        this.assertIntegrityOptionDescriptionPresent("Check workflow current step entries");
        this.assertIntegrityOptionDescriptionPresent("Check JIRA issues with null status");
        this.assertIntegrityOptionDescriptionPresent("Check Field Layout Scheme Integrity");
        this.assertIntegrityOptionDescriptionPresent("Check field layout schemes for references to deleted custom fields");
        this.assertIntegrityOptionDescriptionPresent("Check for invalid filter subscriptions");
        this.assertIntegrityOptionDescriptionPresent("Check FilterSubscriptions for references to non-existent scheduled job");
        this.assertIntegrityOptionDescriptionPresent("Check FilterSubscriptions for references to non-existent SearchRequests");
    }

    private void assertIntegrityOptionDescriptionPresent(String actual) {
        this.assertions.assertNodeHasText(INTEGRITY_CHECKBOX_TEXT_LOCATOR, actual);
    }
}

