/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.IMPORT_EXPORT})
public class TestImportExport
extends JIRAWebTest {
    public TestImportExport(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXmlImportFromNonImportDirectory() throws Exception {
        File data = new File(this.getEnvironmentData().getXMLDataLocation(), "EmptyJira.xml");
        File newData = File.createTempFile("testXmlImportFromNonImportDirectory", ".xml");
        try {
            FileUtils.copyFile((File)data, (File)newData);
            this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
            this.tester.setWorkingForm("restore-xml-data-backup");
            this.tester.setFormElement("filename", newData.getAbsolutePath());
            this.tester.submit();
            this.tester.assertTextPresent("Could not find file at this location");
        }
        finally {
            newData.delete();
        }
    }

    public void testXmlImportWithInvalidIndexDirectory() throws Exception {
        File indexPath = File.createTempFile("testXmlImportWithInvalidIndexDirectory", null);
        indexPath.createNewFile();
        indexPath.deleteOnExit();
        String absolutePath = indexPath.getAbsolutePath();
        this.importExpectingFailure("TestSetupInvalidIndexPath.xml", (Map<String, String>)ImmutableMap.of((Object)"@@INDEX_PATH@@", (Object)absolutePath));
        this.tester.assertTextPresent("Cannot write to index directory. Check that the application server and JIRA have permissions to write to: " + absolutePath);
    }

    public void testXmlImportWithInvalidAttachmentsDirectory() throws Exception {
        File attachmentPath = File.createTempFile("testXmlImportWithInvalidAttachmentsDirectory", null);
        attachmentPath.createNewFile();
        attachmentPath.deleteOnExit();
        String absolutePath = attachmentPath.getAbsolutePath();
        this.importExpectingFailure("TestSetupInvalidAttachmentPath.xml", (Map<String, String>)ImmutableMap.of((Object)"@@ATTACHMENT_PATH@@", (Object)absolutePath));
        this.tester.assertTextPresent("Cannot write to attachment directory. Check that the application server and JIRA have permissions to write to: " + absolutePath);
    }

    private void importExpectingFailure(String xmlFileName, Map<String, String> replacements) throws IOException {
        try {
            this.administration.restoreDataWithReplacedTokens(xmlFileName, replacements);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void testXmlImportFromFuture_Fail() {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "TestXmlImportFromFuture_Fail.xml");
        this.copyFileToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextNotPresent("Your import has been successful");
        this.tester.assertTextPresent("The file you are trying to import is from JIRA 999.9.9, which is newer than your current version of JIRA and will not work. The import file claims it can be successfully imported into JIRA 99.8.7 or later.");
        this.tester.assertTextPresent("If JIRA 99.8.7 is not yet available for download, please contact support.");
    }

    public void testXmlImportFromFuture_DowngradeNoOp() {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "TestXmlImportFromFuture.xml");
        this.copyFileToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You are attempting to import data from JIRA 999.9.9 which is a more recent version than this version.");
        this.tester.assertTextPresent("Some features that you may have used before will not be available in this version of JIRA.");
        this.tester.assertTextPresent("acknowledge this error and proceed anyway.");
    }

    public void testXmlImportWithAV1LicenseInIt() throws Exception {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "oldlicense.xml");
        this.copyFileToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.submit();
        this.administration.waitForRestore();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Invalid license key specified.");
    }
}

