/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestEventTypes
extends JIRAWebTest {
    private final String CUSTOM_EVENT_TYPE_NAME = "Custom Event Type Name";
    private final String CUSTOM_EVENT_TYPE_DESC = "Custom Event Type Description";
    private final String CREATE_EVENT_TYPE_NAME = "Issue Created";
    private final String COMMENT_EVENT_TYPE_NAME = "Issue Commented";
    private final String COMMENT_EDITED_EVENT_TYPE_NAME = "Issue Comment Edited";
    private final String REOPENED_EVENT_TYPE_NAME = "Issue Reopened";
    private final String WORKLOG_UPDATED_EVENT_TYPE_NAME = "Issue Worklog Updated";
    private final String WORKLOG_DELETED_EVENT_TYPE_NAME = "Issue Worklog Deleted";
    private final String GENERIC_EVENT_TYPE_NAME = "Generic Event";
    private final String[] eventOrder = new String[]{"Issue Created", "Issue Commented", "Issue Comment Edited", "Issue Reopened", "Issue Worklog Updated", "Issue Worklog Deleted", "Generic Event", "Custom Event Type Name"};
    private final String CURRENT_ASSIGNEE_NOTIFICATION_TYPE = "Current Assignee";
    private final String CURRENT_ASSIGNEE_NOTIFICATION_CB_CODE = "Current_Assignee";
    private final String GENERIC_EVENT_TEMPLATE = "Generic Event";

    public TestEventTypes(String name) {
        super(name);
    }

    public void testAddEventType() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
    }

    public void testAddEventTypeWithErrors() {
        this.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.setFormElement("name", "");
        this.submit("Add");
        this.assertTextPresent("You must specify an event name");
        this.assertTextPresent("You must select a default template to associate with this event");
        this.setFormElement("name", "Issue Created");
        this.submit("Add");
        this.assertTextPresent("An event with this name already exists");
        this.assertTextPresent("You must select a default template to associate with this event");
    }

    public void testDeleteEventType() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.deleteEventType("Custom Event Type Name");
        this.assertTextNotPresent("Custom Event Type Name");
    }

    public void testEditEventType() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.clickLink("edit_Custom Event Type Name");
        this.assertTextPresent("Update");
        String NEW_NAME = "Custom Event Type New Name";
        String NEW_DESC = "Custom Event Type New Description";
        String NEW_TEMPLATE = "Issue Created";
        this.tester.setFormElement("name", "Custom Event Type New Name");
        this.tester.setFormElement("description", "Custom Event Type New Description");
        this.tester.selectOption("templateId", "Issue Created");
        this.tester.submit("Update");
        this.checkEventTypeDetails("Custom Event Type New Name", "Custom Event Type New Description", "Inactive", "Issue Created", null, null);
    }

    public void testCreateNotificationAssociation() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        String eventTypeId = this.getEventTypeIDWithName("Custom Event Type Name");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.clickLinkWithText("Default Notification Scheme");
        this.clickLink("add_" + eventTypeId);
        this.checkCheckbox("type", "Current_Assignee");
        this.submit("Add");
        this.checkNotificationForEvent("Custom Event Type Name", "Current Assignee", "Generic Event");
        this.checkEventTypeDetails("Custom Event Type Name", "Custom Event Type Description", "Active", "Generic Event", "Default Notification Scheme", null);
    }

    public void testEventDefsOrder() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.assertTextSequence(this.eventOrder);
    }

    public void testNotificationsEventOrder() {
        this.restoreBlankInstance();
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.clickLinkWithText("Default Notification Scheme");
        this.assertTextSequence(this.eventOrder);
        this.clickLink("add_1");
        this.assertTextSequence(this.eventOrder);
    }

    public void testEventWithApostropheDisplaysCorrectly() {
        this.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.setFormElement("name", "This event isn't named nicely");
        this.tester.selectOption("templateId", "Generic Event");
        this.tester.submit("Add");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira").textView().goTo();
        this.tester.clickLink("add_trans_3");
        this.tester.setFormElement("transitionName", "Test transition");
        this.tester.setFormElement("description", "");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Test transition");
        this.tester.clickLinkWithText("Post Functions");
        this.tester.clickLinkWithText("Edit", 1);
        this.tester.selectOption("eventTypeId", "This event isn't named nicely");
        this.tester.submit("Update");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
    }
}

