/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.AdvancedApplicationProperties;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestAdvancedApplicationProperties
extends FuncTestCase {
    private static final String SUBTASK_KEY = "jira.table.cols.subtasks";
    private static final String SUBTASK_COLUMN = "customfield_10000";

    public void testAdvancedSettings() {
        this.administration.restoreBlankInstance();
        AdvancedApplicationProperties properties = this.administration.advancedApplicationProperties();
        TestAdvancedApplicationProperties.assertTrue((properties.getApplicationProperties().size() > 0 ? 1 : 0) != 0);
    }

    public void testSubTaskColumnsAreVisibleWithoutRestart() {
        this.administration.restoreData("TestAdvancedApplicationProperties.xml");
        AdvancedApplicationProperties properties = this.administration.advancedApplicationProperties();
        String subtaskColumns = properties.getApplicationProperty(SUBTASK_KEY);
        subtaskColumns = subtaskColumns + String.format(", %s", SUBTASK_COLUMN);
        properties.setApplicationProperty(SUBTASK_KEY, subtaskColumns);
        this.navigation.issue().viewIssue("HSP-1");
        this.getAssertions().assertNodeHasText(new CssLocator(this.tester, ".customfield_10000"), "You should see this in the subtask column view.");
    }
}

