/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.AdminTabs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestAdminTabs
extends FuncTestCase {
    public void testCorrectTabsShown() throws SAXException {
        if (this.backdoor.darkFeatures().isGlobalEnabled("com.atlassian.jira.darkfeature.CommonHeader")) {
            this.log("The common header is enabled for this instance. Therefore, not running TestAdminTabs as the tabbed administration UI has been no longer exists in JIRA.");
            return;
        }
        this.administration.restoreBlankInstance();
        AdminTabs tabs = this.administration.tabs();
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        TestAdminTabs.assertEquals((String)"Projects", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals((int)0, (int)tabs.getNumberOfTabs());
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CATEGORIES);
        TestAdminTabs.assertEquals((String)"Project Categories", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals((int)0, (int)tabs.getNumberOfTabs());
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        TestAdminTabs.assertEquals((String)"General Configuration", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals((int)0, (int)tabs.getNumberOfTabs());
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        List<AdminTabs.TabGroup> expected = this.createFlatTabs(new AdminTabs.Tab("Issue Types", true), new AdminTabs.Tab("Issue Type Schemes", false), new AdminTabs.Tab("Sub-Tasks", false));
        TestAdminTabs.assertEquals((String)"Issue Types", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
        this.tester.clickLink("subtasks_tab");
        expected = this.createFlatTabs(new AdminTabs.Tab("Issue Types", false), new AdminTabs.Tab("Issue Type Schemes", false), new AdminTabs.Tab("Sub-Tasks", true));
        TestAdminTabs.assertEquals((String)"Issue Types", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
        this.tester.clickLink("issue_type_schemes_tab");
        expected = this.createFlatTabs(new AdminTabs.Tab("Issue Types", false), new AdminTabs.Tab("Issue Type Schemes", true), new AdminTabs.Tab("Sub-Tasks", false));
        TestAdminTabs.assertEquals((String)"Issue Types", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
        this.navigation.gotoAdminSection(Navigation.AdminSection.TIMETRACKING);
        expected = this.createFlatTabs(new AdminTabs.Tab("Time Tracking", true), new AdminTabs.Tab("Issue Linking", false));
        TestAdminTabs.assertEquals((String)"Issue Features", (String)tabs.getPageHeading());
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("view-project-10000");
        expected = CollectionBuilder.newBuilder(new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Summary", true)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Issue Types", false), new AdminTabs.Tab("Workflows", false), new AdminTabs.Tab("Screens", false), new AdminTabs.Tab("Fields", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Versions", false), new AdminTabs.Tab("Components", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Roles", false), new AdminTabs.Tab("Permissions", false), new AdminTabs.Tab("Issue Security", false), new AdminTabs.Tab("Notifications", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Team Shortcuts", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Issue Collectors", false)).asList())).asList();
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
        this.tester.clickLink("view_project_issuesecurity_tab");
        expected = CollectionBuilder.newBuilder(new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Summary", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Issue Types", false), new AdminTabs.Tab("Workflows", false), new AdminTabs.Tab("Screens", false), new AdminTabs.Tab("Fields", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Versions", false), new AdminTabs.Tab("Components", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Roles", false), new AdminTabs.Tab("Permissions", false), new AdminTabs.Tab("Issue Security", true), new AdminTabs.Tab("Notifications", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Team Shortcuts", false)).asList()), new AdminTabs.TabGroup(CollectionBuilder.newBuilder(new AdminTabs.Tab("Issue Collectors", false)).asList())).asList();
        TestAdminTabs.assertEquals(expected, tabs.getCurrentTabs());
    }

    private List<AdminTabs.TabGroup> createFlatTabs(AdminTabs.Tab ... tabs) {
        ArrayList<AdminTabs.TabGroup> ret = new ArrayList<AdminTabs.TabGroup>();
        ret.add(new AdminTabs.TabGroup(Arrays.asList(tabs)));
        return ret;
    }
}

