/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.junit.Ignore;

@Ignore(value="Disabled pending more investigation --lmiranda")
@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestAdminSectionVisibility
extends JIRAWebTest {
    public TestAdminSectionVisibility(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testSysAdminCanSeePages() {
        this.navigation.gotoAdmin();
        this.clickLink("backup_data");
        this.assertTextPresent("Backup JIRA data");
        this.clickLink("restore_data");
        this.assertTextPresent("Restore JIRA data from Backup");
        this.clickLink("jelly_runner");
        this.assertTextPresent("Either specify a path to a Jelly script file or paste");
        this.submit("Run now");
        this.assertTextPresent("Jelly script completed successfully.");
        this.clickLink("listeners");
        this.assertTextPresent("Listeners are used for performing certain actions");
        this.clickLinkWithText("Built-in Listeners");
        this.clickLink("services");
        this.assertTextPresent("Add a new service");
        this.clickLink("license_details");
        this.assertTextPresent("You can use the Update License form");
        this.clickLink("outgoing_mail");
        this.assertTextPresent("The table below shows the SMTP mail server");
        this.clickLinkWithText("Configure new SMTP mail server");
        this.assertTextPresent("Use this page to add a new SMTP mail server");
        this.clickLink("incoming_mail");
        this.assertTextPresent("The table below shows the POP / IMAP mail server");
        this.clickLinkWithText("Add POP / IMAP mail server");
        this.assertTextPresent("Use this page to add a new POP / IMAP mail server");
        this.clickLink("workflows");
        this.clickLinkWithText("import a workflow from XML");
        this.assertTextPresent("It is possible to import a predefined workflow");
        this.clickLink("attachments");
        this.assertTextPresent("To enable a user to attach files,");
        this.clickLinkWithText("Edit Configuration");
        this.clickLink("scheduler_details");
        this.assertTextPresent("This page shows you the properties of the JIRA internal scheduler");
        this.clickLink("integrity_checker");
        this.assertTextPresent("Select one or more integrity checks from");
        this.clickLink("ldap");
        this.assertTextPresent("This page helps you configure JIRA to authenticate");
        this.clickLink("logging_profiling");
        this.assertTextPresent("This page allows you to change the level at which JIRA logs");
        this.clickLink("view_projects");
        this.assertTextPresent("Administration");
        this.assertTextPresent("Below is the list of all 2  projects for this installation of JIRA.");
        this.assertHelpLinkWithStringInUrlPresent("Defining+a+Project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCantSeeProtectedPages() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            String[] urlsToCheck = new String[]{"/secure/admin/OutgoingMailServers.jspa", "/secure/admin/IncomingMailServers.jspa", "/secure/admin/AddSmtpMailServer!default.jspa", "/secure/admin/XmlBackup!default.jspa", "/secure/admin/XmlRestore!default.jspa", "/secure/admin/views/ExternalImport.jspa", "/secure/admin/views/BugzillaImport!default.jspa", "/secure/admin/views/MantisImport!default.jspa", "/secure/admin/views/FogBugzImport!default.jspa", "/secure/admin/views/CsvImporter!default.jspa", "/secure/admin/util/JellyRunner!default.jspa", "/secure/admin/jira/IntegrityChecker!default.jspa", "/secure/admin/jira/LDAPConfigurer!default.jspa", "/secure/admin/jira/ViewLicense.jspa", "/secure/admin/jira/ViewListeners!default.jspa", "/secure/admin/jira/ViewLogging.jspa", "/secure/admin/jira/ConfigureLogging!default.jspa?loggerName=root", "/secure/admin/jira/SchedulerAdmin.jspa", "/secure/admin/jira/ViewServices!default.jspa", "/secure/admin/workflows/ImportWorkflowFromXml!default.jspa", "/secure/project/EnterpriseSelectProjectRepository!default.jspa?projectId=10000"};
            this.checkUrlsForNoPerm(urlsToCheck);
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCantSeeLinks() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.assertLinkNotPresent("outgoing_mail");
            this.assertLinkNotPresent("incoming_mail");
            this.assertLinkNotPresent("backup_data");
            this.assertLinkNotPresent("restore_data");
            this.assertLinkNotPresent("jelly_runner");
            this.assertLinkNotPresent("integrity_checker");
            this.assertLinkNotPresent("ldap");
            this.assertLinkNotPresent("license_details");
            this.assertLinkNotPresent("listeners");
            this.assertLinkNotPresent("logging_profiling");
            this.assertLinkNotPresent("scheduler_details");
            this.assertLinkNotPresent("services");
            this.clickLink("workflows");
            this.assertLinkNotPresentWithText("import a workflow from XML");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    private void checkUrlsForNoPerm(String[] urls) {
        for (String url : urls) {
            this.gotoPage(url);
            this.assertTextPresent("emember my login on this computer");
        }
    }
}

