/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util.issue;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.rules.RestRule;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Element;

public class IssueInlineEdit {
    private LocatorFactory locator;
    private WebTester tester;
    private RestRule restRule;

    public IssueInlineEdit(LocatorFactory locator, WebTester tester, RestRule restRule) {
        this.locator = locator;
        this.tester = tester;
        this.restRule = restRule;
    }

    public void inlineEditField(String issueId, String fieldName, String fieldValue) throws Exception {
        Element node = (Element)this.locator.css("meta[name=atlassian-token]").getNode();
        String token = node.getAttribute("content");
        String body = fieldName + "=" + fieldValue + "&" + "issueId=" + issueId + "&" + "singleFieldEdit=true&" + "fieldsToForcePresent=" + fieldName + "&" + "atl_token=" + token;
        this.POST("AjaxIssueAction.jspa?decorator=none", body);
    }

    private void POST(String url, String postBody) throws Exception {
        this.restRule.before();
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PostMethodWebRequest request = new PostMethodWebRequest(this.restRule.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/x-www-form-urlencoded");
        this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
        this.restRule.after();
    }
}

