/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.webtests.util.ClassLocator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public final class TestClassUtils {
    private static final String FUNC_TEST_PACKAGE = "com.atlassian.jira.webtests.ztests";
    private static final Predicate<Method> IS_TEST_METHOD = new Predicate<Method>(){

        @Override
        public boolean evaluate(Method input) {
            return Modifier.isPublic(input.getModifiers()) && input.getReturnType().equals(Void.TYPE) && input.getParameterTypes().length == 0 && input.getName().startsWith("test");
        }
    };

    private TestClassUtils() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("I'm not meant to be created.");
    }

    public static List<Class<?>> getTestClasses(String packageName, boolean recursive) {
        ClassLocator<Object> classLocator = ClassLocator.forAnyClass().setPackage(packageName).setAllowInner(true).setPredicate(TestPredicate.INSTANCE);
        if (!recursive) {
            classLocator.setLevel(0);
        }
        return classLocator.findClasses();
    }

    public static List<Class<? extends TestCase>> getJUni3TestClasses(String packageName, boolean recursive) {
        ClassLocator<TestCase> classLocator = new ClassLocator<TestCase>(TestCase.class).setPackage(packageName).setAllowInner(true).setPredicate(JUnit3TestPredicate.getInstance());
        if (!recursive) {
            classLocator.setLevel(0);
        }
        return classLocator.findClasses();
    }

    public static List<Class<? extends TestCase>> getJUnit3TestClasses(String packageName) {
        return TestClassUtils.getJUni3TestClasses(packageName, true);
    }

    public static List<Class<? extends TestCase>> getAllFuncTests() {
        return TestClassUtils.getJUnit3TestClasses(FUNC_TEST_PACKAGE);
    }

    public static List<Method> getTestMethods(Class<? extends TestCase> testClass) {
        return new ArrayList<Method>(CollectionUtil.filter(Arrays.asList(testClass.getMethods()), IS_TEST_METHOD));
    }

    private static final class TestPredicate
    implements Predicate<Class<?>> {
        static final TestPredicate INSTANCE = new TestPredicate();

        private TestPredicate() {
        }

        @Override
        public boolean evaluate(Class<?> input) {
            if (!this.hasTestName(input.getSimpleName())) {
                return false;
            }
            int modifiers = input.getModifiers();
            return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers);
        }

        private boolean hasTestName(String simpleName) {
            return simpleName.startsWith("Test") || simpleName.endsWith("Test");
        }
    }

    private static final class JUnit3TestPredicate
    implements Predicate<Class<? extends TestCase>> {
        private static final JUnit3TestPredicate INSTANCE = new JUnit3TestPredicate();

        public static JUnit3TestPredicate getInstance() {
            return INSTANCE;
        }

        private JUnit3TestPredicate() {
        }

        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("I'm a singleton.");
        }

        @Override
        public boolean evaluate(Class<? extends TestCase> input) {
            int modifiers = input.getModifiers();
            return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers);
        }
    }
}

