/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.util.dbc.Assertions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public final class TestCaseMethodNameDetector {
    private static final String WE_ALL_LOVE_HUNGARIAN_NOTATION = "fName";
    private final TestCase testCase;
    private final Class<? extends TestCase> testCaseClass;

    public TestCaseMethodNameDetector(TestCase testCase) {
        this.testCase = Assertions.notNull("testCase", testCase);
        this.testCaseClass = testCase.getClass();
    }

    public Method resolve() {
        if ("warning".equals(this.testCase.getName())) {
            return null;
        }
        Method result = this.resolveByName();
        if (result != null) {
            return result;
        }
        result = this.resolveByModifiedName();
        if (result != null) {
            return result;
        }
        result = this.resolveByHacking();
        if (result == null) {
            throw new IllegalStateException("Unable to resolve test method of <" + this.testCase + ">");
        }
        return result;
    }

    private Method resolveByName() {
        return this.safeGetMethod(this.testCase.getName());
    }

    private Method resolveByModifiedName() {
        String methodName = this.extractMethodName(this.testCase.getName());
        return this.safeGetMethod(methodName);
    }

    private Method resolveByHacking() {
        return this.safeGetMethod(this.extractRealNameByHacking());
    }

    private Method safeGetMethod(String methodName) {
        try {
            return this.testCaseClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private String extractMethodName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private String extractRealNameByHacking() {
        try {
            Field nameField = TestCase.class.getDeclaredField(WE_ALL_LOVE_HUNGARIAN_NOTATION);
            nameField.setAccessible(true);
            return (String)nameField.get(this.testCase);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

