/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.util.Function;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class NativeCommands {
    private static final Logger log = Logger.getLogger(NativeCommands.class);
    private static final int OK = 0;
    private static final int NO_PROCESSES = 1;
    private static final int SYNTAX_ERROR = 2;
    private static final int FATAL_ERROR = 3;
    private static final String FIND_JIRA_REGEX = "java\\s.*\\s-Djira\\.dump=true";
    private static final Pattern FIND_JAVA_PATTERN = Pattern.compile("java\\s", 2);

    private NativeCommands() {
    }

    public static void dumpTomcatThreads() {
        if (SystemUtils.IS_OS_WINDOWS) {
            log.info((Object)"Unable to take thread dump. Only works on Unix.");
            return;
        }
        NativeCommands.outputJavaProcesses(false);
        SimpleProcess process = new SimpleProcess("pkill", "-3");
        String user = NativeCommands.getUser();
        if (user != null) {
            process.addArguments("-U", user);
        }
        process.addArguments("-f", FIND_JIRA_REGEX);
        CommandResult<String> result = process.run();
        if (result != null) {
            switch (((CommandResult)result).returnCode) {
                case 0: {
                    break;
                }
                case 1: {
                    log.info((Object)"Tried to dump JIRA threads but no VMs appeared to exist.");
                    break;
                }
                case 2: {
                    log.error((Object)("Syntax error in pkill command line '" + process.getCommandString() + "'."));
                    break;
                }
                default: {
                    log.error((Object)"pkill failed!");
                }
            }
            String output = StringUtils.stripToNull((String)((String)((CommandResult)result).output));
            if (output != null) {
                log.info((Object)("pkill output: " + (String)((CommandResult)result).output));
            }
        }
    }

    public static void outputProcessTree(boolean currentUserOnly) {
        CommandResult<List<String>> r;
        if (!SystemUtils.IS_OS_MAC_OSX && !SystemUtils.IS_OS_LINUX) {
            log.info((Object)"Unable to generate process tree.");
            return;
        }
        String username = NativeCommands.getUser();
        SimpleProcess process = new SimpleProcess("pstree", new String[0]);
        if (SystemUtils.IS_OS_MAC_OSX) {
            process.addArguments("-w", "-g", "0");
            if (username != null && currentUserOnly) {
                process.addArguments("-u", username);
            }
        } else {
            process.addArguments("-Aulap");
            if (username != null && currentUserOnly) {
                process.addArguments(username);
            }
        }
        if ((r = process.runLines()) != null) {
            if (((CommandResult)r).returnCode == 0) {
                for (String line : (List)((CommandResult)r).output) {
                    log.info((Object)line);
                }
            } else {
                log.error((Object)("Unable to print the process tree. Command exited with '" + ((CommandResult)r).returnCode + "'"));
            }
        }
    }

    public static void outputJavaProcesses(boolean currentUserOnly) {
        block8: {
            CommandResult<List<String>> result;
            String user;
            if (SystemUtils.IS_OS_WINDOWS) {
                log.info((Object)"Unable to list java processes. Only works on Unix.");
                return;
            }
            SimpleProcess process = new SimpleProcess("ps", "-eo", "pid,ppid,user,command");
            if (currentUserOnly && (user = NativeCommands.getUser()) != null) {
                process.addArguments("-u", user);
            }
            if ((result = process.runLines()) == null) break block8;
            if (((CommandResult)result).returnCode == 0) {
                if (((List)((CommandResult)result).output).isEmpty()) {
                    log.info((Object)"No currently running java processes are running.");
                } else {
                    log.info((Object)"The following java processes are currently running on the system: ");
                    for (String line : ((List)((CommandResult)result).output).subList(1, ((List)((CommandResult)result).output).size())) {
                        if (!FIND_JAVA_PATTERN.matcher(line).find()) continue;
                        log.info((Object)("\t" + line));
                    }
                }
            } else {
                log.error((Object)String.format("An error occured while trying to list Java processes (%d):", ((CommandResult)result).returnCode));
                for (String line : (List)((CommandResult)result).output) {
                    log.error((Object)("\t" + line));
                }
            }
        }
    }

    private static String getUser() {
        return StringUtils.stripToNull((String)System.getProperty("user.name"));
    }

    public static void main(String[] args) {
        NativeCommands.outputProcessTree(false);
    }

    private static class SimpleProcess {
        private static final ExecutorService workers = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Simple-Process-%d").build());
        private final List<String> commandLine = new LinkedList<String>();

        public SimpleProcess(String commandLine, String ... arguments) {
            this.commandLine.add(commandLine);
            this.addArguments(arguments);
        }

        public SimpleProcess addArguments(String ... arguments) {
            this.commandLine.addAll(Arrays.asList(arguments));
            return this;
        }

        public CommandResult<List<String>> runLines() {
            return this.runProcess(new Function<InputStream, List<String>>(){

                @Override
                public List<String> get(InputStream input) {
                    try {
                        return IOUtils.readLines((InputStream)input);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public CommandResult<String> run() {
            return this.runProcess(new Function<InputStream, String>(){

                @Override
                public String get(InputStream input) {
                    try {
                        return IOUtils.toString((InputStream)input);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> CommandResult<T> runProcess(final Function<InputStream, T> converter) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(new String[0]).redirectErrorStream(true).command(this.commandLine);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Running command '" + this.getCommandString() + "' in environment:"));
                    this.printEnv(builder.environment(), Level.DEBUG);
                }
                process = builder.start();
            }
            catch (IOException e) {
                log.error((Object)("Unable to start command '" + this.getCommandString() + "'."), (Throwable)e);
                if (!log.isDebugEnabled()) {
                    log.error((Object)"Command environment:");
                    this.printEnv(builder.environment(), Level.ERROR);
                }
                return null;
            }
            final InputStream inputStream = process.getInputStream();
            OutputStream outputStream = process.getOutputStream();
            try {
                Future future = workers.submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return converter.get(inputStream);
                    }
                });
                int result = process.waitFor();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Command '" + this.getCommandString() + "' exited with response " + result + "."));
                }
                CommandResult commandResult = new CommandResult(result, future.get());
                return commandResult;
            }
            catch (InterruptedException e) {
                log.error((Object)("Interrupted while waiting for command '" + this.getCommandString() + "' to finish."), (Throwable)e);
                process.destroy();
            }
            catch (ExecutionException e) {
                Throwable realEx = e;
                if (realEx.getCause() != null && (realEx = realEx.getCause()).getCause() != null) {
                    realEx = realEx.getCause();
                }
                log.error((Object)("Error while processing output for command '" + this.getCommandString() + "' to finish."), realEx);
                process.destroy();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            return null;
        }

        public String getCommandString() {
            return StringUtils.join(this.commandLine, (String)" ");
        }

        private void printEnv(Map<String, String> environment, Level level) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                log.log((Priority)level, (Object)String.format("\t%s = %s.", entry.getKey(), entry.getValue()));
            }
        }
    }

    private static class CommandResult<T> {
        private final int returnCode;
        private final T output;

        private CommandResult(int returnCode, T output) {
            this.returnCode = returnCode;
            this.output = output;
        }
    }
}

