/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AdministrationImpl;
import com.atlassian.jira.functest.framework.DefaultFuncTestHttpUnitOptions;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FormImpl;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.ParserImpl;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.dump.TestCaseDumpKit;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.LogOnBothSides;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.util.IssueTableClient;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentClient;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionClient;
import com.atlassian.jira.webtests.AbstractAtlassianWebTestCase;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.SimpleCell;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Deprecated
public abstract class JIRAWebTest
extends AbstractAtlassianWebTestCase
implements EnvironmentAware,
FunctTestConstants {
    protected JIRAEnvironmentData environmentData;
    protected Navigation navigation;
    protected Form form;
    protected HtmlPage page;
    protected Parser parse;
    protected Administration administration;
    protected Backdoor backdoor;
    protected IssueTableClient issueTableClient;
    protected Assertions assertions;
    protected TextAssertions text;
    protected IssueTableAssertions issueTableAssertions;
    protected FuncTestLogger log;
    protected LocatorFactory locator;
    private FuncTestWebClientListener webClientListener;
    private IssueClient issueClient;
    private long startTime;
    private StopWatch stopWatch = new StopWatch();
    private Supplier<List<IssueTypeControl.IssueType>> issueTypes = Suppliers.memoize((Supplier)new Supplier<List<IssueTypeControl.IssueType>>(){

        public List<IssueTypeControl.IssueType> get() {
            return JIRAWebTest.this.getBackdoor().issueType().getIssueTypes();
        }
    });
    private static final int FIELD_TABLE_FIELD_NAME_COLUMN_INDEX = 0;
    private static final int FIELD_TABLE_OPERATIONS_COLUMN_INDEX = 2;
    private static final String HIDE_FIELD_OPERATION_NAME = "Hide";
    private static final String SHOW_FIELD_OPERATION_NAME = "Show";
    private static final String OPTIONAL_FIELD_OPERATION_NAME = "Optional";
    public static final String FIELD_SCOPE_GLOBAL = "global";
    public static final String PAGE_ISSUE_TYPE_SCREEN_SCHEMES = "/secure/admin/ViewIssueTypeScreenSchemes.jspa";
    public static final String PAGE_ENTERPRISE_FIELD_CONFIGURATIONS = "/secure/admin/ViewFieldLayouts.jspa";
    public static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";
    public static final String PAGE_NOT_STANDARD_VIEW_FIELD_SCREEN_SCHEMES = "/secure/admin/ViewFieldScreenSchemes.jspa";
    private static final String PAGE_TIME_TRACKING = "/secure/admin/jira/TimeTrackingAdmin!default.jspa";
    private static final String PAGE_LINK_TYPES = "/secure/admin/jira/ViewLinkTypes.jspa";
    private static final String PAGE_CUSTOM_FIELDS = "/secure/admin/ViewCustomFields.jspa";
    public static final float JDK_1_5_VERSION = 1.5f;
    public static final String BULK_TRANSITION_ELEMENT_NAME = "wftransition";
    private final String EVENT_TYPE_TABLE = "eventTypeTable";
    private final int EVENT_TYPE_TABLE_NAME_COL = 0;
    private static Set<String> copiedFiles = Collections.synchronizedSet(new HashSet());

    public JIRAWebTest(String name) {
        this(name, new LocalTestEnvironmentData());
    }

    public JIRAWebTest(String name, JIRAEnvironmentData environmentData) {
        super(name);
        this.environmentData = environmentData;
        this.tester = new WebTester();
        this.backdoor = new Backdoor(environmentData);
        this.issueTableClient = new IssueTableClient(environmentData);
    }

    public WebTester getTester() {
        return this.tester;
    }

    public HtmlPage getPage() {
        if (this.page == null) {
            this.page = new HtmlPage(this.tester);
        }
        return this.page;
    }

    public JIRAEnvironmentData getEnvironmentData() {
        if (this.environmentData == null) {
            this.environmentData = new LocalTestEnvironmentData();
        }
        return this.environmentData;
    }

    @Override
    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.environmentData = environmentData;
    }

    public Administration getAdministration() {
        if (this.administration == null) {
            this.administration = new AdministrationImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getAssertions());
        }
        return this.administration;
    }

    public Backdoor getBackdoor() {
        return this.administration.backdoor();
    }

    protected Assertions getAssertions() {
        if (this.assertions == null) {
            this.assertions = new AssertionsImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getLocatorFactory());
        }
        return this.assertions;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.getTester(), this.getEnvironmentData());
        }
        return this.navigation;
    }

    public FuncTestWebClientListener getWebClientListener() {
        return this.webClientListener;
    }

    public String getRedirect() {
        URL url = this.getDialog().getResponse().getURL();
        String queryString = url.getQuery() != null ? '?' + url.getQuery() : "";
        return url.getPath() + queryString;
    }

    public void assertRedirect(String path) {
        JIRAWebTest.assertEquals((String)path, (String)this.getRedirect());
    }

    public void assertRedirectPath(String s) {
        URL url = this.getDialog().getResponse().getURL();
        JIRAWebTest.assertEquals((String)s, (String)url.getPath());
    }

    protected void jiraLog(String message, boolean testStarted) {
        try {
            this.backdoor.getTestkit().logControl().info(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void dumpScreen(String filename) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.getEnvironmentData().getWorkingDirectory().getAbsolutePath() + FS + filename + ".htm")));
            this.dumpResponse(printStream);
            printStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void login(String usernameAndPassword) {
        this.login(usernameAndPassword, usernameAndPassword);
    }

    @Deprecated
    public void login(String username, String password) {
        this.getNavigation().login(username, password);
    }

    @Deprecated
    public void logout() {
        this.getNavigation().logout();
    }

    private Object invoke(Object subject, String methodName, Object[] methodArgs) {
        Class[] params = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            params[i] = methodArgs[i].getClass();
        }
        Method method = null;
        Class<?> clazz = subject.getClass();
        while (method == null) {
            try {
                method = clazz.getDeclaredMethod(methodName, params);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        method.setAccessible(true);
        try {
            return method.invoke(subject, methodArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFormElement(String form, String elementId) {
        WebForm jiraform = null;
        try {
            jiraform = this.getDialog().getResponse().getFormWithName(form);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (jiraform == null) {
            try {
                jiraform = this.getDialog().getResponse().getFormWithID(form);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return this.invoke(jiraform, "getControlWithID", new String[]{elementId});
    }

    public Map getFormParameters(String form) {
        try {
            WebForm jiraform = this.getDialog().getResponse().getFormWithName(form);
            if (jiraform == null) {
                jiraform = this.getDialog().getResponse().getFormWithID(form);
            }
            return (Map)this.invoke(jiraform, "getFormParameters", new Object[0]);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
    }

    public Object getFormParameter(String form, String elementName) {
        Map params = this.getFormParameters(form);
        Object formParameter = params.get(elementName);
        return formParameter;
    }

    public String[] getFormParameterValues(String form, String elementName) {
        return (String[])this.invoke(this.getFormParameter(form, elementName), "getValues", new Object[0]);
    }

    public String getFormElementValue(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (String)this.invoke(formControl, "getValueAttribute", new Object[0]);
    }

    public boolean isFormElementDisabled(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (Boolean)this.invoke(formControl, "isDisabled", new Object[0]);
    }

    public String[] getFormElementValues(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (String[])this.invoke(formControl, "getValues", new Object[0]);
    }

    public void assertOptionSelected(String elementId, String expectedValue) {
        List<String> selectedOptionIds = Arrays.asList(this.getDialog().getForm().getParameterValues(elementId));
        String[] optionValues = this.getDialog().getOptionsFor(elementId);
        for (int i = 0; i < optionValues.length; ++i) {
            String optionValue = optionValues[i];
            if (!optionValue.equals(expectedValue)) continue;
            String expectedValueId = this.getDialog().getOptionValuesFor(elementId)[i];
            JIRAWebTest.assertTrue((String)("Expected option '" + expectedValue + "' for element '" + elementId + "' was not selected"), (boolean)selectedOptionIds.contains(expectedValueId));
            return;
        }
        JIRAWebTest.fail((String)("Expected option value: '" + expectedValue + "' is not a selected value option for '" + elementId + "'"));
    }

    public void assertOptionsEqualIgnoreOrder(String selectName, String[] expectedOptions) {
        List<String> expectedOptionsList = Arrays.asList(expectedOptions);
        List<String> actualOptionsList = Arrays.asList(this.getDialog().getOptionsFor(selectName));
        JIRAWebTest.assertTrue((String)("The expected options '" + expectedOptionsList + "' does not equal '" + actualOptionsList + "'"), (expectedOptionsList.containsAll(actualOptionsList) && actualOptionsList.containsAll(expectedOptionsList) ? 1 : 0) != 0);
    }

    public void assertOptionSelectedById(String elementId, String expectedId) {
        List<String> selectedOptionIds = Arrays.asList(this.getDialog().getForm().getParameterValues(elementId));
        JIRAWebTest.assertTrue((String)("Expected selected option '" + expectedId + "' for element '" + elementId + "'."), (boolean)selectedOptionIds.contains(expectedId));
    }

    public void assertFormElementHasValue(String fieldId, String expectedValue) {
        this.assertFormElementHasValue("jiraform", fieldId, expectedValue);
    }

    public void assertFormElementHasValue(String formNameOrId, String fieldId, String expectedValue) {
        JIRAWebTest.assertEquals((String)expectedValue, (String)this.getFormElementValue(formNameOrId, fieldId));
    }

    public void assertFormElementWithNameHasValue(String fieldName, String expectedValue) {
        this.assertFormElementWithNameHasValue("jiraform", fieldName, expectedValue);
    }

    public void assertFormElementWithNameHasValue(String formNameOrId, String fieldName, String expectedValue) {
        String[] formParameterValues = this.getFormParameterValues(formNameOrId, fieldName);
        if (formParameterValues != null && formParameterValues.length > 0) {
            JIRAWebTest.assertEquals((String)expectedValue, (String)formParameterValues[0]);
        } else {
            JIRAWebTest.fail((String)("Field with name '" + fieldName + "' is null and does not have the expected value '" + expectedValue + "'"));
        }
    }

    public void assertFormTextAreaHasValue(String fieldId, String expectedValue) {
        this.assertFormTextAreaHasValue("jiraform", fieldId, expectedValue);
    }

    public void assertFormTextAreaHasValue(String formNameOrId, String fieldId, String expectedValue) {
        String[] values = this.getFormElementValues(formNameOrId, fieldId);
        if (values != null && values.length > 0) {
            JIRAWebTest.assertEquals((String)values[0].trim(), (String)expectedValue);
            return;
        }
        JIRAWebTest.fail((String)("no values found for '" + fieldId + "'"));
    }

    @Deprecated
    public void clickOnAdminPanel(String adminsubject, String adminpage) {
        this.gotoAdmin();
        if (this.getDialog().isLinkPresent(adminpage)) {
            this.clickLink(adminpage);
        } else {
            this.clickLink(adminsubject);
        }
    }

    @Deprecated
    public long addProject(String name, String key, String lead) {
        return this.administration.project().addProject(name, key, lead);
    }

    public void deleteProject(String project) {
        Project projectByName = this.getProjectByName(project);
        this.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=" + projectByName.id);
        this.assertTextPresent("Delete Project: " + project);
        this.submit("Delete");
    }

    private Project getProjectByName(String projectName) {
        ProjectClient projectClient = new ProjectClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        List projects = projectClient.getProjects();
        for (Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project;
        }
        return null;
    }

    private Component getComponentByname(String projectKey, String componentName) {
        ProjectClient projectClient = new ProjectClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        List components = projectClient.getComponents(projectKey);
        for (Component component : components) {
            if (!component.name.equals(componentName)) continue;
            return component;
        }
        return null;
    }

    private Version getVersionByName(String projectKey, String versionName) {
        ProjectClient projectClient = new ProjectClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        List versions = projectClient.getVersions(projectKey);
        for (Version version : versions) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return null;
    }

    public String addComponent(String projectName, String name) {
        return this.addComponent(projectName, name, null);
    }

    public String addComponent(String projectName, String name, String componentLead) {
        Project project = this.getProjectByName(projectName);
        Component componentByname = this.getComponentByname(project.key, name);
        if (componentByname != null) {
            return "" + componentByname.id;
        }
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        Component component = componentClient.create(new Component().project(project.key).name(name).leadUserName(componentLead));
        return "" + component.id;
    }

    public void deleteComponent(String project, String name) {
        Project projectObj = this.getProjectByName(project);
        Component component = this.getComponentByname(projectObj.key, name);
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        componentClient.delete("" + component.id);
    }

    public String addVersion(String project, String name, String description) {
        JIRAWebTest.log("Adding version '" + name + "' to project '" + project + "'");
        VersionClient versionClient = new VersionClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        Version version = new Version();
        version.project(project).name(name).description(description);
        versionClient.create(version);
        return "" + version.id;
    }

    public void deleteVersion(Long id) {
        new VersionClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData).delete("" + id);
    }

    public void addIssueOnly(String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel, String dueDate) {
        JIRAWebTest.log("Create Issue: Adding issue " + description);
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        if (project != null) {
            Long projectId = this.getBackdoor().project().getProjectId(projectKey);
            this.tester.setFormElement("pid", projectId.toString());
        }
        if (issueType != null) {
            for (IssueTypeControl.IssueType i : (List)this.issueTypes.get()) {
                if (!issueType.equals(i.getName())) continue;
                this.tester.setFormElement("issuetype", i.getId());
            }
        }
        this.setWorkingForm("issue-create");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.setWorkingForm("issue-create");
        this.setFormElement("summary", summary);
        if (priority != null) {
            this.selectOption("priority", priority);
        }
        if (components != null && components.length > 0) {
            for (String component : components) {
                this.selectMultiOption("components", component);
            }
        }
        if (affectsVersions != null && affectsVersions.length > 0) {
            for (String affectsVersion : affectsVersions) {
                this.selectMultiOption("versions", affectsVersion);
            }
        }
        if (fixVersions != null && fixVersions.length > 0) {
            for (String fixVersion : fixVersions) {
                this.selectMultiOption("fixVersions", fixVersion);
            }
        }
        if (assignTo != null) {
            this.selectOption("assignee", assignTo);
        }
        if (originalEstimate != null) {
            this.setFormElement("timetracking", originalEstimate);
        }
        if (environment != null) {
            this.setFormElement("environment", environment);
        }
        if (description != null) {
            this.setFormElement("description", description);
        }
        if (dueDate != null) {
            this.setFormElement("duedate", dueDate);
        }
        if (securityLevel != null) {
            this.selectOption("security", securityLevel);
        }
        this.assertSubmitButtonPresent("Create");
        this.submit();
    }

    public String addIssue(String project, String projectKey, String issueType, String summary) {
        return this.addIssueViaRest(project, projectKey, issueType, summary, "Major", null, null, null);
    }

    public String addIssue(String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel, String dueDate) {
        String issueKey;
        this.addIssueOnly(project, projectKey, issueType, summary, priority, components, affectsVersions, fixVersions, assignTo, environment, description, originalEstimate, securityLevel, dueDate);
        try {
            issueKey = this.extractIssueKey(projectKey);
        }
        catch (Exception e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return issueKey;
    }

    public String addIssueViaRest(String project, String projectKey, String issueType, String summary, String priority, String assignTo, String environment, String description) {
        return this.addIssueViaRestForResponse((String)project, (String)projectKey, (String)issueType, (String)summary, (String)priority, (String)assignTo, (String)environment, (String)description).key;
    }

    public IssueCreateResponse addIssueViaRestForResponse(String project, String projectKey, String issueType, String summary, String priority, String assignTo, String environment, String description) {
        IssueClient issueClient = this.getIssueClient();
        IssueFields fields = new IssueFields().project(ResourceRef.withKey((String)projectKey)).issueType(ResourceRef.withName((String)issueType)).summary(summary);
        if (priority != null) {
            fields = fields.priority(ResourceRef.withName((String)priority));
        }
        if (assignTo != null) {
            fields = fields.assignee(ResourceRef.withName((String)assignTo));
        }
        if (environment != null) {
            fields = fields.environment(environment);
        }
        if (description != null) {
            fields = fields.description(description);
        }
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        IssueCreateResponse response = issueClient.create(request);
        return response;
    }

    private IssueClient getIssueClient() {
        if (this.issueClient == null) {
            this.issueClient = new IssueClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.getEnvironmentData());
        }
        return this.issueClient;
    }

    public String extractIssueKey(String projectKey) throws IOException {
        int endOfIssueKey;
        int projectIdLocation;
        String text = this.getDialog().getResponse().getText();
        String issueKey = text.substring(projectIdLocation = text.indexOf("[" + projectKey) + 1, endOfIssueKey = text.indexOf("]", projectIdLocation));
        if (!issueKey.matches(projectKey + "-\\d+")) {
            JIRAWebTest.fail((String)("Invalid issue key: " + issueKey));
        }
        JIRAWebTest.log("issueKey = " + issueKey);
        return issueKey;
    }

    public String getIssueKeyWithSummary(String summary, String projectKey) {
        return this.backdoor.issueNavControl().getIssueKeyForSummary(summary);
    }

    @Deprecated
    public String getIssueIdWithIssueKey(String issueKey) {
        String issueId;
        this.gotoIssue(issueKey);
        try {
            String text = this.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf(paramName) + paramName.length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
            JIRAWebTest.log("issueId = " + issueId);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue id" + e.getMessage()));
            return "fail";
        }
        return issueId;
    }

    @Deprecated
    public void deleteIssue(String issueKey) {
        this.gotoIssue(issueKey);
        this.deleteCurrentIssue();
    }

    protected final void deleteCurrentIssue() {
        this.clickLink("delete-issue");
        this.setWorkingForm("delete-issue");
        this.submit("Delete");
    }

    public void progressWorkflow(String issueKey, int actionKey, String comment) {
        JIRAWebTest.log(actionKey + ": " + issueKey);
        this.changeWorkflow(issueKey, actionKey);
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", comment);
        this.submit("Transition");
        this.assertTextPresent(comment);
    }

    public void progressAndResolve(String issueKey, int actionKey, String comment) {
        JIRAWebTest.log(actionKey + ": " + issueKey);
        this.changeWorkflow(issueKey, actionKey);
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", comment);
        this.selectOption("resolution", "Fixed");
        this.submit("Transition");
        this.assertTextPresent(comment);
    }

    public void changeWorkflow(String issueKey, int actionKey) {
        this.gotoIssue(issueKey);
        this.clickLink("action_id_" + actionKey);
    }

    public void assignIssue(String issueKey, String comment, String userFullName) {
        this.gotoIssue(issueKey);
        this.clickLink("assign-issue");
        this.selectOption("assignee", userFullName);
        if (comment != null) {
            this.setFormElement("comment", comment);
        }
        this.clickButton("assign-issue-submit");
        this.assertTextPresent(userFullName);
        if (comment != null) {
            this.assertTextPresent(comment);
        }
    }

    @Deprecated
    public void addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
    }

    @Deprecated
    public void addUser(String username, String password, String fullname, String emailAddress) {
        JIRAWebTest.log("Creating User " + username);
        this.gotoPage(PAGE_USER_BROWSER);
        this.clickLink("create_user");
        this.setFormElement("username", username);
        this.setFormElement("password", password);
        this.setFormElement("confirm", password);
        this.setFormElement("fullname", fullname);
        this.setFormElement("email", emailAddress);
        this.submit("Create");
    }

    public void navigateToUser(String username) {
        JIRAWebTest.log("Navigating in UserBrowser to User " + username);
        this.gotoPage(PAGE_USER_BROWSER);
        this.clickLink(username);
    }

    public void deleteUser(String username) {
        JIRAWebTest.log("Deleting User " + username);
        this.navigateToUser(username);
        this.clickLink("deleteuser_link");
        this.submit("Delete");
        this.assertTextNotPresent(username);
    }

    public void runQuickSearch(String searchInput) {
        this.getNavigation().gotoDashboard();
        this.setWorkingForm("quicksearch");
        this.setFormElement("searchString", searchInput);
        this.submit();
    }

    public void displayAllIssues() {
        this.getNavigation().issueNavigator().displayAllIssues();
    }

    public void assertIssueNavigatorDisplaying(String from, String to, String of) {
        this.assertTextSequence(new String[]{from, "?", to, "of", of});
    }

    @Deprecated
    public void gotoIssue(String issueKey) {
        if (issueKey.equals("")) {
            this.getNavigation().issueNavigator().displayAllIssues();
        } else {
            this.getNavigation().issue().gotoIssue(issueKey);
        }
    }

    public void goToProject(String project_name) {
        this.gotoPage("/secure/project/ViewProjects.jspa");
        this.clickLinkWithText(project_name);
    }

    @Deprecated
    public void gotoAdmin() {
        this.getNavigation().gotoAdmin();
    }

    public void gotoNavigator() {
        HTMLElement element = null;
        try {
            element = this.getDialog().getResponse().getElementWithID("searchButton");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (element == null) {
            JIRAWebTest.log("going to Navigator page");
            this.clickLink("find_link");
        } else {
            JIRAWebTest.log("already at Navigator");
        }
    }

    @Deprecated
    public void addUserToGroup(String userName, String groupName) {
        this.navigateToUser(userName);
        this.clickLink("editgroups_link");
        try {
            FormParameterUtil form = new FormParameterUtil(this.tester, "user-edit-groups", "join");
            form.addOptionToHtmlSelect("groupsToJoin", new String[]{groupName});
            form.setFormElement("groupsToJoin", groupName);
            form.submitForm();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.navigateToUser(userName);
        this.assertTextPresent(groupName);
    }

    public void addUserToProjectRole(String userName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        projectRoleClient.addActors(projectByName.key, roleName, null, new String[]{userName});
    }

    public void addGroupToProjectRole(String groupName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        projectRoleClient.addActors(projectByName.key, roleName, new String[]{groupName}, null);
    }

    public void removeUserFromProjectRole(String userName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        projectRoleClient.deleteUser(projectByName.key, roleName, userName);
    }

    public void removeGroupFromProjectRole(String groupName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        projectRoleClient.deleteGroup(projectByName.key, roleName, groupName);
    }

    public void assertUserIsMemberOfGroups(String username, Collection expectedGroupNames) {
        this.navigateToUser(username);
        this.clickLink("editgroups_link");
        this.setWorkingForm("user-edit-groups");
        List<String> userGroupNames = Arrays.asList(this.getDialog().getOptionValuesFor("groupsToLeave"));
        JIRAWebTest.assertEquals((String)("Expected user '" + username + "' to be member of group(s) '" + expectedGroupNames + "' but was '" + userGroupNames + "'"), (int)expectedGroupNames.size(), (int)userGroupNames.size());
        for (Object expectedGroupName1 : expectedGroupNames) {
            String expectedGroupName = (String)expectedGroupName1;
            JIRAWebTest.assertTrue((String)("Expected user '" + username + "' to be member of group(s) '" + expectedGroupNames + "' but was '" + userGroupNames + "'"), (boolean)userGroupNames.contains(expectedGroupName));
        }
    }

    protected void gotoDashboard() {
        this.clickLink("home_link");
    }

    @Deprecated
    public void removeUserFromGroup(String userName, String groupName) {
        this.navigateToUser(userName);
        this.clickLink("editgroups_link");
        this.selectOption("groupsToLeave", groupName);
        this.submit("leave");
        this.navigateToUser(userName);
        this.assertTextNotPresent(groupName);
    }

    @Deprecated
    public void createGroup(String groupName) {
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        if (this.getDialog().isLinkPresentWithText(groupName)) {
            this.clickLinkWithText(groupName);
            this.clickLink("del_" + groupName);
            this.submit("Delete");
        }
        this.setFormElement("addName", groupName);
        this.submit();
        this.assertLinkPresentWithText(groupName);
    }

    @Deprecated
    public void removeGroup(String groupName) {
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        if (this.getDialog().isLinkPresent("del_" + groupName)) {
            this.clickLink("del_" + groupName);
            this.submit("Delete");
        }
    }

    private List<String> fieldNamesToFieldIds(String[] fieldNames) {
        List customFields = this.backdoor.customFields().getCustomFields();
        ImmutableMap.Builder builderCustomFieldsById = ImmutableMap.builder();
        for (CustomFieldResponse customField : customFields) {
            builderCustomFieldsById.put((Object)customField.name, (Object)customField.id);
        }
        ImmutableMap customFieldsById = builderCustomFieldsById.build();
        ImmutableList.Builder builderFieldIds = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            if (!customFieldsById.containsKey(fieldName)) continue;
            builderFieldIds.add(customFieldsById.get(fieldName));
        }
        return builderFieldIds.build();
    }

    public void addColumnToIssueNavigator(String[] fieldNames) {
        this.backdoor.columnControl().addLoggedInUserColumns(this.fieldNamesToFieldIds(fieldNames));
    }

    public void addColumnToIssueNavigatorById(String[] fieldIds) {
        this.backdoor.columnControl().addLoggedInUserColumns(Arrays.asList(fieldIds));
    }

    public void restoreColumnDefaults() {
        this.backdoor.columnControl().restoreLoggedInUserColumns();
    }

    public void createIssueStep1() {
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.assertTextPresent("CreateIssueDetails.jspa");
    }

    public void createIssueStep1(String project, String issueType) {
        this.getNavigation().issue().goToCreateIssueForm(project, issueType);
    }

    public void gotoFieldLayoutSchemes() {
        this.gotoPage("/secure/admin/ViewFieldLayoutSchemes.jspa");
        this.assertTextPresent("View Field Configuration Schemes");
    }

    public void addFieldLayoutScheme(String scheme_name, String scheme_desc) {
        this.gotoFieldLayoutSchemes();
        this.clickLink("add-field-configuration-scheme");
        this.setFormElement("fieldLayoutSchemeName", scheme_name);
        this.setFormElement("fieldLayoutSchemeDescription", scheme_desc);
        this.submit("Add");
    }

    public void deleteFieldLayoutScheme(String scheme_name) {
        this.gotoFieldLayoutSchemes();
        this.clickLink("del_" + scheme_name);
        this.assertTextPresent("Delete Field Configuration Scheme");
        this.assertTextPresent(scheme_name);
        this.submit("Delete");
    }

    public void copyFieldLayout(String fieldLayoutName) {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText("Copy");
        this.assertTextPresent("Copy Field Configuration:");
        this.setFormElement("fieldLayoutName", fieldLayoutName);
        this.submit();
    }

    public void addFieldLayoutSchemeEntry(String issueTypeName, String fieldLayoutName, String schemeName) {
        this.gotoFieldLayoutSchemes();
        this.clickLinkWithText(schemeName);
        this.clickLink("add-issue-type-field-configuration-association");
        this.selectOption("issueTypeId", issueTypeName);
        this.selectOption("fieldConfigurationId", fieldLayoutName);
        this.submit();
        this.assertTextPresent(issueTypeName);
    }

    public void associateFieldLayoutScheme(String project, String issue_type, String scheme_name) {
        Project projectByName = this.getProjectByName(project);
        this.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectByName.id);
        this.assertTextPresent("Field Layout Configuration Association");
        this.selectOption("schemeId", scheme_name);
        this.submit("Associate");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((String)projectByName.key).fieldConfigurationScheme.name, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)scheme_name));
    }

    public void removeAssociationWithFieldLayoutScheme(String project, String issue_type, String scheme_name) {
        Project projectByName = this.getProjectByName(project);
        this.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectByName.id);
        this.assertTextPresent("Field Layout Configuration Association");
        this.selectOption("schemeId", "System Default Field Configuration");
        this.submit("Associate");
    }

    public void setHiddenFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    public void showIssues(String jql) {
        this.gotoPage("/issues/?jql=" + jql);
    }

    private void gotoFieldLayoutOnEnterprise(String fieldLayoutName) {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText(fieldLayoutName);
    }

    public void setShownFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void setRequiredFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.setRequiredField(fieldName);
    }

    public void setOptionalFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, OPTIONAL_FIELD_OPERATION_NAME);
    }

    public void setRequiredField(String fieldName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(fieldName)) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink requiredLink = linkCell.getLinkWith("Required");
                if (requiredLink == null) {
                    JIRAWebTest.fail((String)("Cannot find 'required' link for field '" + fieldName + "'."));
                    continue;
                }
                requiredLink.click();
                return;
            }
            JIRAWebTest.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Cannot click 'required' link for field id '" + fieldName + "'."));
        }
    }

    private void gotoViewIssueFields() {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText("Configure");
        this.assertTextPresent("View Field Configuration");
    }

    public void setRequiredFields() {
        this.resetFields();
        JIRAWebTest.log("Set fields to be required");
        this.gotoViewIssueFields();
        this.setRequiredField("Affects Version/s");
        this.setRequiredField("Fix Version/s");
        this.setRequiredField("Component/s");
    }

    public void setHiddenFields(String fieldName) {
        JIRAWebTest.log("Hide field " + fieldName);
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    public void setShownFields(String fieldName) {
        JIRAWebTest.log("Show field " + fieldName);
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void doFieldOperation(String fieldName, String linkName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(fieldName)) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink link = linkCell.getLinkWith(linkName);
                if (link == null) {
                    JIRAWebTest.log("Link with name '" + linkName + "' does not exist.");
                    return;
                }
                link.click();
                return;
            }
            JIRAWebTest.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Cannot click '" + linkName + "' link for field id '" + fieldName + "'."));
        }
    }

    public void resetFields() {
        JIRAWebTest.log("Restore default field settings");
        this.gotoViewIssueFields();
        if (this.getDialog().isLinkPresentWithText("Restore Defaults")) {
            this.clickLinkWithText("Restore Defaults");
        }
    }

    public void setDueDateToRequried() {
        this.resetFields();
        JIRAWebTest.log("Set 'Due Date' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Due Date");
    }

    public void setSecurityLevelToRequried() {
        this.resetFields();
        JIRAWebTest.log("Set 'Security Level' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Security Level");
    }

    @Deprecated
    public void grantGlobalPermission(int permissionCode, String groupName) {
        this.administration.addGlobalPermission((GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionCode), groupName);
    }

    @Deprecated
    public void removeGlobalPermission(int permissionCode, String groupName) {
        this.administration.removeGlobalPermission((GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionCode), groupName);
    }

    public void createPermissionScheme(String permission_name, String permission_desc) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Add Permission Scheme");
        this.setFormElement("name", permission_name);
        this.setFormElement("description", permission_desc);
        this.submit("Add");
    }

    public void deletePermissionScheme(String permission_name) {
        this.gotoPermissionSchemes();
        this.clickLink("del_" + permission_name);
        this.submit("Delete");
    }

    public void associatePermSchemeToProject(String project, String permission_name) {
        Project projectByName = this.getProjectByName(project);
        this.gotoPage("/secure/project/SelectProjectPermissionScheme!default.jspa?projectId=" + projectByName.id);
        this.selectOption("schemeIds", permission_name);
        this.submit("Associate");
    }

    @Deprecated
    public void removeGroupPermission(String permission_scheme, int permission, String groupName) {
        String permissionKey = LegacyProjectPermissionKeyMapping.getKey(permission);
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        if (this.getDialog().isLinkPresent("del_perm_" + permissionKey + "_" + groupName)) {
            this.clickLink("del_perm_" + permissionKey + "_" + groupName);
            this.submit("Delete");
            this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
            this.assertLinkNotPresent("del_perm_" + permissionKey + "_" + groupName);
        }
    }

    @Deprecated
    public void grantGroupPermission(String permission_scheme, int permission, String groupName) {
        String permissionKey = LegacyProjectPermissionKeyMapping.getKey(permission);
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        if (!this.getDialog().isLinkPresent("del_perm_" + permissionKey + "_" + groupName)) {
            this.clickLink("add_perm_" + permissionKey);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.assertOptionValuesEqual("group", new String[]{"", "jira-administrators", "jira-developers", "jira-users"});
            this.selectOption("group", groupName);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.submit();
        }
    }

    @Deprecated
    public void grantGroupAllPermissions(String permission_scheme, String groupName) {
        String[] optionValues;
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        this.clickLinkWithText("Grant Permission");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-administrators");
        for (String optionValue : optionValues = this.getDialog().getOptionValuesFor("permissions")) {
            this.selectMultiOptionByValue("permissions", optionValue);
        }
        this.submit();
    }

    @Deprecated
    public void removeGroupPermission(int permission, String groupName) {
        this.removeGroupPermission("Default Permission Scheme", permission, groupName);
    }

    @Deprecated
    public void removeRolePermission(int permission, int role) {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, (ProjectPermissionKey)LegacyProjectPermissionKeyMapping.ID_TO_KEY.get((Object)permission), (long)role);
    }

    @Deprecated
    public void grantGroupPermission(int permission, String groupName) {
        this.grantGroupPermission("Default Permission Scheme", permission, groupName);
    }

    @Deprecated
    public void grantRolePermission(int permission, int role) {
        this.backdoor.permissionSchemes().addProjectRolePermission(0L, (ProjectPermissionKey)LegacyProjectPermissionKeyMapping.ID_TO_KEY.get((Object)permission), (long)role);
    }

    public void gotoPermissionSchemes() {
        this.gotoPage("/secure/admin/ViewPermissionSchemes.jspa");
    }

    @Deprecated
    public void grantPermissionToUserCustomField(String permissionScheme, String customFieldName, int permission) {
        String permissionKey = LegacyProjectPermissionKeyMapping.getKey(permission);
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permissionScheme);
        this.clickLink("add_perm_" + permissionKey);
        this.checkCheckbox("type", "userCF");
        this.selectOption("userCF", customFieldName);
        this.submit(" Add ");
        this.assertTextPresent("(" + customFieldName + ")");
    }

    @Deprecated
    public void grantPermissionToReporter(int permission) {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToReporter((ProjectPermissionKey)LegacyProjectPermissionKeyMapping.ID_TO_KEY.get((Object)permission));
    }

    @Deprecated
    public void removePermissionFromUserCustomField(String permissionScheme, String customFieldId, int permission) {
        String permissionKey = LegacyProjectPermissionKeyMapping.getKey(permission);
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permissionScheme);
        this.clickLink("del_perm_" + permissionKey + "_customfield_" + customFieldId);
        this.submit("Delete");
    }

    @Deprecated
    public void activateTimeTracking() {
        this.submitAtPage(PAGE_TIME_TRACKING, "Activate", "time tracking already activated");
    }

    @Deprecated
    public void deactivateTimeTracking() {
        this.submitAtPage(PAGE_TIME_TRACKING, "Deactivate", "time tracking already deactivated");
    }

    public void reconfigureTimetracking(String format) {
        this.gotoPage(PAGE_TIME_TRACKING);
        this.submit("Deactivate");
        this.checkCheckbox("timeTrackingFormat", format);
        this.submit("Activate");
    }

    public void submitAtPage(String url, String button, String logOnFail) {
        this.gotoPage(url);
        if (this.getDialog().hasSubmitButton(button)) {
            this.submit(button);
        } else if (logOnFail != null) {
            JIRAWebTest.log(logOnFail);
        }
    }

    public void logWorkOnIssue(String issueKey, String timeLogged) {
        this.logWorkOnIssueWithComment(issueKey, timeLogged, null);
    }

    public void logWorkOnIssueWithComment(String issueKey, String timeLogged, String comment) {
        this.gotoIssue(issueKey);
        this.clickLink("log-work");
        this.setFormElement("timeLogged", timeLogged);
        if (comment != null) {
            this.setFormElement("comment", comment);
        }
        this.submit();
    }

    @Deprecated
    public void activateIssueLinking() {
        this.submitAtPage(this.getPage().addXsrfToken(PAGE_LINK_TYPES), "Activate", "linking already activated");
    }

    @Deprecated
    public void deactivateIssueLinking() {
        this.submitAtPage(this.getPage().addXsrfToken(PAGE_LINK_TYPES), "Deactivate", "linking already deactivated");
    }

    public String getComponentId(String project, String component) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        return "" + componentByname.id;
    }

    public String getProjectId(String project) {
        return this.getProjectByName((String)project).id;
    }

    public void setComponentLead(String project, String userName, String fullName, String component) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        componentClient.putResponse(componentByname.leadUserName(userName));
    }

    public void setComponentName(String project, String oldComponentName, String newComponentName) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, oldComponentName);
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        componentClient.putResponse(componentByname.name(newComponentName));
    }

    public void clearComponentLead(String project, String component) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        componentClient.putResponse(componentByname.leadUserName(""));
    }

    public void setComponentAssigneeOptions(String project, String component, String option) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        ComponentClient componentClient = new ComponentClient((com.atlassian.jira.testkit.client.JIRAEnvironmentData)this.environmentData);
        if (option.equals("1")) {
            componentByname.assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        } else if (option.equals("2")) {
            componentByname.assigneeType(Component.AssigneeType.PROJECT_LEAD);
        } else {
            componentByname.assigneeType(Component.AssigneeType.UNASSIGNED);
        }
        componentClient.putResponse(componentByname);
    }

    @Deprecated
    public void setUnassignedIssuesOption(boolean enable) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        if (enable) {
            this.getDialog().setFormParameter("allowUnassigned", "true");
            this.assertRadioOptionSelected("allowUnassigned", "true");
        } else {
            this.getDialog().setFormParameter("allowUnassigned", "false");
            this.assertRadioOptionSelected("allowUnassigned", "false");
        }
        this.submit("Update");
    }

    public void setProjectLead(String project, String username) {
        Project projectByName = this.getProjectByName(project);
        this.gotoPage("/secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=" + projectByName.id);
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{username});
        formParameterUtil.setFormElement("lead", username);
        formParameterUtil.submitForm();
    }

    public void voteForIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("vote-state-off")) {
            this.clickLink("toggle-vote-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("vote-state-on"));
        this.assertLinkPresent("toggle-vote-issue");
    }

    public void unvoteForIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("vote-state-on")) {
            this.clickLink("toggle-vote-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("vote-state-off"));
        this.assertLinkPresent("toggle-vote-issue");
    }

    public void startWatchingAnIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("watch-state-off")) {
            this.clickLink("toggle-watch-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("watch-state-on"));
        this.assertLinkPresent("toggle-watch-issue");
    }

    public void startWatchingAnIssue(String issueKey, String[] userNames) {
        this.gotoIssue(issueKey);
        this.clickLink("manage-watchers");
        this.assertTextPresent("Watchers");
        StringBuilder userNameList = new StringBuilder();
        int n = userNames.length;
        for (int i = 0; i < n; ++i) {
            if (i != n - 1) {
                userNameList.append(userNames[i]).append(",");
                continue;
            }
            userNameList.append(userNames[i]);
        }
        this.setFormElement("userNames", userNameList.toString());
        this.submit();
        for (String userName : userNames) {
            this.assertLinkPresent("watcher_link_" + userName);
        }
    }

    public void stopWatchingAnIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("watch-state-on")) {
            this.clickLink("toggle-watch-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("watch-state-off"));
        this.assertLinkPresent("toggle-watch-issue");
    }

    public void removeAllWatchers(String issueKey) {
        this.gotoIssue(issueKey);
        this.clickLink("view-watcher-list");
        this.checkCheckbox("all");
        this.getDialog().setWorkingForm("stopform");
        this.submit();
        this.assertTextPresent("There are no watchers.");
    }

    @Deprecated
    public void activateSubTasks() {
        this.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        if (this.getDialog().isLinkPresent("enable_subtasks")) {
            this.clickLink("enable_subtasks");
        } else {
            JIRAWebTest.log("Subtasks already enabled");
        }
    }

    @Deprecated
    public boolean deactivateSubTasks() {
        JIRAWebTest.log("Deactivating Sub-tasks");
        this.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        if (this.getDialog().isLinkPresent("disable_subtasks")) {
            this.clickLink("disable_subtasks");
        } else {
            JIRAWebTest.log("Sub-tasks already disabled");
        }
        if (this.getDialog().isTextInResponse("Cannot disable subtasks.")) {
            this.deleteAllIssuesInAllPages();
            this.deactivateSubTasks();
            return true;
        }
        this.assertLinkPresentWithText("Enable");
        return false;
    }

    public String addSubTaskToIssue(String issueKey, String subTaskType, String subTaskSummary, String subTaskDescription, String originalEstimate) {
        String subTaskKey;
        this.createSubTaskStep1(issueKey, subTaskType);
        this.setFormElement("summary", subTaskSummary);
        this.setFormElement("description", subTaskDescription);
        if (originalEstimate != null) {
            this.setFormElement("timetracking", "2h");
        }
        this.submit("Create");
        String projectKey = issueKey.substring(0, issueKey.indexOf(45));
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("[" + projectKey) + 1;
            int endOfSubTaskKey = text.indexOf("]", projectIdLocation);
            subTaskKey = text.substring(projectIdLocation, endOfSubTaskKey);
            JIRAWebTest.log("subTaskKey = " + subTaskKey);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return subTaskKey;
    }

    @Deprecated
    public String addSubTaskToIssue(String issueKey, String subTaskType, String subTaskSummary, String subTaskDescription) {
        return this.addSubTaskToIssue(issueKey, subTaskType, subTaskSummary, subTaskDescription, null);
    }

    public void createSubTaskType(String sub_task_name, String sub_task_description) {
        this.activateSubTasks();
        this.setFormElement("name", sub_task_name);
        this.setFormElement("description", sub_task_description);
        this.submit("Add");
        this.deactivateSubTasks();
    }

    public void deleteSubTaskType(String sub_task_name) {
        this.activateSubTasks();
        this.clickLink("del_" + sub_task_name);
        this.submit("Delete");
        this.deactivateSubTasks();
    }

    public void createSubTaskStep1(String issueKey, String task_type) {
        this.activateSubTasks();
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        if (this.getDialog().getElement("issuetype") == null) {
            JIRAWebTest.log("Bypassing step 1 of sub task creation");
        } else {
            this.setWorkingForm("subtask-create-start");
            this.navigation.issue().selectIssueType(task_type);
            this.submit("Create");
        }
        this.assertElementPresent("subtask-create-details");
    }

    public void gotoIssueSecuritySchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
    }

    public void createSecurityScheme(String scheme_name, String scheme_description) {
        this.gotoIssueSecuritySchemes();
        this.clickLink("add_securityscheme");
        this.assertTextPresent("Add Issue Security Scheme");
        this.setFormElement("name", scheme_name);
        this.setFormElement("description", scheme_description);
        this.submit("Add");
    }

    public void createSecurityLevel(String scheme_name, String level_name, String level_description) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.setFormElement("name", level_name);
        this.setFormElement("description", level_description);
        this.submit("Add Security Level");
        this.assertLinkPresent("add_" + level_name);
    }

    public void addGroupToSecurityLevel(String scheme_name, String level_name, String groupName) {
        this.addGroupToSecurityLevel(scheme_name, level_name, groupName, new String[]{"", "jira-administrators", "jira-developers", "jira-users"});
    }

    public void addGroupToSecurityLevel(String scheme_name, String level_name, String groupName, String[] expectedGroups) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("add_" + level_name);
        this.getDialog().setFormParameter("type", "group");
        this.assertRadioOptionSelected("type", "group");
        this.assertOptionValuesEqual("group", expectedGroups);
        this.selectOption("group", groupName);
        this.getDialog().setFormParameter("type", "group");
        this.assertRadioOptionSelected("type", "group");
        this.submit();
    }

    public void addRoleToSecurityLevel(String scheme_name, String level_name, String roleName) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("add_" + level_name);
        this.getDialog().setFormParameter("type", "projectrole");
        this.assertRadioOptionSelected("type", "projectrole");
        this.selectOption("projectrole", roleName);
        this.submit();
    }

    public void removeGroupFromSecurityLevel(String scheme_name, String level_name, String groupName) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delGroup_" + groupName + "_" + level_name);
        this.submit("Delete");
    }

    public void removeRoleFromSecurityLevel(String scheme_name, String level_name, String roleId) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delGroup_" + roleId + "_" + level_name);
        this.submit("Delete");
    }

    public void deleteSecurityScheme(String scheme_name) {
        this.gotoIssueSecuritySchemes();
        this.clickLink("del_" + scheme_name);
        this.assertTextPresent("Delete Issue Security Scheme");
        this.assertTextPresent(scheme_name);
        this.submit("Delete");
    }

    public void deleteSecurityLevel(String scheme_name, String level_name) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delLevel_" + level_name);
        this.assertTextPresent("Delete Issue Security Level: " + level_name);
        this.submit("Delete");
    }

    public void removeAssociationOfSecuritySchemeFromProject(String project_name) {
        this.associateSecuritySchemeToProject(project_name, "None");
    }

    public void associateSecuritySchemeToProject(String project_name, String scheme_name) {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        Project projectByName = this.getProjectByName(project_name);
        this.gotoPage("/secure/project/SelectProjectIssueSecurityScheme!default.jspa?projectId=" + projectByName.id);
        this.selectOption("newSchemeId", scheme_name);
        this.submit();
        this.assertTextPresent("Step 2 of 2");
        this.submit("Associate");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void gotoWorkFlowScheme() {
        this.gotoPage("/secure/admin/ViewWorkflowSchemes.jspa");
    }

    @Deprecated
    public void gotoWorkFlow() {
        this.gotoPage("/secure/admin/workflows/ListWorkflows.jspa");
    }

    public void addWorkFlowScheme(String workflowscheme_name, String workflowscheme_desc) {
        this.gotoWorkFlowScheme();
        this.clickLink("add_workflowscheme");
        this.setFormElement("name", workflowscheme_name);
        this.setFormElement("description", workflowscheme_desc);
        this.submit("Add");
    }

    public void deleteWorkFlowScheme(String workflowscheme_name) {
        this.gotoWorkFlowScheme();
        String linkId = "del_" + workflowscheme_name;
        if (this.getDialog().isLinkPresent(linkId)) {
            this.clickLink(linkId);
            this.submit("Delete");
        } else {
            JIRAWebTest.log("Workflow Scheme" + workflowscheme_name + " already deleted.");
        }
    }

    public void addWorkFlow(String workflow_name, String workflow_desc) {
        this.gotoWorkFlow();
        this.clickLink("add-workflow");
        this.setFormElement("newWorkflowName", workflow_name);
        this.setFormElement("description", workflow_desc);
        this.submit("Add");
    }

    public void deleteWorkFlow(String workflow_name) {
        this.gotoWorkFlow();
        String linkId = "del_" + workflow_name;
        if (this.getDialog().isLinkPresent(linkId)) {
            this.clickLink(linkId);
            this.submit("Delete");
        } else {
            JIRAWebTest.log("Workflow " + workflow_name + " already deleted.");
        }
    }

    @Deprecated
    public void copyWorkFlow(String original_workflow_name, String new_workflow_name, String new_workflow_desc) {
        this.gotoWorkFlow();
        this.clickLink("copy_" + original_workflow_name);
        this.setFormElement("newWorkflowName", new_workflow_name);
        this.setFormElement("description", new_workflow_desc);
        this.submit("Update");
    }

    public void addLinkedStatus(String status_name, String status_desc) {
        this.gotoPage("/secure/admin/AddStatus!default.jspa");
        this.setFormElement("name", status_name);
        this.setFormElement("description", status_desc);
        this.submit("Add");
    }

    public void deleteLinkedStatus(String statusId) {
        this.gotoPage("/secure/admin/ViewStatuses.jspa");
        this.clickLink("del_" + statusId);
        this.submit("Delete");
    }

    public void deleteStep(String workflow_name, String step_name) {
        this.gotoWorkFlow();
        this.clickLink("edit_live_" + workflow_name);
        this.clickLink("workflow-text");
        this.clickLinkWithText(step_name);
        this.clickLink("del_step");
        this.submit("Delete");
    }

    @Deprecated
    public void addTransition(String workflow_name, String step_name, String transition_name, String transition_desc, String destination_step, String transitionFieldScreen) {
        this.gotoWorkFlow();
        this.clickLink("edit_live_" + workflow_name);
        this.clickLink("workflow-text");
        this.navigation.clickLinkWithExactText(step_name);
        this.clickLink("add_transition");
        this.setFormElement("transitionName", transition_name);
        this.setFormElement("description", transition_desc);
        this.selectOption("destinationStep", destination_step);
        if (transitionFieldScreen != null) {
            this.selectOption("view", transitionFieldScreen);
        }
        this.submit("Add");
    }

    public void editTransitionScreen(String workflow_name, String transition_name, String transitionFieldScreen) {
        this.administration.workflows().goTo().workflowSteps(workflow_name);
        this.clickLinkWithText(transition_name);
        this.clickLink("edit_transition");
        this.setFormElement("transitionName", transition_name);
        if (transitionFieldScreen != null) {
            this.selectOption("view", transitionFieldScreen);
        }
        this.submit();
    }

    public void deleteTransition(String workflow_name, String step_name, String transition_name) {
        this.gotoWorkFlow();
        this.clickLink("edit_live_" + workflow_name);
        this.clickLink("workflow-text");
        this.clickLinkWithText(step_name);
        this.clickLink("del_transition");
        this.selectOption("transitionIds", transition_name);
        this.submit("Delete");
    }

    public void activateWorkflow(String workflow_name) {
        this.gotoWorkFlow();
        this.clickLink("activate_" + workflow_name);
        this.submit("Activate");
    }

    public void assignWorkflowScheme(long workflowscheme_id, String issuetype, String workflow_name) {
        this.backdoor.workflowSchemes().updateScheme(this.backdoor.workflowSchemes().getWorkflowScheme(workflowscheme_id).setMapping(issuetype, workflow_name));
    }

    public void unassignWorkflowScheme(String workflowscheme_name, String issuetype, String workflow_name) {
        this.gotoWorkFlowScheme();
        this.clickLinkWithText(workflowscheme_name);
        this.clickLink("del_" + issuetype + "_" + workflow_name);
        this.submit("Delete");
    }

    @Deprecated
    public void associateWorkFlowSchemeToProject(String project, String workflow_scheme) {
        this.associateWorkFlowSchemeToProject(project, workflow_scheme, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertIndexedFieldCorrect(String path, Map expectedItemNodes, Map unexpectedItemNodes, String issueKey) {
        try {
            String xpathExpression;
            String expectedValue;
            String itemNode;
            Map.Entry pairs;
            Map.Entry o;
            Iterator i$;
            this.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            JIRAWebTest.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
            if (expectedItemNodes != null) {
                i$ = expectedItemNodes.entrySet().iterator();
                while (i$.hasNext()) {
                    pairs = o = i$.next();
                    itemNode = pairs.getKey().toString();
                    expectedValue = pairs.getValue().toString();
                    xpathExpression = path + "[" + itemNode + "= &quot;" + expectedValue + "&quot; ] ";
                    JIRAWebTest.log("Searching for existence of xpath " + xpathExpression);
                    XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
                }
            }
            if (unexpectedItemNodes != null) {
                i$ = unexpectedItemNodes.entrySet().iterator();
                while (i$.hasNext()) {
                    pairs = o = i$.next();
                    itemNode = pairs.getKey().toString();
                    expectedValue = pairs.getValue().toString();
                    xpathExpression = path + "[" + itemNode + "= &quot;" + expectedValue + "&quot; ] ";
                    JIRAWebTest.log("Searching for nonexistence of xpath " + xpathExpression);
                    XMLAssert.assertXpathNotExists((String)xpathExpression, (Document)doc);
                }
            }
        }
        catch (Throwable e) {
            JIRAWebTest.raiseRuntimeException(e);
        }
        finally {
            this.gotoPage("/secure/Dashboard.jspa");
        }
    }

    public void gotoPageNoLog(String url) {
        super.gotoPage(url);
    }

    public void gotoPage(String url) {
        JIRAWebTest.log("going to page " + url);
        super.gotoPage(url);
    }

    public void assertPageDoesNotExist(String assertionMessage, String url) {
        JIRAWebTest.log("asserting that the page does not exist. [" + url + "]");
        try {
            super.gotoPage(url);
            JIRAWebTest.fail((String)("Page unexpectedly exists - " + assertionMessage + " [" + url + "]"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void gotoCustomFields() {
        this.gotoPage(PAGE_CUSTOM_FIELDS);
    }

    public String addCustomField(String fieldType, String fieldName) {
        String desc = "a custom field called " + fieldName + " of type " + fieldType;
        return this.addCustomField(fieldType, FIELD_SCOPE_GLOBAL, fieldName, desc, null, null, null);
    }

    public String addCustomField(String fieldType, String fieldScope, String fieldName, String fieldDescription, String issueType, String project, String searcher) {
        return this.addCustomFieldWithMultipleIssueTypes(fieldType, fieldScope, fieldName, fieldDescription, new String[]{issueType}, project, searcher);
    }

    public String addCustomFieldWithMultipleIssueTypes(String fieldType, String fieldScope, String fieldName, String fieldDescription, String[] issueTypes, String project, String searcher) {
        if (!this.getDialog().isLinkPresentWithText("Add Custom Field")) {
            this.gotoCustomFields();
        }
        this.clickLinkWithText("Add Custom Field");
        this.getDialog().setFormParameter("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:" + fieldType);
        this.assertRadioOptionSelected("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:" + fieldType);
        this.submit("nextBtn");
        this.assertTextPresent("Step 2 of 2");
        this.assertTextPresent(fieldType);
        this.setFormElement("fieldName", fieldName);
        this.setFormElement("description", fieldDescription);
        if (searcher != null) {
            this.selectOption("searcher", searcher);
        }
        if (FIELD_SCOPE_GLOBAL.equalsIgnoreCase(fieldScope)) {
            this.setFormElement(FIELD_SCOPE_GLOBAL, "true");
        } else {
            if (issueTypes != null) {
                for (String issueType : issueTypes) {
                    if (issueType == null) continue;
                    this.selectMultiOption("issuetypes", issueType);
                }
            }
            if (project != null) {
                this.setFormElement(FIELD_SCOPE_GLOBAL, "false");
                this.selectOption("projects", project);
            }
        }
        this.submit("nextBtn");
        this.gotoCustomFields();
        this.clickLink("edit_" + fieldName);
        return this.getDialog().getFormParameterValue("id");
    }

    public void deleteCustomField(String fieldId) {
        this.gotoCustomFields();
        this.clickLink("del_customfield_" + fieldId);
        this.submit("Delete");
    }

    public void addCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Options for Custom Field") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Options for Custom Field");
        }
        this.setFormElement("addValue", fieldOption);
        this.submit("Add");
    }

    public void configureCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Options for Custom Field") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_customfield_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Options for Custom Field");
        }
        this.setFormElement("addValue", fieldOption);
        this.submit("Add");
    }

    public void configureDefaultCustomFieldValue(String fieldId, String fieldOption) {
        this.gotoDefaultValue(fieldId);
        this.setFormElement("customfield_" + fieldId, fieldOption);
        this.submit("Set Default");
    }

    public void configureDefaultCheckBoxCustomFieldValue(String fieldId, String fieldOption) {
        this.gotoDefaultValue(fieldId);
        this.setFormElement("customfield_" + fieldId, "10016");
        this.submit("Set Default");
    }

    public void configureDefaultMultiCustomFieldValue(String fieldId, String fieldOption, String fieldOption2) {
        this.gotoDefaultValue(fieldId);
        this.selectOption("customfield_" + fieldId, fieldOption);
        this.selectOption("customfield_" + fieldId + ":1", fieldOption2);
        this.submit("Set Default");
    }

    private void gotoDefaultValue(String fieldId) {
        if (!this.getDialog().isTextInResponse("Set Custom Field Defaults") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_customfield_" + fieldId);
            this.clickLinkWithText("Edit Default Value");
            this.assertTextPresent("Set Custom Field Defaults");
        }
    }

    public void delCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Options for Custom Field") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Options for Custom Field");
        }
        this.clickLink("del_" + fieldOption);
        this.submit("Delete");
    }

    public void removeAllCustomFields() {
        while (true) {
            this.gotoCustomFields();
            if (!this.getDialog().isLinkPresentWithText("Del")) break;
            this.clickLinkWithText("Del");
            this.submit("Delete");
        }
    }

    public String createCustomFields(String fieldType, String fieldScope, String fieldName, String fieldDescription, String issueType, String projectType, String[] fieldOptions) {
        String fieldId = this.addCustomField(fieldType, fieldScope, fieldName, fieldDescription, issueType, projectType, null);
        if (fieldOptions != null) {
            for (String fieldOption : fieldOptions) {
                this.addCustomFieldOption("customfield_" + fieldId, fieldOption);
            }
        }
        return fieldId;
    }

    public void editIssueWithCustomFields(String issueKey, List<CustomFieldValue> cfValues) {
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        for (CustomFieldValue cfValue : cfValues) {
            if ("radiobuttons".equals(cfValue.getCfType())) {
                this.getDialog().setFormParameter("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
                this.assertRadioOptionSelected("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("textfield".equals(cfValue.getCfType()) || "userpicker".equals(cfValue.getCfType()) || "datepicker".equals(cfValue.getCfType())) {
                this.setFormElement("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("select".equals(cfValue.getCfType())) {
                this.selectOption("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("multiselect".equals(cfValue.getCfType())) {
                this.selectOption("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if (!"multicheckboxes".equals(cfValue.getCfType())) continue;
            this.checkCheckbox("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
        }
        this.submit("Update");
    }

    public void editIssueWithCustomFields(String issueKey, String customFieldId, String customFieldValue, String customFieldType) {
        this.gotoIssue(issueKey);
        this.clickLink("edit-issue");
        if ("radiobuttons".equals(customFieldType)) {
            this.getDialog().setFormParameter("customfield_" + customFieldId, customFieldValue);
            this.assertRadioOptionSelected("customfield_" + customFieldId, customFieldValue);
        }
        if ("textfield".equals(customFieldType) || "userpicker".equals(customFieldType) || "datepicker".equals(customFieldType)) {
            this.setFormElement("customfield_" + customFieldId, customFieldValue);
        }
        if ("select".equals(customFieldType)) {
            this.selectOption("customfield_" + customFieldId, customFieldValue);
        }
        if ("multiselect".equals(customFieldType)) {
            this.selectOption("customfield_" + customFieldId, customFieldValue);
        }
        if ("multicheckboxes".equals(customFieldType)) {
            this.checkCheckbox("customfield_" + customFieldId, customFieldValue);
        }
        this.submit("Update");
    }

    public Collection<String> createIssuesInBulk(int numberOfIssues, String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel) {
        ArrayList<String> issuesTemp = new ArrayList<String>();
        for (int i = 0; i < numberOfIssues; ++i) {
            issuesTemp.add(this.addIssue(project, projectKey, issueType, summary + i, priority, components, affectsVersions, fixVersions, assignTo, environment, description, originalEstimate, securityLevel, null));
        }
        return issuesTemp;
    }

    public void sortIssues(String field, String direction) {
        this.gotoPage("/secure/IssueNavigator.jspa?sorter/field=" + field + "&sorter/order=" + direction);
    }

    public void sortIssues(String page, String field, String direction) {
        this.gotoPage("/secure/" + page + "?sorter/field=" + field + "&sorter/order=" + direction);
    }

    public void deleteAllIssuesInAllPages() {
        String[] parameterNames;
        boolean mailServerExists = this.isMailServerExists();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.displayAllIssues();
        JIRAWebTest.log("Deleting all issues");
        this.assertElementPresent("issuetable");
        this.gotoPage("/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=10000");
        this.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.setWorkingForm("bulkedit");
        WebForm form = this.tester.getDialog().getForm();
        for (String name : parameterNames = form.getParameterNames()) {
            if (!name.startsWith("bulkedit_")) continue;
            this.checkCheckbox(name);
        }
        this.submit("Next");
        this.assertTextPresent("Bulk Operation: Choose Operation");
        this.setFormElement("operation", "bulk.delete.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.delete.operation.name");
        this.submit("Next");
        if (mailServerExists) {
            this.submit("Next");
        }
        this.assertTextPresent("Bulk Operation: Confirmation");
        this.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    public void createSessionSearchForAll() {
        this.gotoPage("/issues/?jql=");
    }

    public boolean userExists(String userName) {
        this.gotoPage(PAGE_USER_BROWSER);
        return this.getDialog().isLinkPresentWithText(userName);
    }

    public boolean fieldSchemeExists(String fieldSchemeName) {
        this.gotoFieldLayoutSchemes();
        return this.getDialog().isTextInResponse(fieldSchemeName);
    }

    public boolean customFieldExists(String fieldName) {
        this.gotoCustomFields();
        return this.getDialog().isTextInResponse(fieldName);
    }

    public boolean subTaskTypeExists(String subTaskType) {
        this.activateSubTasks();
        boolean exists = this.getDialog().isLinkPresent("del_" + subTaskType);
        this.deactivateSubTasks();
        return exists;
    }

    public boolean securtiySchemeExists(String securityScheme) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        return this.getDialog().isTextInResponse(securityScheme);
    }

    public boolean securtiyLevelExists(String securityScheme, String securityLevel) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.clickLinkWithText(securityScheme);
        return this.getDialog().isLinkPresent("add_" + securityLevel);
    }

    public boolean permissionSchemeExists(String permissionScheme) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        return this.getDialog().isLinkPresentWithText(permissionScheme);
    }

    public boolean workflowSchemeExists(String workflowScheme) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        return this.getDialog().isLinkPresentWithText(workflowScheme);
    }

    public boolean workflowExists(String workflow) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
        return this.getDialog().isLinkPresent("steps_" + workflow);
    }

    public boolean linkedStatusExists(String linkedStatus) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        return this.getDialog().isLinkPresent("del_" + linkedStatus);
    }

    public boolean componentExists(String component, String project) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        return componentByname != null;
    }

    public boolean versionExists(String version, String project) {
        Project projectByName = this.getProjectByName(project);
        Version versionByName = this.getVersionByName(projectByName.key, version);
        return versionByName != null;
    }

    public boolean projectExists(String project) {
        Project projectByName = this.getProjectByName(project);
        return projectByName != null;
    }

    public void gotoFieldScreens() {
        this.gotoPage("/secure/admin/ViewFieldScreens.jspa");
    }

    public void gotoFieldScreen(String screenName) {
        this.gotoFieldScreens();
        this.assertTextPresent("View Screens");
        this.assertLinkPresent("configure_fieldscreen_" + screenName);
        this.clickLink("configure_fieldscreen_" + screenName);
    }

    public void gotoFieldScreenSchemes() {
        this.gotoPage(PAGE_NOT_STANDARD_VIEW_FIELD_SCREEN_SCHEMES);
    }

    public void gotoFieldScreenScheme() {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("configure_fieldscreenscheme_Default Screen Scheme");
    }

    public void addFieldToFieldScreen(String screenName, String fieldName) {
        JIRAWebTest.log("Adding " + fieldName + " to field screen.");
        this.backdoor.screens().addFieldToScreen(screenName, fieldName);
    }

    public void addFieldsToFieldScreen(String screenName, String[] fieldNames) {
        JIRAWebTest.log("Adding fields to field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        for (String fieldName : fieldNames) {
            this.backdoor.screens().addFieldToScreen(screenName, fieldName);
        }
    }

    public void addFieldToFieldScreen(String screenName, String fieldName, String position) {
        this.backdoor.screens().addFieldToScreen(screenName, fieldName);
    }

    public void removeFieldFromFieldScreen(String screenName, String[] fieldNames) {
        JIRAWebTest.log("Removing Fields from field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        for (String fieldName : fieldNames) {
            this.backdoor.screens().removeFieldFromScreen(screenName, fieldName);
        }
    }

    public String findRowWithName(String fieldTableName, int column, String fieldName) {
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID(fieldTableName);
            if (fieldTable == null) {
                return null;
            }
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, column);
                if (!field.contains(fieldName)) continue;
                return Integer.toString(i - 1);
            }
            return null;
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
            return null;
        }
    }

    public void addScreen(String screenName, String screenDescription) {
        this.gotoFieldScreens();
        this.clickLink("add-field-screen");
        this.setWorkingForm("field-screen-add");
        this.setFormElement("fieldScreenName", screenName);
        this.setFormElement("fieldScreenDescription", screenDescription);
        this.submit("Add");
    }

    public void copyScreen(String copiedScreenName, String newScreenName, String screenDescription) {
        this.gotoFieldScreens();
        this.clickLink("copy_fieldscreen_" + copiedScreenName);
        this.setFormElement("fieldScreenName", newScreenName);
        this.setFormElement("fieldScreenDescription", screenDescription);
        this.submit("Copy");
    }

    public void deleteScreen(String screenName) {
        this.gotoFieldScreens();
        this.clickLink("delete_fieldscreen_" + screenName);
        this.submit("Delete");
    }

    public void removeAllFieldScreens() {
        while (true) {
            this.gotoFieldScreens();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllFieldScreenSchemes() {
        while (true) {
            this.gotoIssueTypeScreenSchemes();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllScreenAssociationsFromDefault() {
        while (true) {
            this.gotoViewFieldScreenSchemes();
            this.clickLink("configure_fieldscreenscheme_Default Screen Scheme");
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                continue;
            }
            break;
        }
    }

    public void gotoFieldScreenScheme(String schemeName) {
        this.gotoViewFieldScreenSchemes();
        this.clickLink("configure_fieldscreenscheme_" + schemeName);
    }

    private void gotoViewFieldScreenSchemes() {
        this.gotoPage(PAGE_NOT_STANDARD_VIEW_FIELD_SCREEN_SCHEMES);
    }

    public void addFieldScreenScheme(String schemeName, String schemeDescription, String fieldScreenDefault) {
        this.gotoViewFieldScreenSchemes();
        this.clickLink("add-field-screen-scheme");
        this.setWorkingForm("field-screen-scheme-add");
        this.setFormElement("fieldScreenSchemeName", schemeName);
        this.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.submit("Add");
    }

    public void copyFieldScreenScheme(String copiedSchemeName, String schemeName, String schemeDescription) {
        this.gotoViewFieldScreenSchemes();
        this.clickLink("copy_fieldscreenscheme_" + copiedSchemeName);
        this.setFormElement("fieldScreenSchemeName", schemeName);
        this.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.submit("Copy");
    }

    public void deleteFieldScreenScheme(String schemeName) {
        this.gotoViewFieldScreenSchemes();
        try {
            this.assertLinkPresent("configure_fieldscreenscheme_" + schemeName);
        }
        catch (AssertionError e) {
            JIRAWebTest.log("Scheme does not exist");
        }
        this.clickLink("delete_fieldscreenscheme_" + schemeName);
        this.submit("Delete");
    }

    public void addIssueOperationToScreenAssociation(String schemeName, String issueOperation, String screenName) {
        JIRAWebTest.log("Adding screen " + screenName + " to operation '" + issueOperation + "'.");
        this.gotoFieldScreenScheme(schemeName);
        this.clickLink("add-screen-scheme-item");
        this.selectOption("issueOperationId", issueOperation);
        this.selectOption("fieldScreenId", screenName);
        this.submit("Add");
    }

    public void deleteIssueOperationFromScreenAssociation(String schemeName, String issueOperation) {
        JIRAWebTest.log("Deleting operation '" + issueOperation + "' from scheme " + schemeName + ".");
        this.gotoFieldScreenScheme(schemeName);
        try {
            this.clickLink("delete_fieldscreenscheme_" + issueOperation);
        }
        catch (AssertionError e) {
            JIRAWebTest.log("Issue Operation not configured");
        }
    }

    public void removeAllFieldScreenAssociation(String schemeName) {
        while (true) {
            this.gotoFieldScreenScheme(schemeName);
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllIssueTypeScreenSchemes() {
        while (true) {
            this.gotoIssueTypeScreenSchemes();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void gotoIssueTypeScreenScheme(String schemeName) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("configure_issuetypescreenscheme_" + schemeName);
    }

    public void addIssueTypeFieldScreenScheme(String schemeName, String schemeDescription, String defaultScreenScheme) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("add-issue-type-screen-scheme");
        this.setFormElement("schemeName", schemeName);
        this.setFormElement("schemeDescription", schemeDescription);
        this.selectOption("fieldScreenSchemeId", defaultScreenScheme);
        this.submit("Add");
    }

    public void deleteIssueTypeFieldScreenScheme(String schemeId) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("delete_issuetypescreenscheme_" + schemeId);
        this.submit("Delete");
    }

    public void copyIssueTypeFieldScreenSchemeName(String copiedSchemeId, String schemeName, String schemeDescription) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("copy_issuetypescreenscheme_" + copiedSchemeId);
        this.setFormElement("schemeName", schemeName);
        this.setFormElement("schemeDescription", schemeDescription);
        this.submit("Copy");
    }

    protected void gotoIssueTypeScreenSchemes() {
        this.gotoPage(PAGE_ISSUE_TYPE_SCREEN_SCHEMES);
    }

    public void addIssueTypeToScreenAssociation(String issueTypeSchemeId, String issueType, String screenSchemeName) {
        this.gotoIssueTypeScreenScheme(issueTypeSchemeId);
        this.clickLink("add-issue-type-screen-scheme-configuration-association");
        this.selectOption("issueTypeId", issueType);
        this.selectOption("fieldScreenSchemeId", screenSchemeName);
        this.submit("Add");
    }

    public void associateIssueTypeScreenSchemeToProject(String projectName, String screenScheme) {
        Project project = this.getProjectByName(projectName);
        this.gotoPage("/secure/project/SelectIssueTypeScreenScheme!default.jspa?projectId=" + project.id);
        this.selectOption("schemeId", screenScheme);
        this.submit("Associate");
    }

    public void addTabToScreen(String screenName, String tabName) {
        this.backdoor.screens().addTabToScreen(screenName, tabName);
    }

    public void gotoFieldScreenTab(String screenName, String tabName) {
        this.gotoFieldScreen(screenName);
        try {
            this.assertTextPresent("Add one or more fields to the");
            this.assertTextPresentBeforeText("<b>" + tabName + "</b>", "tab.");
        }
        catch (AssertionFailedError e) {
            this.clickLinkWithText(tabName);
        }
    }

    public void deleteTabFromScreen(String screenName, String tabName) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.clickLinkWithText("Delete");
        this.submit("Delete");
    }

    public void addFieldToFieldScreenTab(String screenName, String tabName, String fieldName, String position) {
        this.backdoor.screens().addFieldToScreenTab(screenName, tabName, fieldName, position);
    }

    public void removeFieldFromFieldScreenTab(String screenName, String tabName, String[] fieldNames) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.assertTextPresent("Configure Screen");
        for (String fieldName : fieldNames) {
            String indexName = this.findRowWithName("field_table", 1, fieldName);
            if (indexName != null) {
                int index = Integer.parseInt(indexName);
                this.checkCheckbox("removeField_" + index);
                this.assertCheckboxSelected("removeField_" + index);
                continue;
            }
            JIRAWebTest.log("Field " + fieldName + " not present");
        }
        this.submit("deleteFieldsFromTab");
    }

    public void restoreDefaultDashboard() {
        this.clickLink("home_link");
        this.clickLinkWithText("Manage Dashboard");
        if (this.getDialog().isLinkPresentWithText("Restore Defaults")) {
            this.clickLinkWithText("Restore Defaults");
            this.submit("Restore");
        }
    }

    public void startDashboardConfiguration() {
        this.clickLink("home_link");
        if (this.getDialog().isLinkPresent("configure_on")) {
            this.clickLink("configure_on");
        }
    }

    public void browseToFullConfigure() {
        this.clickLink("home_link");
        this.clickLinkWithText("Manage Dashboard");
        this.clickLinkWithText("Full configure");
    }

    public void addPortlet(String portlet) {
        this.startDashboardConfiguration();
        this.clickLink("home_link");
        this.clickLinkWithText("Add a new gadget.");
        this.setFormElement("portletId", "com.atlassian.jira.plugin.system.portlets:" + portlet);
        this.assertRadioOptionSelected("portletId", "com.atlassian.jira.plugin.system.portlets:" + portlet);
        this.submit(" Add ");
    }

    public int saveFilter(String filterName, String filterDesc) {
        this.clickLinkWithText("Save");
        this.setFormElement("filterName", filterName);
        this.setFormElement("filterDescription", filterDesc);
        this.submit("saveasfilter_submit");
        this.gotoManageFilter();
        this.assertLinkPresentWithText(filterName);
        int filterId = Integer.parseInt(this.extractFilterId(filterName));
        JIRAWebTest.log("Saved filter: '" + filterName + "' [" + filterId + "]");
        return filterId;
    }

    public int saveFilterAs(String filterName, String copyName, String copyDesc, String saveColumnOrder) {
        this.gotoManageFilter();
        String filterId = this.extractFilterId(filterName);
        this.clickLinkWithText(filterName);
        if (!saveColumnOrder.equalsIgnoreCase("ignore")) {
            this.clickLinkWithText("Use your default Column Order");
        }
        this.clickLinkWithText("Save as");
        this.setFormElement("filterName", copyName);
        this.setFormElement("filterDescription", copyDesc);
        if (!saveColumnOrder.equalsIgnoreCase("ignore")) {
            this.setFormElement("saveColumnLayout", String.valueOf(saveColumnOrder));
        } else {
            this.assertFormElementNotPresent("saveColumnLayout");
        }
        this.submit("saveasfilter_submit");
        this.gotoManageFilter();
        this.assertLinkPresentWithText(copyName);
        int copyFilterId = Integer.parseInt(this.extractFilterId(copyName));
        JIRAWebTest.log("Saved filter: '" + filterName + "' [" + filterId + "] as filter: '" + copyName + "' [" + copyFilterId + "]");
        return copyFilterId;
    }

    public String extractFilterId(String filterName) {
        try {
            filterName = "\">" + filterName + "</a>";
            String text = this.getDialog().getResponse().getText();
            int endOfFilterId = text.indexOf(filterName);
            int startOfFilterId = text.substring(0, endOfFilterId).lastIndexOf("requestId=") + "requestId=".length();
            String filterId = text.substring(startOfFilterId, endOfFilterId);
            JIRAWebTest.log("filterId = " + filterId);
            return filterId;
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Could not retrieve id for filter: '" + filterName + "'"));
            return null;
        }
    }

    public void deleteAllFilter() {
        this.gotoManageFilter();
        this.clickOnMyFiltersTab();
        JIRAWebTest.log("Deleting all filters");
        while (this.getDialog().isLinkPresentWithText("Delete")) {
            this.clickLinkWithText("Delete");
            this.submit("Delete");
        }
    }

    private void clickOnMyFiltersTab() {
        XPathLocator loc = new XPathLocator(this.tester, "//ul[@id='filter_type_table']/li/a/strong");
        if (loc.getText().contains("My")) {
            this.getNavigation().clickLinkWithExactText("My");
        }
        loc = new XPathLocator(this.tester, "//li[@class='active']/a");
        this.text.assertTextPresent(loc, "My");
    }

    public void deleteFilter(String filterName) {
        this.gotoManageFilter();
        this.clickOnMyFiltersTab();
        if (this.getDialog().isLinkPresent("delete_" + filterName)) {
            this.clickLink("delete_" + filterName);
            this.submit("Delete");
            this.assertLinkNotPresent("delete_" + filterName);
        }
    }

    public void gotoFilterById(long filterId) {
        this.gotoManageFilter();
        this.clickLink("filterlink_" + filterId);
    }

    public void gotoFilter(String filtername) {
        this.gotoManageFilter();
        this.clickLinkWithText(filtername);
    }

    private void gotoManageFilter() {
        this.gotoPage("/secure/ManageFilters.jspa?filterView=search&pressedSearchButton=true&searchName=&searchOwner=&Search=");
    }

    public void assertViewIssueFields() {
        this.assertTextPresent("View Field Configuration");
    }

    public void moveOptionsToPositions(String[] optionValue, String[] optionId, String itemType, Map<String, String> moveToPosition) {
        for (String currentPosition : moveToPosition.keySet()) {
            int newIntPos;
            String newPosition = moveToPosition.get(currentPosition);
            int currIntPos = Integer.parseInt(currentPosition);
            if (currIntPos < (newIntPos = Integer.parseInt(newPosition))) {
                this.assertTextPresentBeforeText("<b>" + optionValue[currIntPos] + "</b>", "<b>" + optionValue[newIntPos] + "</b>");
            } else if (currIntPos > newIntPos) {
                this.assertTextPresentBeforeText("<b>" + optionValue[newIntPos] + "</b>", "<b>" + optionValue[currIntPos] + "</b>");
            }
            JIRAWebTest.log("      Moving item at position " + currIntPos + " to position " + newPosition);
            this.setFormElement("new" + itemType + "Position_" + optionId[currIntPos], newPosition);
        }
        this.clickButtonWithValue("Move");
        for (int i = 1; i < optionValue.length; ++i) {
            int k;
            if (moveToPosition.containsKey(String.valueOf(i))) continue;
            for (k = 1; k <= i && moveToPosition.containsValue(String.valueOf(k)); ++k) {
            }
            moveToPosition.put(String.valueOf(i), String.valueOf(k));
        }
        for (String currentOption : moveToPosition.keySet()) {
            String newCurrentPos = moveToPosition.get(currentOption);
            String newReplacedPos = moveToPosition.get(newCurrentPos);
            int currentOptionInt = Integer.parseInt(currentOption);
            int newCurrentPosInt = Integer.parseInt(newCurrentPos);
            int otherOptionInt = Integer.parseInt(newCurrentPos);
            int newReplacedPosInt = Integer.parseInt(newReplacedPos);
            if (newCurrentPosInt < newReplacedPosInt) {
                this.assertTextPresentBeforeText("<b>" + optionValue[currentOptionInt] + "</b>", "<b>" + optionValue[otherOptionInt] + "</b>");
                continue;
            }
            if (newCurrentPosInt <= newReplacedPosInt) continue;
            this.assertTextPresentBeforeText("<b>" + optionValue[otherOptionInt] + "</b>", "<b>" + optionValue[currentOptionInt] + "</b>");
        }
    }

    public void checkOrderingUsingArrows(String[] optionValue, String[] optionId) {
        int i;
        JIRAWebTest.log("Testing reordering using the option ordering arrows");
        JIRAWebTest.log("  checking moveToLast arrows");
        for (i = 1; i < optionValue.length; ++i) {
            this.clickLink("moveToLast_" + optionId[i]);
            this.assertLinkNotPresent("moveDown_" + optionId[i]);
            this.assertLinkNotPresent("moveToLast_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveToFirst arrows");
        for (i = optionValue.length - 1; i >= 1; --i) {
            this.clickLink("moveToFirst_" + optionId[i]);
            this.assertLinkNotPresent("moveUp_" + optionId[i]);
            this.assertLinkNotPresent("moveToFirst_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveDown arrows");
        for (i = 1; i < optionValue.length - 1; ++i) {
            this.clickLink("moveDown_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveUp arrows");
        for (i = optionValue.length - 1; i >= 2; --i) {
            this.clickLink("moveUp_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
    }

    public String checkOrderingUsingMoveToPos(String[] optionValue, String[] optionId, String itemType) {
        JIRAWebTest.log("  Testing reordering using 'Move To Position' field inputs");
        JIRAWebTest.log("    Test moving one item");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "2"));
        JIRAWebTest.log("    Test moving two items");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "3", "2", "4"));
        JIRAWebTest.log("    Test moving three items");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "3", "2", "5", "3", "4"));
        return optionValue[1];
    }

    public void resetInAscendingOrdering(String[] optionId, String itemType) {
        if ("Field".equals(itemType)) {
            this.createNewFieldScreen(optionId);
        } else {
            this.clickLinkWithText("Sort options alphabetically");
        }
    }

    public void createNewFieldScreen(String[] optionId) {
        this.removeAllFieldScreens();
        this.addScreen("new screen for reordering tests", "");
        for (int i = 1; i < optionId.length; ++i) {
            this.setFormElement("fieldId", optionId[i]);
            this.submit("Add");
        }
    }

    public void checkItemsAreInAscendingOrder(String[] optionValue) {
        for (int i = 1; i < optionValue.length - 1; ++i) {
            this.assertTextPresentBeforeText("<b>" + optionValue[i] + "</b>", "<b>" + optionValue[i + 1] + "</b>");
        }
    }

    @Deprecated
    public static <K, V> Map<K, V> easyMapBuild(K key1, V value1) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key1, value1);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> easyMapBuild(K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> easyMapBuild(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap<K, V> map = new HashMap<K, V>(3);
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public void viewChangeHistoryOfIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().isLinkPresentWithText("History")) {
            this.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
            this.assertLinkNotPresent("History");
        } else {
            this.assertTextPresent("History");
        }
    }

    public void assertNoChangesForIssue(String issueKey) {
        this.viewChangeHistoryOfIssue(issueKey);
        CssLocator chLocator = new CssLocator(this.tester, "div[id^=changehistory-]");
        JIRAWebTest.assertEquals((int)0, (int)chLocator.getNodes().length);
        this.assertTextPresent("created issue");
    }

    public void assertLastChangeHistoryIs(String issueKey, String field, String originalValue, String newValue) {
        String text;
        this.viewChangeHistoryOfIssue(issueKey);
        try {
            text = this.getDialog().getResponse().getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            JIRAWebTest.fail((String)e.getMessage());
            return;
        }
        String CHANGE_HISTORY_ID_PREFIX = "changehistory_";
        int startOfLastChangeHistoryTableId = text.lastIndexOf("id=\"changehistory_");
        int lastChangeHistoryTableId = -1;
        if (startOfLastChangeHistoryTableId != -1) {
            int endOfLastChangeHistoryTableId = text.substring(startOfLastChangeHistoryTableId += "id=\"changehistory_".length()).indexOf(34) + startOfLastChangeHistoryTableId;
            lastChangeHistoryTableId = Integer.parseInt(text.substring(startOfLastChangeHistoryTableId, endOfLastChangeHistoryTableId));
        }
        if (lastChangeHistoryTableId == -1) {
            JIRAWebTest.fail((String)"Could not find the last change history table");
        }
        try {
            WebTable changeHistoryTable = this.getDialog().getResponse().getTableWithID("changehistory_" + lastChangeHistoryTableId);
            for (int row = 0; row < changeHistoryTable.getRowCount(); ++row) {
                if (!this.tableCellHasStrictText(changeHistoryTable, row, 0, field) || !this.tableCellHasStrictText(changeHistoryTable, row, 1, originalValue) || !this.tableCellHasStrictText(changeHistoryTable, row, 2, newValue)) continue;
                return;
            }
            JIRAWebTest.fail((String)("The last change history for issue: " + issueKey + " did not have the change item: " + field + "[" + originalValue + "][" + newValue + "]"));
        }
        catch (SAXException e) {
            JIRAWebTest.raiseRuntimeException(e);
        }
    }

    public void assertLastChangeNotMadeToField(String issueKey, String field) {
        this.viewChangeHistoryOfIssue(issueKey);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id=\"issue_actions_container\"]/div[last()]"), field);
    }

    public void assertErrorMsgFieldRequired(String fieldId, String project, String fieldDisplayName) {
        this.assertTextPresent("&quot;" + fieldId + "&quot; field is required and the project &quot;" + project + "&quot; does not have any " + fieldDisplayName);
    }

    public void bulkChangeIncludeAllPages() {
        this.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=10000");
    }

    public void bulkChangeIncludeCurrentPage() {
        this.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true");
    }

    public void isStepChooseIssues() {
        this.assertTextPresent("Bulk Operation: Choose Issues");
        JIRAWebTest.log("Step 1 of 4");
    }

    public void isStepChooseOperation() {
        this.assertTextPresent("Bulk Operation: Choose Operation");
        JIRAWebTest.log("Step 2 of 4");
    }

    public void isStepOperationDetails() {
        this.assertTextPresent("Bulk Operation: Operation Details");
        JIRAWebTest.log("Step 3 of 4");
    }

    public void isStepConfirmation() {
        this.assertTextPresent("Confirmation");
        JIRAWebTest.log("Step 4 of 4");
    }

    public void selectCheckbox(String cbox) {
        this.assertCheckboxNotSelected(cbox);
        this.checkCheckbox(cbox);
        this.assertCheckboxSelected(cbox);
    }

    public void bulkChangeChooseIssuesAll() {
        String[] paramNames;
        this.isStepChooseIssues();
        this.getDialog().setWorkingForm("bulkedit");
        for (String paramName : paramNames = this.getDialog().getForm().getParameterNames()) {
            if (!paramName.startsWith("bulkedit_")) continue;
            this.selectCheckbox(paramName);
        }
        this.clickOnNext();
    }

    public void bulkChangeChooseOperationDelete(boolean mailServerExists) {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.delete.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.delete.operation.name");
        JIRAWebTest.log("Operation Selected: Delete Issues");
        this.clickOnNext();
        if (mailServerExists) {
            this.clickOnNext();
        }
    }

    public void bulkChangeChooseOperationEdit() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.edit.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.edit.operation.name");
        JIRAWebTest.log("Operation Selected: Edit Issues");
        this.clickOnNext();
    }

    public void chooseOperationBulkMove() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.move.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.move.operation.name");
        JIRAWebTest.log("Operation Selected: Move Issues");
        this.clickOnNext();
    }

    public void chooseOperationExecuteWorfklowTransition() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.workflowtransition.operation.name");
        JIRAWebTest.log("Operation Selected: Transition Issues");
        this.clickOnNext();
    }

    public void clickOnNext() {
        this.submit("Next");
        JIRAWebTest.log("Next");
    }

    public void bulkChangeCancel() {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#cancel"), "Cancel");
        this.clickLink("cancel");
        this.assertTextPresent("Issue Navigator");
        JIRAWebTest.log("Canceled");
    }

    public void bulkChangeConfirm() {
        this.isStepConfirmation();
        this.submit("Confirm");
        JIRAWebTest.log("Confirmed");
    }

    public float getJiraJavaVersion() {
        EnvironmentUtils environmentUtils = new EnvironmentUtils(this.tester, this.getEnvironmentData());
        return environmentUtils.getJiraJavaVersion();
    }

    public boolean isBeforeJdk15() {
        return this.getJiraJavaVersion() < 1.5f;
    }

    @Deprecated
    public void restoreData(String fileName) {
        this.administration.restoreData(fileName);
        this.navigation.gotoDashboard();
    }

    public void restoreDataWithFullRefresh(String fileName) {
        this.restoreData(new File(this.getEnvironmentData().getXMLDataLocation(), fileName), false);
    }

    protected void copyFileToJiraImportDirectory(File file) {
        String filename = file.getName();
        if (!copiedFiles.contains(filename)) {
            File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
            try {
                FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
                copiedFiles.add(filename);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
            }
        }
    }

    public void restoreData(File file) {
        this.restoreData(file, true);
    }

    public void restoreData(File file, boolean quickImport) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Restore");
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("/secure/admin/XmlRestore!default.jspa");
        this.setWorkingForm("restore-xml-data-backup");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        if (quickImport) {
            this.checkCheckbox("quickImport", "true");
        }
        this.submit();
        this.waitForRestore();
        try {
            this.assertTextPresent("Your import has been successful");
        }
        catch (AssertionFailedError e) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.");
            this.assertCauseOfError("You must enter the location of an XML file.");
            this.assertCauseOfError("Could not find file at this location.", file.getName());
            this.assertCauseOfError("Invalid license key specified.");
            this.assertCauseOfError("The current license is too old to install this version of JIRA");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Standard.");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Professional.");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Enterprise.");
            this.assertCauseOfError("You must specify an index for the restore process.");
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.");
            JIRAWebTest.fail((String)"Your JIRA data failed to restore successfully. See logs for details");
        }
        timer.end();
        this.getNavigation().disableWebSudo();
        this.login("admin", "admin");
        this.fixBaseURL();
        this.beginAt("/");
    }

    private void waitForRestore() {
        String url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        while (url.contains("importprogress")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String subUrl = url.substring(this.getEnvironmentData().getBaseUrl().toString().length());
            this.gotoPage(subUrl);
            url = this.tester.getDialog().getResponse().getURL().toExternalForm();
        }
    }

    public void restoreI18nData(String fileName) {
        this.restoreI18nData(new File(this.getEnvironmentData().getXMLDataLocation(), fileName));
    }

    public void restoreI18nData(File file) {
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Restore");
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("/secure/admin/XmlRestore!default.jspa");
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.checkCheckbox("quickImport", "true");
        this.submit();
        this.waitForRestore();
        try {
            JIRAWebTest.assertNotNull((Object)new XPathLocator(this.tester, "//*[@id=\"login\"]").getNode());
        }
        catch (AssertionFailedError e) {
            JIRAWebTest.fail((String)"Your JIRA data failed to restore successfully. See logs for details");
        }
        timer.end();
        this.getNavigation().disableWebSudo();
        this.login("admin", "admin");
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        JIRAWebTest.log("Setting baseurl to '" + baseUrl + "'");
        this.gotoAdmin();
        this.gotoPage("/secure/admin/jira/EditApplicationProperties!default.jspa");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit();
        this.beginAt("/");
    }

    private void assertCauseOfError(String errorMessage) {
        this.assertCauseOfError(errorMessage, null);
    }

    private void assertCauseOfError(String errorMessage, String params) {
        try {
            this.assertTextNotPresent(errorMessage);
        }
        catch (AssertionFailedError e) {
            JIRAWebTest.fail((String)("Failed to restore JIRA data. Cause: " + errorMessage + (params != null ? " [" + params + "]" : "")));
        }
    }

    public void restoreDataWithLicense(String fileName, String licenseKey) {
        FuncTestTimer timer = TestInformationKit.pullTimer((String)"XML Restore");
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("/secure/admin/XmlRestore!default.jspa");
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", licenseKey);
        this.checkCheckbox("quickImport", "true");
        this.submit();
        this.waitForRestore();
        this.assertTextPresent("Your import has been successful");
        timer.end();
        this.getNavigation().disableWebSudo();
        this.login("admin", "admin");
        this.fixBaseURL();
        this.beginAt("/");
    }

    private void fixBaseURL() {
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        JIRAWebTest.log("Setting baseurl to '" + baseUrl + "'");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Update");
    }

    public void start() {
        this.stopWatch.start();
    }

    public void split() {
        this.stopWatch.split();
        JIRAWebTest.log("Stop watch split at: " + this.stopWatch.toSplitString());
    }

    public void stop() {
        this.stopWatch.stop();
        JIRAWebTest.log("Stop watch stopped at: " + this.stopWatch.toString());
    }

    @Deprecated
    public void restoreBlankInstance() {
        this.getAdministration().restoreBlankInstance();
    }

    public void enableUnassignedIssues() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.checkCheckbox("allowUnassigned", "true");
        this.submit("Update");
    }

    public void disableUnassignedIssues() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.checkCheckbox("allowUnassigned", "false");
        this.submit("Update");
    }

    public void setBaseUrl() {
        this.setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
    }

    public void setBaseUrl(String baseUrl) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.setFormElement("baseURL", baseUrl);
        this.submit("Update");
    }

    public void addIssueTypeStatsPortlet(String filterName) {
        this.browseToFullConfigure();
        this.submit("addButton");
        this.checkCheckbox("portletId", "com.atlassian.jira.plugin.system.portlets:filterstats");
        this.submit(" Add ");
        this.selectOption("filterid", filterName);
        this.selectOption("statistictype", "Issue Type");
        this.submit("Save");
    }

    public void createProjectCategory(String categoryName, String categoryDescription) {
        this.gotoProjectCategories();
        this.setFormElement("name", categoryName);
        this.setFormElement("description", categoryDescription);
        this.submit("Add");
    }

    public void deleteProjectCategory(String categoryName) {
        this.gotoProjectCategories();
        this.clickLink("del_" + categoryName);
        this.submit("Delete");
    }

    public void gotoProjectCategories() {
        this.gotoPage("/secure/admin/projectcategories/ViewProjectCategories!default.jspa");
    }

    public void placeProjectInCategory(String projectName, String categoryName) {
        Project project = this.getProjectByName(projectName);
        this.gotoPage("/secure/project/SelectProjectCategory!default.jspa?pid=" + project.id);
        this.selectOption("pcid", categoryName);
        this.submit("Select");
    }

    public boolean projectCategoryExists(String categoryName) {
        this.gotoProjectCategories();
        try {
            this.assertTextPresent(categoryName);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Deprecated
    public void gotoProjectBrowse(String key) {
        this.gotoPage("browse/" + key);
    }

    public void gotoVersionBrowse(String projectKey, String versionName) {
        this.gotoProjectBrowse(projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:versions-panel");
        this.clickLinkWithText(versionName);
        if (this.getDialog().isLinkPresentWithText("Select:")) {
            this.clickLinkWithText("Select:");
        }
    }

    public void gotoComponentBrowse(String projectKey, String componentName) {
        this.gotoProjectBrowse(projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:components-panel");
        this.clickLinkWithText(componentName);
        if (this.getDialog().isLinkPresentWithText("Select:")) {
            this.clickLinkWithText("Select:");
        }
    }

    public void gotoIssueTabPanel(String issueKey, String issueTabName) {
        if ("All".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel");
        } else if ("Comments".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        } else if ("Work Log".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        } else if ("History".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
        } else {
            JIRAWebTest.fail((String)"Invalid issue tab panel specified");
        }
    }

    public void gotoProjectTabPanel(String projectKey, String projectTabName) {
        if ("Open Issues".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:openissues-panel");
        } else if ("Road Map".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:roadmap-panel");
        } else if ("Change Log".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:changelog-panel");
        } else if ("Versions".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:versions-panel");
        } else if ("Components".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.jira-projects-plugin:components-panel");
        } else {
            JIRAWebTest.fail((String)"Invalid project tab panel specified");
        }
        this.assertTextPresentBeforeText(projectTabName, projectTabName);
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer) {
        this.setFieldConfigurationFieldToRenderer(configuration, fieldId, renderer, false);
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer, boolean assertWarningNotPresent) {
        this.gotoFieldLayoutConfiguration(configuration);
        this.clickLink("renderer_" + fieldId);
        this.assertTextPresent("Edit Field Renderer");
        this.selectOption("selectedRendererType", renderer);
        if (assertWarningNotPresent) {
            this.assertTextNotPresent("Changing the renderer will effect the display of all ");
        }
        this.submit("Update");
        this.assertTextPresent("Edit Field Renderer Confirmation");
        this.assertTextPresent(renderer);
        this.submit("Update");
        JIRAWebTest.log("Set " + fieldId + " to renderer type " + renderer + " in the " + configuration + " configuration.");
    }

    public void gotoFieldLayoutConfiguration(String configuration) {
        this.gotoFieldLayouts();
        this.clickLink("configure-" + configuration);
        this.assertTextPresent(configuration);
    }

    public void gotoPluginsScreen() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.UPM_ADMIN_LINK);
        this.assertTextPresent("Current Plugins");
    }

    public void gotoFieldLayouts() {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
    }

    public void addEventType(String name, String description, String template) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.setFormElement("name", name);
        this.setFormElement("description", description);
        this.selectOption("templateId", template);
        this.submit("Add");
        this.checkEventTypeDetails(name, description, "Inactive", template, null, null);
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("eventTypeTable");
            String eventTypeCellText = fieldTable.getCellAsText(fieldTable.getRowCount() - 1, 0);
            JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(name));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void deleteEventType(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.clickLink("del_" + name);
        this.assertTextPresent("Please confirm that you wish to delete the event: <b>" + name + "</b>.");
        this.submit("Delete");
        this.assertTextNotPresent(name);
    }

    public String getEventTypeIDWithName(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.clickLink("edit_" + name);
        return this.getDialog().getFormParameterValue("eventTypeId");
    }

    public void checkEventTypeDetails(String eventTypeName, String eventTypeDesc, String status, String template, String notificationScheme, String workflow) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("eventTypeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(eventTypeName)) continue;
                int EVENT_TYPE_TABLE_DESC_COL = 1;
                String eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_DESC_COL);
                JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(eventTypeDesc));
                int EVENT_TYPE_TABLE_STATUS_COL = 2;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_STATUS_COL);
                JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(status));
                int EVENT_TYPE_TABLE_TEMPLATE_COL = 3;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_TEMPLATE_COL);
                JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(template));
                if (notificationScheme != null && !notificationScheme.equals("")) {
                    int EVENT_TYPE_TABLE_NOTIFIC_COL = 4;
                    eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_NOTIFIC_COL);
                    JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(notificationScheme));
                }
                if (workflow == null || workflow.equals("")) continue;
                int EVENT_TYPE_TABLE_WORKFLOW_COL = 5;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_WORKFLOW_COL);
                JIRAWebTest.assertTrue((boolean)eventTypeCellText.contains(workflow));
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void checkNotificationForEvent(String eventTypeName, String notificationType, String template) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.clickLinkWithText("Default Notification Scheme");
        try {
            String NOTIFICATION_SCHEME_TABLE = "notificationSchemeTable";
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("notificationSchemeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                int NOTIFICATION_TABLE_NAME_COL = 0;
                String field = fieldTable.getCellAsText(i, NOTIFICATION_TABLE_NAME_COL);
                if (!field.contains(eventTypeName)) continue;
                int NOTIFICATION_TABLE_TYPE_COL = 1;
                TableCell notificationCell = fieldTable.getTableCell(i, NOTIFICATION_TABLE_TYPE_COL);
                if (notificationType == null) {
                    JIRAWebTest.assertTrue((!notificationCell.asText().contains(notificationType) ? 1 : 0) != 0);
                    continue;
                }
                JIRAWebTest.assertTrue((boolean)notificationCell.asText().contains(notificationType));
            }
            this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void disableIssueLinks() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        this.assertTextPresent("Issue Linking");
        this.assertTextPresent("ON");
        this.submit("Deactivate");
        this.assertTextPresent("OFF");
    }

    public void createClonersLinkType() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        this.assertTextPresent("Issue Linking");
        this.assertTextPresent("ON");
        this.setFormElement("name", "Cloners");
        this.setFormElement("outward", "clones");
        this.setFormElement("inward", "is cloned by");
        this.submit("Add");
    }

    public void setBulkEditFieldTo(String field, String listValue) {
        JIRAWebTest.log("Set " + field + " To: \"" + listValue + "\"");
        this.checkCheckbox("actions", field);
        this.selectOption(field, listValue);
        this.assertOptionEquals(field, listValue);
    }

    public void bulkEditOperationDetailsSetAs(Map<String, String> fields) {
        this.isStepOperationDetails();
        this.assertFormElementEquals("actions", null);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            String value = entry.getValue();
            if ("fixVersions".equals(fieldName)) {
                this.setBulkEditFieldTo("fixVersions", value);
            }
            if ("versions".equals(fieldName)) {
                this.setBulkEditFieldTo("versions", value);
            }
            if ("components".equals(fieldName)) {
                this.setBulkEditFieldTo("components", value);
            }
            if ("assignee".equals(fieldName)) {
                this.setBulkEditFieldTo("assignee", value);
            }
            if (!"priority".equals(fieldName)) continue;
            this.setBulkEditFieldTo("priority", value);
        }
        this.clickOnNext();
    }

    public void bulkEditConfirmEdit(Map<String, String> fields) {
        this.isStepConfirmation();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            String value = entry.getValue();
            if ("fixVersions".equals(fieldName)) {
                this.assertTextPresent("Fix Version/s");
                this.assertTextPresent(value);
            }
            if ("versions".equals(fieldName)) {
                this.assertTextPresent("Affects Version/s");
                this.assertTextPresent(value);
            }
            if ("components".equals(fieldName)) {
                this.assertTextPresent("Component/s");
                this.assertTextPresent(value);
            }
            if ("assignee".equals(fieldName)) {
                this.assertTextPresent("Assignee");
                this.assertTextPresent(value);
            }
            if (!"priority".equals(fieldName)) continue;
            this.assertTextPresent("Priority");
            this.assertTextPresent(value);
        }
    }

    public void bulkChangeSelectIssue(String key) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(Arrays.asList(key));
        this.clickOnNext();
    }

    public void bulkChangeSelectIssues(Collection keys) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(keys);
        this.clickOnNext();
    }

    private void bulkOperationCheckIssues(Collection keys) {
        try {
            int checkBoxColumn = 0;
            WebTable table = this.getDialog().getResponse().getTableWithID("issuetable");
            int keyColumn = -1;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                String headerCell = table.getCellAsText(0, i);
                if (!headerCell.trim().equals("Key")) continue;
                keyColumn = i;
            }
            if (keyColumn < 0) {
                JIRAWebTest.fail((String)"Could not find column for Key");
            }
            int checkBoxesChecked = 0;
            for (int i = 0; i < table.getRowCount(); ++i) {
                String key = table.getCellAsText(i, keyColumn);
                if (!keys.contains(key.trim())) continue;
                TableCell checkBoxCell = table.getTableCell(i, checkBoxColumn);
                String[] elementNames = checkBoxCell.getElementNames();
                boolean foundCheckbox = false;
                for (String elementName : elementNames) {
                    if (!elementName.startsWith("bulkedit_")) continue;
                    this.checkCheckbox(elementName);
                    if (++checkBoxesChecked >= keys.size()) {
                        return;
                    }
                    foundCheckbox = true;
                    break;
                }
                if (foundCheckbox) continue;
                JIRAWebTest.fail((String)("Could not find the check box for issue with key '" + key + "'."));
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            JIRAWebTest.fail((String)"Error occurred selecting issues.");
        }
    }

    public String createIssueLinkType(String name, String outwardLinkName, String inwardLinkName) {
        String linkTypeId;
        this.activateIssueLinking();
        this.setFormElement("name", name);
        this.setFormElement("outward", outwardLinkName);
        this.setFormElement("inward", inwardLinkName);
        this.submit();
        try {
            String text = this.getDialog().getResponse().getText();
            int linkIdLocation = text.indexOf("del_" + name);
            int endOfLinkIdLocation = text.indexOf(">Del", linkIdLocation);
            String deleteLinkLocation = text.substring(linkIdLocation, endOfLinkIdLocation);
            linkIdLocation = deleteLinkLocation.indexOf("id=");
            endOfLinkIdLocation = deleteLinkLocation.indexOf("\"", linkIdLocation);
            linkTypeId = deleteLinkLocation.substring(linkIdLocation + "id=".length(), endOfLinkIdLocation);
        }
        catch (Exception e) {
            JIRAWebTest.fail((String)("Unable to retrieve Link Id for link type " + name + " : " + e.getMessage()));
            return "fail";
        }
        return linkTypeId;
    }

    public void linkIssueWithComment(String currentIssueKey, String link, String destinationIssueKey, String comment, String commentLevel, String expectedText) {
        JIRAWebTest.log("Link Issue: test linking an issue");
        this.activateIssueLinking();
        StringBuilder url = new StringBuilder().append("/secure/LinkJiraIssue.jspa?atl_token=").append(this.getPage().getXsrfToken()).append("&id=").append(this.getIssueIdWithIssueKey(currentIssueKey)).append("&linkDesc=").append(link).append("&currentIssueKey=").append(currentIssueKey).append("&issueKeys=").append(destinationIssueKey);
        if (comment != null) {
            url.append("&comment=").append(comment).append("&commentLevel=").append(commentLevel);
        }
        this.gotoPage(url.toString());
        this.assertTextPresent(expectedText);
    }

    public void linkIssueWithComment(String currentIssueKey, String link, String destinationIssueKey, String comment, String commentLevel) {
        this.linkIssueWithComment(currentIssueKey, link, destinationIssueKey, comment, commentLevel, destinationIssueKey);
    }

    public boolean isMailServerExists() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        String testExisitingMailServerId = "sendTestEmail";
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='" + testExisitingMailServerId + "']");
        return xPathLocator.getNodes().length > 0;
    }

    public String getRegexMatch(String regex) throws MalformedPatternException {
        Perl5Compiler compiler;
        Pattern pattern;
        Perl5Matcher matcher = new Perl5Matcher();
        String html = this.getDialog().getResponseText();
        if (!matcher.contains(html, pattern = (compiler = new Perl5Compiler()).compile(regex, 40))) {
            return null;
        }
        MatchResult mr = matcher.getMatch();
        return mr.group(1);
    }

    public void assertRegexMatch(String regex, boolean multiline) {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        int flags = 32;
        if (multiline) {
            flags |= 8;
            JIRAWebTest.log("Asserting regular expression \"" + regex + "\" matches the page.");
        } else {
            JIRAWebTest.log("Asserting regular expression \"" + regex + "\" matches line on the page.");
        }
        try {
            pattern = compiler.compile(regex, flags);
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)("Regular expression '" + regex + "' is not valid: " + e.getMessage()));
        }
        String html = this.getDialog().getResponseText();
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.contains(html, pattern)) {
            JIRAWebTest.fail((String)("Regular expression '" + regex + "' did not match page."));
        }
    }

    public void gotoProjectRolesScreen() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
    }

    public void editIssueType(String issueTypeId, String name, String description, String iconUrl) {
        this.editIssueType(issueTypeId, name, description, (Long)null);
    }

    public void editIssueType(String issueTypeId, String name, String description) {
        this.editIssueType(issueTypeId, name, description, (Long)null);
    }

    public void editIssueType(String issueTypeId, String name, String description, Long avatarId) {
        this.gotoPage("/secure/admin/EditIssueType!default.jspa?id=" + issueTypeId);
        this.setFormElement("name", name);
        this.setFormElement("description", description);
        if (null != avatarId) {
            this.setFormElement("avatarId", String.valueOf(avatarId));
        }
        this.submit("Update");
    }

    @Deprecated
    public String addIssueType(String name, String desc, String iconUrl) {
        return this.addIssueType(name, desc);
    }

    public String addIssueType(String name, String desc) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.clickLink("add-issue-type");
        this.setFormElement("name", name);
        this.setFormElement("description", desc);
        this.submit("Add");
        this.assertTextPresent(name);
        this.assertTextPresent(desc);
        String response = this.getDialog().getResponseText();
        String editlinkBase = "EditIssueType!default.jspa?id=";
        int indexOfMatch = 0;
        Long largestIssueTypeId = 0L;
        while (indexOfMatch > -1) {
            int endOfIdIndex;
            if ((indexOfMatch = response.indexOf(editlinkBase, indexOfMatch + 1)) <= -1 || (endOfIdIndex = response.indexOf("\"", indexOfMatch + 1)) <= -1) continue;
            Long id = Long.valueOf(response.substring(indexOfMatch + editlinkBase.length(), endOfIdIndex));
            largestIssueTypeId = Math.max(largestIssueTypeId, id);
        }
        return largestIssueTypeId.toString();
    }

    public final void associateWorkFlowSchemeToProject(String project, String workflow_scheme, Map<String, String> statusMapping) {
        this.administration.project().associateWorkflowScheme(project, workflow_scheme, statusMapping, true);
    }

    protected void enableCommentGroupVisibility(Boolean enable) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.setFormElement("title", "jWebTest JIRA installation");
        this.checkCheckbox("groupVisibility", enable.toString());
        this.submit("Update");
        if (enable.booleanValue()) {
            this.assertTextPresent("Groups &amp; Project Roles");
            this.assertTextNotPresent("Project Roles only");
        } else {
            this.assertTextNotPresent("Groups &amp; Project Roles");
            this.assertTextPresent("Project Roles only");
        }
    }

    @Deprecated
    protected void addCommentOnCurrentIssue(String comment) {
        this.addCommentOnCurrentIssue(comment, null);
    }

    @Deprecated
    protected void addCommentOnCurrentIssue(String comment, String roleLevel) {
        this.clickLink("footer-comment-button");
        this.setFormElement("comment", comment);
        if (roleLevel != null) {
            this.selectOption("commentLevel", roleLevel);
        }
        this.submit();
    }

    public String getTitle(String responseHtml) {
        return this.getTagBody("<title>", "</title>", responseHtml);
    }

    public String getTagBody(String startTag, String endTag, String html) {
        int start = html.indexOf(startTag) + startTag.length();
        int end = html.indexOf(endTag, start);
        return html.substring(start, end);
    }

    protected boolean tableCellHasText(WebTable table, int row, int col, String text) {
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for text [" + text + "]");
        String cellContent = table.getCellAsText(row, col);
        boolean result = cellContent.contains(text);
        if (!result) {
            JIRAWebTest.log("Expected '" + text + "' but was not found in '" + cellContent + "'");
        }
        return result;
    }

    protected boolean tableCellDoesNotHaveText(WebTable table, int row, int col, String text) {
        boolean result;
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for text [" + text + "]");
        String cellContent = table.getCellAsText(row, col);
        boolean bl = result = !cellContent.contains(text);
        if (!result) {
            JIRAWebTest.log("Didn't expect '" + text + "' but was found in '" + cellContent + "'");
        }
        return result;
    }

    protected boolean tableCellHasStrictText(WebTable table, int row, int col, String text) {
        String cellContent = table.getCellAsText(row, col);
        boolean result = "".equals(text) ? "".equals(cellContent.trim()) : cellContent.contains(text);
        if (!result) {
            // empty if block
        }
        return result;
    }

    protected boolean tableCellHasLinkThatContains(WebTable table, int row, int col, String link) {
        if (link == null) {
            return this.tableCellHasNoLinks(table, row, col);
        }
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for link [" + link + "]");
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        if (links != null) {
            for (WebLink webLink : links) {
                String urlString = webLink.getURLString();
                if (urlString == null || !urlString.contains(link)) continue;
                return true;
            }
        }
        JIRAWebTest.log("Expected '" + link + "' but was not found in '" + table.getCellAsText(row, col) + "'");
        return false;
    }

    protected void assertTableCellHasImage(WebTable table, int row, int col, String stringInImageSource) {
        JIRAWebTest.assertTrue((String)"Expected image not found. Please see logs for details.", (boolean)new ImageCell(stringInImageSource).equals(table, row, col));
    }

    protected void assertTableCellHasNoImage(WebTable table, int row, int col) {
        WebImage[] webImages = table.getTableCell(row, col).getImages();
        if (webImages != null && webImages.length > 0) {
            JIRAWebTest.fail((String)("An image was found in a cell where it wasn't expected. First image = '" + webImages[0].getSource() + "'."));
        }
    }

    protected boolean tableCellHasNoLinks(WebTable table, int row, int col) {
        boolean result;
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for no links");
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        boolean bl = result = links == null || links.length == 0;
        if (!result) {
            JIRAWebTest.log("Links were not expected but were found in '" + table.getTableCell(row, col).asText() + "'");
        }
        return result;
    }

    private boolean tableRowEquals(WebTable table, int row, Object[] expectedRow) {
        return this.tableRowEquals(table, row, Arrays.asList(expectedRow));
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow) {
        if (expectedRow.isEmpty()) {
            JIRAWebTest.log("expected row is empty");
            return false;
        }
        int maxCol = table.getColumnCount();
        for (int col = 0; col < expectedRow.size() && col < maxCol; ++col) {
            Object expectedCell = expectedRow.get(col);
            if (expectedCell == null) continue;
            if (expectedCell instanceof SimpleCell) {
                SimpleCell simpleCell = (SimpleCell)expectedCell;
                if (simpleCell.equals(table, row, col)) continue;
                String cellContent = simpleCell.getCellAsText(table, row, col);
                JIRAWebTest.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
                return false;
            }
            if (this.tableCellHasStrictText(table, row, col, expectedCell.toString())) continue;
            String cellContent = table.getCellAsText(row, col).trim();
            JIRAWebTest.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
            return false;
        }
        return true;
    }

    public void assertTableRowEquals(WebTable table, int row, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Expected row '" + this.prettyParseRow(expectedRow) + "' does not match '" + this.getTableRowAsList(table, row) + "' (row '" + row + "' of table '" + table.getID() + "')"), (boolean)this.tableRowEquals(table, row, expectedRow));
    }

    public List<String> getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    public void assertTableHasNoMatchingRow(WebTable table, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Found a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' when unexpected"), (this.tableIndexOf(table, Arrays.asList(expectedRow)) == -1 ? 1 : 0) != 0);
    }

    public void assertTableHasNoMatchingRow(WebTable table, int minRow, Object[] expectedRow) {
        this.assertTableHasNoMatchingRowFromTo(table, minRow, table.getRowCount(), expectedRow);
    }

    public void assertTableHasNoMatchingRowFromTo(WebTable table, int minRow, int maxRow, Object[] expectedRow) {
        int rowIndex;
        if (minRow > maxRow) {
            int temp = maxRow;
            maxRow = minRow;
            minRow = temp;
        }
        if ((rowIndex = this.tableIndexOf(table, Arrays.asList(expectedRow))) != -1) {
            if (rowIndex < minRow || rowIndex >= maxRow) {
                return;
            }
            JIRAWebTest.fail((String)("Found a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' between min index [" + minRow + "] and max index [" + maxRow + "] when unexpected"));
        }
    }

    public void assertTableHasOnlyNMatchingRows(WebTable table, int n, Object[] expectedRow) {
        if (n > 0) {
            int lastMatchingRow = 0;
            List<Object> rowList = Arrays.asList(expectedRow);
            for (int c = 0; c < n; ++c) {
                lastMatchingRow = this.tableIndexOf(table, lastMatchingRow, rowList);
                JIRAWebTest.assertTrue((String)("Found '" + c + "' of '" + n + "' rows of '" + rowList + "' on table '" + table.getID() + "'"), (lastMatchingRow != -1 ? 1 : 0) != 0);
                ++lastMatchingRow;
            }
            JIRAWebTest.assertTrue((String)("Found more than '" + n + "' rows of '" + rowList + "' on table '" + table.getID() + "'"), (this.tableIndexOf(table, lastMatchingRow, rowList) == -1 ? 1 : 0) != 0);
        } else {
            this.assertTableHasNoMatchingRow(table, expectedRow);
        }
    }

    public void assertTableHasMatchingRow(WebTable table, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "'"), (this.tableIndexOf(table, Arrays.asList(expectedRow)) != -1 ? 1 : 0) != 0);
    }

    public void assertTableHasMatchingRowFrom(WebTable table, int minRow, Object[] expectedRow) {
        JIRAWebTest.log("Asserting table '" + table.getID() + "' has a row from '" + minRow + "' that matches '" + this.prettyParseRow(expectedRow) + "'");
        String message = "Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' from row '" + minRow + "'";
        JIRAWebTest.assertTrue((String)message, (this.tableIndexOf(table, minRow, table.getRowCount(), Arrays.asList(expectedRow)) != -1 ? 1 : 0) != 0);
    }

    public void assertTableHasMatchingRowFromTo(WebTable table, int minRow, int maxRow, Object[] expectedRow) {
        JIRAWebTest.log("Asserting table '" + table.getID() + "' has a row from '" + minRow + "' to '" + maxRow + "' that matches '" + this.prettyParseRow(expectedRow) + "'");
        String message = "Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' from row '" + minRow + "' to '" + maxRow + "'";
        int index = this.tableIndexOf(table, minRow, maxRow, Arrays.asList(expectedRow));
        JIRAWebTest.assertTrue((String)message, (index != -1 ? 1 : 0) != 0);
    }

    public String prettyParseRow(Object[] expectedRow) {
        return this.prettyParseRow(Arrays.asList(expectedRow));
    }

    public String prettyParseRow(List expectedRow) {
        StringBuilder sb = new StringBuilder("\n");
        int col = 0;
        for (Object o : expectedRow) {
            sb.append("  Column '").append(col).append("' = ").append(o).append("\n");
            ++col;
        }
        return sb.toString();
    }

    public int tableIndexOf(WebTable table, Object[] expectedRow) {
        return this.tableIndexOf(table, Arrays.asList(expectedRow));
    }

    public int tableIndexOf(WebTable table, int minRow, Object[] expectedRow) {
        return this.tableIndexOf(table, minRow, Arrays.asList(expectedRow));
    }

    public int tableIndexOf(WebTable table, List expectedRow) {
        return this.tableIndexOf(table, 0, table.getRowCount(), expectedRow);
    }

    public int tableIndexOf(WebTable table, int minRow, List expectedRow) {
        return this.tableIndexOf(table, minRow, table.getRowCount(), expectedRow);
    }

    public int tableIndexOf(WebTable table, int minRow, int maxRow, List expectedRow) {
        JIRAWebTest.log("Scanning table '" + table.getID() + "' from row '" + minRow + "' (inclusive) to row '" + maxRow + "' (exclusive) for '" + expectedRow + "'");
        if (minRow < 0) {
            return -1;
        }
        int lastRow = table.getRowCount() < maxRow ? table.getRowCount() : maxRow;
        for (int row = minRow; row < lastRow; ++row) {
            if (!this.tableRowEquals(table, row, expectedRow)) continue;
            JIRAWebTest.log("Found expected row on row '" + row + "' of table '" + table.getID() + "'");
            return row;
        }
        return -1;
    }

    public boolean tableHasSubTable(WebTable table, Object[][] expectedSubTable) {
        int maxRow = table.getRowCount();
        for (int row = 0; row < maxRow; ++row) {
            if (!this.tableRowEquals(table, row, expectedSubTable[0])) continue;
            boolean isSubTable = true;
            for (int subRow = 1; subRow < maxRow && subRow < expectedSubTable.length && isSubTable; ++subRow) {
                if (this.tableRowEquals(table, row + subRow, expectedSubTable[subRow])) continue;
                isSubTable = false;
            }
            if (!isSubTable) continue;
            return true;
        }
        return false;
    }

    public void assertTableHasSubTable(WebTable table, Object[][] expectedSubTable) {
        StringBuilder sb = new StringBuilder("Table:");
        sb.append(table.getID());
        sb.append(": does not contain expected subTable : \n");
        for (int i = 0; i < expectedSubTable.length; ++i) {
            Object[] innerArr;
            Object[] arr = expectedSubTable[i];
            if (arr == null || !arr.getClass().isArray()) continue;
            sb.append("[");
            sb.append(i);
            sb.append("] ");
            for (Object o : innerArr = arr) {
                sb.append("'");
                sb.append(String.valueOf(o));
                sb.append("'");
                sb.append(",");
            }
            sb.append("\n");
        }
        JIRAWebTest.assertTrue((String)sb.toString(), (boolean)this.tableHasSubTable(table, expectedSubTable));
    }

    public void assertTextListPresent(Iterable<String> iterable) {
        if (iterable != null) {
            for (String text : iterable) {
                this.assertTextPresent(text);
            }
        }
    }

    public void assertTextListNotPresent(Iterable<String> iterable) {
        if (iterable != null) {
            for (String text : iterable) {
                this.assertTextNotPresent(text);
            }
        }
    }

    @Deprecated
    public void checkCommentVisibility(String usernameAndPassword, String issueKey, Iterable<String> expectedPresentComments, Iterable<String> expectedAbsentComments) {
        this.logout();
        this.login(usernameAndPassword, usernameAndPassword);
        this.gotoIssue(issueKey);
        this.assertTextListPresent(expectedPresentComments);
        this.assertTextListNotPresent(expectedAbsentComments);
        this.login("admin", "admin");
    }

    public void toggleExternalUserManagement(boolean enable) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        if (enable) {
            this.checkCheckbox("externalUM", "true");
            this.tester.selectOption("mode", "Private");
        } else {
            this.checkCheckbox("externalUM", "false");
        }
        this.submit("Update");
    }

    protected void assertSubTaskConversionPanelSteps(String key, int currentStep) {
        this.assertTextSequence(new String[]{"Convert Issue to Sub-task: " + key, "Select Parent and Sub-task Type", "Select New Status", "Update Fields", "Confirmation"});
        String[] icons = new String[4];
        for (int i = 1; i <= 4; ++i) {
            icons[i - 1] = i < currentStep ? "<li class=\"done\">" : (i > currentStep ? "<li class=\"todo\">" : "<li class=\"current\">");
        }
        this.assertTextSequence(icons);
    }

    public void gotoConvertIssue(String issueId) {
        this.gotoPage("/secure/ConvertIssue.jspa?id=" + issueId);
    }

    public void gotoConvertIssueStep2(String issueId, String parent, String issueType) {
        this.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + parent + "&issuetype=" + issueType);
    }

    public void gotoConvertSubTask(String issueId) {
        this.gotoPage("/secure/ConvertSubTask.jspa?id=" + issueId);
    }

    public void gotoConvertSubTaskStep2(String issueId, String issueType) {
        this.gotoPage("/secure/ConvertSubTaskSetIssueType.jspa?id=" + issueId + "&issuetype=" + issueType);
    }

    protected void gotoConvertIssueStep3(String issueId, String parentKey, String issueType, String status) {
        this.gotoPage("/secure/ConvertIssueSetStatus.jspa?id=" + issueId + "&parentIssueKey=" + parentKey + "&issuetype=" + issueType + "&targetStatusId=" + status);
    }

    public void assertLinkPresentWithSubString(String linkId, String urlSubString) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean foundSubString = link.getURLString().contains(urlSubString);
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have substring " + urlSubString), (boolean)foundSubString);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkPresentWithoutSubString(String linkId, String urlSubString) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean substringNotFound = !link.getURLString().contains(urlSubString);
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have substring " + urlSubString), (boolean)substringNotFound);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkPresentWithURL(String linkId, String urlSuffix) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean foundSuffix = link.getURLString().endsWith(urlSuffix);
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have suffix " + urlSuffix), (boolean)foundSuffix);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkWithTextUrlEndsWith(String linkText, String urlSuffix) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            JIRAWebTest.assertFalse((String)"Expected links!", (links.length == 0 ? 1 : 0) != 0);
            boolean foundLink = false;
            StringBuilder foundLinksSummary = new StringBuilder();
            int candidateLinks = 0;
            for (WebLink link : links) {
                if (link.getURLString() == null || link.asText() == null || !link.asText().equals(linkText)) continue;
                ++candidateLinks;
                String urlString = link.getURLString();
                foundLinksSummary.append("\n").append(urlString);
                foundLink = urlString.endsWith(urlSuffix);
                if (foundLink) break;
            }
            if (!foundLink) {
                StringBuilder mesg = new StringBuilder();
                mesg.append("Could not find link with text '");
                mesg.append(linkText);
                mesg.append("' that has a url that ends with '");
                mesg.append(urlSuffix);
                mesg.append("'. ");
                if (candidateLinks > 0) {
                    mesg.append(candidateLinks);
                    mesg.append(" rejected candidates: [ ");
                    mesg.append((CharSequence)foundLinksSummary);
                    mesg.append("]");
                }
                JIRAWebTest.fail((String)mesg.toString());
            }
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating link with text " + linkText));
        }
    }

    public void assertLinkWithTextUrlContains(String linkText, String[] strings) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            JIRAWebTest.assertFalse((String)"Expected links!", (links.length == 0 ? 1 : 0) != 0);
            boolean foundLink = false;
            StringBuilder foundLinksSummary = new StringBuilder();
            int candidateLinks = 0;
            for (WebLink link : links) {
                if (link.getURLString() == null || link.asText() == null || !link.asText().equals(linkText)) continue;
                ++candidateLinks;
                String urlString = link.getURLString();
                foundLinksSummary.append("\n").append(urlString);
                for (String string : strings) {
                    if (!urlString.contains(string)) {
                        foundLink = false;
                        break;
                    }
                    foundLink = true;
                }
                if (foundLink) break;
            }
            if (!foundLink) {
                StringBuilder mesg = new StringBuilder();
                mesg.append("Could not find link with text '");
                mesg.append(linkText);
                mesg.append("' that contains all ");
                for (String string : strings) {
                    mesg.append("'").append(string).append("' ");
                }
                mesg.append(". ");
                if (candidateLinks > 0) {
                    mesg.append(candidateLinks);
                    mesg.append(" rejected candidates: [ ");
                    mesg.append((CharSequence)foundLinksSummary);
                    mesg.append("]");
                }
                JIRAWebTest.fail((String)mesg.toString());
            }
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating link with text " + linkText));
        }
    }

    public void assertTableCellHasText(String tableId, int row, int column, String text) {
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
            JIRAWebTest.assertNotNull((Object)table);
            boolean hasText = this.tableCellHasText(table, row, column, text);
            String actualText = table.getCellAsText(row, column);
            JIRAWebTest.assertTrue((String)("expected to find [" + text + "], somewhere in [" + actualText + "] but obviously couldn't."), (boolean)hasText);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating table with id [" + tableId + "]"));
        }
    }

    protected void assertResponseCanBeCached() {
        String cacheControl = this.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store"};
        if (cacheControl != null && StringUtils.isNotEmpty((String)cacheControl)) {
            for (String value : values) {
                JIRAWebTest.assertFalse((String)("Response cannot be cached: found '" + value + "' in Cache-control header"), (boolean)cacheControl.contains(value));
            }
        }
    }

    protected void assertResponseCannotBeCached() {
        String cacheControl = this.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store", "must-revalidate"};
        if (cacheControl != null && StringUtils.isNotEmpty((String)cacheControl)) {
            boolean found = false;
            for (String value : values) {
                found = found || cacheControl.contains(value);
            }
            if (!found) {
                JIRAWebTest.fail((String)"Cache-control header was set, but was not set to 'no-cache', 'no-store' or 'must-revalidate'");
            }
        } else {
            JIRAWebTest.fail((String)"No Cache-control header was set in the response");
        }
    }

    protected void gotoDefaultPermissionScheme() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.clickLinkWithText("Default Permission Scheme");
    }

    @Deprecated
    protected void grantPermissionToUserInEnterprise(int permission, String username) {
        this.backdoor.permissionSchemes().addUserPermission(0L, (ProjectPermissionKey)LegacyProjectPermissionKeyMapping.ID_TO_KEY.get((Object)permission), username);
    }

    @Deprecated
    public void addProjectAdminPermission(int permission, String group) {
        String permissionKey = LegacyProjectPermissionKeyMapping.getKey(permission);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.clickLink("0_edit");
        this.clickLink("add_perm_" + permissionKey);
        this.checkCheckbox("type", "group");
        this.selectOption("group", group);
        this.submit(" Add ");
    }

    protected void gotoFieldConfigurationDefault() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.clickLink("configure-Default Field Configuration");
        this.assertTextPresent("View Field Configuration");
    }

    protected void assertTableCellContainsFixVersionsLinks(TableCell fixVersionsCell, int expectedLinkCount) {
        WebLink[] links = fixVersionsCell.getLinks();
        JIRAWebTest.assertNotNull((Object)links);
        JIRAWebTest.assertEquals((int)expectedLinkCount, (int)links.length);
    }

    protected void assertTableCellContainsNoFixVersionsLinks(TableCell fixVersionsCell) {
        WebLink[] links = fixVersionsCell.getLinks();
        JIRAWebTest.assertTrue((links == null || links.length == 0 ? 1 : 0) != 0);
    }

    protected void assertTableCellContainsPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        JIRAWebTest.assertNotNull((Object)images);
        JIRAWebTest.assertEquals((int)1, (int)images.length);
        WebImage icon = images[0];
        JIRAWebTest.assertTrue((boolean)icon.getSource().contains("/images/icons"));
    }

    protected void assertTableCellContainsNoPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        JIRAWebTest.assertTrue((images == null || images.length == 0 ? 1 : 0) != 0);
    }

    @Override
    public void dumpResponse() {
        this.dumpResponse(new RuntimeException("HTML Dump Invoked : invoked around"));
    }

    @Override
    public void dumpResponse(Throwable t) {
        TestCaseDumpKit.dumpTestInformation((TestCase)this, new Date(), t);
    }

    protected void logWork(String issueKey, String timeLogged, String newEstimate) {
        this.gotoIssue(issueKey);
        this.logWork(timeLogged, newEstimate);
    }

    private void logWork(String timeLogged, String newEstimate) {
        this.clickLink("log-work");
        this.setFormElement("timeLogged", timeLogged);
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", newEstimate);
        this.clickButton("log-work-submit");
    }

    protected void setEstimate(String time) {
        this.clickLink("edit-issue");
        this.setFormElement("timetracking", time);
        this.submit("Update");
    }

    protected void waitForSuccessfulWorkflowSchemeMigration(String projectName, String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.submit("Refresh");
            } else {
                if (this.getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                    this.validateProgressBarUI("Done");
                    this.submit("Done");
                    this.assertTextInElement("project-config-header-name", projectName);
                    WorkflowSchemeData scheme = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    JIRAWebTest.assertEquals((String)scheme.getName(), (String)targetWorkflowName);
                    return;
                }
                if (this.getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                    this.validateProgressBarUI("Acknowledge");
                    this.submit("Acknowledge");
                    this.assertTextInElement("project-config-header-name", projectName);
                    WorkflowSchemeData scheme = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    JIRAWebTest.assertEquals((String)scheme.getName(), (String)targetWorkflowName);
                    return;
                }
                if (this.getDialog().getElement("project-config-header-name") != null) {
                    return;
                }
                JIRAWebTest.fail((String)("Page encountered during migration that was not expected : PROJECT:" + projectName + " - WORKFLOW SCHEME NAME" + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected long getSubmittedTaskId() {
        this.waitForStableTaskPage();
        return this.getTaskIdFromProgressBarUI();
    }

    protected void switchToPersonalLicense() {
        String licenseTitle = this.getEdition();
        String licenseKey = LicenseKeys.V2_PERSONAL.getLicenseString();
        this.switchLicense(licenseKey, "JIRA " + licenseTitle + ": Personal");
    }

    protected void switchLicense(String licenseKey, String licenseDescription) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
        this.setFormElement("license", licenseKey);
        this.submit("Add");
        this.assertTextPresent("License Information");
        this.assertTextPresent(licenseDescription);
    }

    protected void waitForTaskAcknowledgement(long taskId) {
        this.waitForTaskState(taskId, "Acknowledge");
    }

    private void waitForTaskState(long taskId, String desiredTaskState) {
        String taskState;
        do {
            taskState = this.waitForStableTaskPage();
            long taskIdTest = this.getSubmittedTaskId();
            if (taskId != taskIdTest) {
                JIRAWebTest.fail((String)("Expecting taskid <" + taskId + "> but got <" + taskIdTest + ">"));
            }
            if (taskState.equals(desiredTaskState)) {
                return;
            }
            if (!taskState.equals("Refresh")) continue;
            this.submit("Refresh");
        } while (!desiredTaskState.equalsIgnoreCase(taskState));
    }

    private String waitForStableTaskPage() {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The task took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                return "Refresh";
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                this.validateProgressBarUI("Done");
                return "Done";
            }
            if (this.getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                this.validateProgressBarUI("Acknowledge");
                return "Acknowledge";
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    private long getTaskIdFromProgressBarUI() {
        String taskLocatorStr = "<div class=\"pb_border\" id=\"pb_taskid_";
        int startIndex = this.getResponseText().indexOf(taskLocatorStr);
        if (startIndex == -1) {
            JIRAWebTest.fail((String)"Failed to find task progress bar as expected");
        }
        int endIndex = this.getResponseText().indexOf("\">", startIndex += taskLocatorStr.length());
        String taskId = this.getResponseText().substring(startIndex, endIndex);
        return Long.parseLong(taskId);
    }

    protected void validateProgressBarUI(String desiredTaskState) {
        String tmp;
        Integer leftPrecentage = null;
        Integer rightPercentage = null;
        try {
            tmp = this.getRegexMatch("pb_barlefttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"");
            if (tmp != null) {
                leftPrecentage = new Integer(tmp);
            }
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)"Left table regular expression is invalid.");
        }
        try {
            tmp = this.getRegexMatch("pb_barrighttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"");
            if (tmp != null) {
                rightPercentage = new Integer(tmp);
            }
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)"Right table regular expression is invalid.");
        }
        if ("Acknowledge".equalsIgnoreCase(desiredTaskState) || "Done".equalsIgnoreCase(desiredTaskState)) {
            this.assertTextPresent("Task completed");
            this.assertTextPresent("Started");
            this.assertTextPresent("Finished");
            JIRAWebTest.assertNull((Object)rightPercentage);
            JIRAWebTest.assertEquals((int)100, (int)leftPrecentage);
            if ("Done".equalsIgnoreCase(desiredTaskState)) {
                this.assertTextPresent("<span>Started");
                this.assertRegexMatch("by <a href=\"/.*/secure/admin/user/ViewUser.jspa?name=", false);
                this.getAssertions().assertNodeHasText(new CssLocator(this.tester, ".aui-message.info"), "This task has finished running.");
                this.getAssertions().assertNodeHasText(new CssLocator(this.tester, ".aui-message.info"), "who started this task should acknowledge it.");
            }
        } else {
            this.assertTextNotPresent("Task completed");
            this.assertTextNotPresent("Finished");
            if (leftPrecentage == null) {
                JIRAWebTest.assertEquals((int)100, (int)rightPercentage);
            } else if (rightPercentage == null) {
                JIRAWebTest.assertEquals((int)100, (int)leftPrecentage);
            } else {
                JIRAWebTest.assertFalse((String)"Task should not be complete", (100 == leftPrecentage ? 1 : 0) != 0);
                JIRAWebTest.assertFalse((String)"Task should not be complete", (100 == rightPercentage ? 1 : 0) != 0);
                JIRAWebTest.assertEquals((int)leftPrecentage, (int)(100 - rightPercentage));
            }
        }
    }

    protected void waitForSuccessfulWorkflowActivation(String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.submit("Refresh");
            } else {
                if (this.getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                    this.validateProgressBarUI("Done");
                    this.submit("Done");
                    return;
                }
                if (this.getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                    this.validateProgressBarUI("Acknowledge");
                    this.submit("Acknowledge");
                    return;
                }
                JIRAWebTest.fail((String)("Page encountered during migration that was not expected - " + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected void associateIssueLevelSecuritySchemeToProject(String projectName, String schemeName) {
        Project project = this.getProjectByName(projectName);
        this.gotoPage("/secure/project/SelectProjectScheme!default.jspa?projectId=" + project.id);
        this.selectOption("newSchemeId", schemeName);
        this.submit("Next >>");
        this.submit("Associate");
    }

    protected void gotoPortletConfig() {
        this.clickLinkWithText("Manage Dashboard");
        this.clickLink("config_0");
    }

    protected void assertHelpLinkWithStringInUrlPresent(String linkPart) {
        JIRAWebTest.assertTrue((boolean)this.hasHelpLink(linkPart));
    }

    private boolean hasHelpLink(String linkPart) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            if (links != null) {
                for (WebLink link : links) {
                    String urlString = link.getURLString();
                    if (urlString == null || !urlString.contains(linkPart)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SAXException e) {
            return false;
        }
    }

    protected void assertTextNotInColumn(String tableId, int column, String text) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            String operationsCell = table.getCellAsText(i, column);
            JIRAWebTest.log("Checking cell on row[" + i + "] col[" + column + "] doesn't have text [" + text + "]");
            JIRAWebTest.assertTrue((!operationsCell.contains(text) ? 1 : 0) != 0);
        }
    }

    protected void assertTableCellHasNotText(String tableId, int row, int col, String text) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
        JIRAWebTest.assertTrue((!table.getCellAsText(row, col).contains(text) ? 1 : 0) != 0);
    }

    protected String getEdition() {
        return "Enterprise";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertRedirectAndFollow(String url, String redirectRegex) {
        try {
            this.getTester().getTestContext().getWebClient().getClientProperties().setAutoRedirect(false);
            this.gotoPage(url);
            String redirectTo = this.getDialog().getResponse().getHeaderField("Location");
            boolean redirectingToCreateIssueStep2 = redirectTo.matches(redirectRegex);
            JIRAWebTest.assertTrue((String)("expected redirect to create issue, location header is: " + redirectTo), (boolean)redirectingToCreateIssueStep2);
            this.gotoPage(redirectTo);
        }
        finally {
            this.getTester().getTestContext().getWebClient().getClientProperties().setAutoRedirect(true);
        }
    }

    public void enableRemoteApi() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.checkCheckbox("allowRpc", "true");
        this.submit("Update");
    }

    public void addWorkflowPostfunction(String workflowName, String stepName, String transitionName, String postFunctionName) {
        this.administration.workflows().goTo().workflowSteps(workflowName);
        this.clickLinkWithText(transitionName);
        this.clickLinkWithText("Post Functions");
        this.clickLinkWithText("Add post function", 0);
        this.selectMultiOptionByValue("type", postFunctionName);
        this.submit();
    }

    @Deprecated
    protected void turnOffDangerMode() {
    }

    @Deprecated
    protected void turnOnDangerMode() {
    }

    protected void addWorkflowCondition(String workflowName, String stepName, String condition) {
        this.addWorkflowCondition(workflowName, stepName, condition, null);
    }

    protected void addWorkflowCondition(String workflowName, String stepName, String condition, ParameterEnterer paramEnterer) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflowName);
        this.clickLinkWithText(stepName);
        this.clickLink("add-workflow-condition");
        this.checkCheckbox("type", condition);
        this.submit("Add");
        if (paramEnterer != null) {
            paramEnterer.enterParameters();
        }
    }

    protected void addWorkflowValidator(String workflowName, String stepName, String validator) {
        this.addWorkflowValidator(workflowName, stepName, validator, null);
    }

    protected void addWorkflowValidator(String workflowName, String stepName, String validator, ParameterEnterer paramEnterer) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflowName);
        this.clickLinkWithText(stepName);
        this.clickLinkWithText("Validators");
        this.clickLink("add_new_validator");
        this.checkCheckbox("type", validator);
        this.submit("Add");
        if (paramEnterer != null) {
            paramEnterer.enterParameters();
        }
    }

    @Deprecated
    protected String getBuild() {
        this.gotoAdmin();
        CssLocator poweredByLocator = new CssLocator(this.tester, "#footer-build-information");
        String poweredByText = poweredByLocator.getRawText();
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\((.*)\\)");
        Matcher m = p.matcher(poweredByText);
        if (!m.find()) {
            JIRAWebTest.fail((String)"Could not find version footer in expected location");
        }
        String versionFooter = m.group(1);
        String[] footerParts = versionFooter.split("#");
        return footerParts[footerParts.length - 1];
    }

    public boolean usingHsqlDb() throws IOException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        try {
            WebTable systemInfoTable = this.getDialog().getResponse().getTableWithID("system_info_table");
            return this.tableIndexOf(systemInfoTable, EasyList.build((Object)"Database type", (Object)"hsql")) != -1;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected XPathLocator xpath(String xpathExpression) {
        return this.locator.xpath(xpathExpression);
    }

    public void setUp() {
        this.init();
    }

    public void init() {
        DefaultFuncTestHttpUnitOptions.setDefaultOptions();
        this.setUpHttpUnitOptions();
        this.startTime = System.currentTimeMillis();
        this.webClientListener = new FuncTestWebClientListener();
        JIRAEnvironmentData environmentData = this.getEnvironmentData();
        WebTesterFactory.setupWebTester(this.tester, environmentData);
        new JiraSetupInstanceHelper(this.tester, environmentData).ensureJIRAIsReadyToGo(this.webClientListener);
        this.getAdministration();
        this.getAssertions();
        this.getNavigation();
        this.getPage();
        try {
            if (this.backdoor.dataImport().isSetUp()) {
                this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
            }
        }
        catch (Exception e) {
            JIRAWebTest.log("failed to disable onboarding ", e);
        }
    }

    protected void setUpHttpUnitOptions() {
    }

    public boolean isJiraSetup() {
        this.beginAt("/");
        boolean hasBeenSetUp = (this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa").equals(this.getDialog().getResponse().getURL().getPath());
        return hasBeenSetUp;
    }

    @Override
    public void tearDown() {
        this.logout();
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        this.initFuncTestCaseLikeProtectedVariables();
        try {
            super.runTest();
        }
        catch (Throwable throwable) {
            try {
                TestCaseDumpKit.dumpTestInformation((TestCase)this, new Date(), throwable);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void runBare() throws Throwable {
        this.startTime = System.currentTimeMillis();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        JIRAEnvironmentData data = this.getEnvironmentData();
        LogOnBothSides.log(this.backdoor.getTestkit(), TestInformationKit.getStartMsg((TestCase)this, data.getTenant()));
        try {
            super.runBare();
            LogOnBothSides.log(this.backdoor.getTestkit(), TestInformationKit.getEndMsg((TestCase)this, data.getTenant(), System.currentTimeMillis() - this.startTime, this.webClientListener));
        }
        catch (Throwable throwable) {
            LogOnBothSides.log(this.backdoor.getTestkit(), TestInformationKit.getEndMsg((TestCase)this, data.getTenant(), System.currentTimeMillis() - this.startTime, this.webClientListener, throwable));
            throw throwable;
        }
        finally {
            this.clearTestCaseVariables();
        }
    }

    private void initFuncTestCaseLikeProtectedVariables() {
        this.getNavigation();
        this.getAdministration();
        this.getAssertions();
        this.getEnvironmentData();
        this.form = new FormImpl(this.tester);
        this.page = new HtmlPage(this.tester);
        this.text = new TextAssertionsImpl(this.tester);
        this.issueTableAssertions = new IssueTableAssertions(this.getBackdoor());
        this.parse = new ParserImpl(this.tester, this.getEnvironmentData());
        this.locator = this.getLocatorFactory();
        this.log = new FuncTestLoggerImpl(3);
    }

    private LocatorFactory getLocatorFactory() {
        if (this.locator == null) {
            return new LocatorFactoryImpl(this.tester);
        }
        return this.locator;
    }

    private void clearTestCaseVariables() {
        this.tester = null;
        this.environmentData = null;
        this.navigation = null;
        this.form = null;
        this.page = null;
        this.parse = null;
        this.administration = null;
        this.assertions = null;
        this.text = null;
        this.log = null;
        this.locator = null;
        this.webClientListener = null;
    }

    public static interface ParameterEnterer {
        public void enterParameters();
    }
}

