/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.TestSuiteBuilder;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.FunctionalCategoryComparator;
import com.atlassian.jira.functest.framework.suite.SystemPropertyBasedSuite;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.util.TestClassUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class CategorisingTestSuite
implements Test {
    public static final CategorisingTestSuite SUITE = new CategorisingTestSuite();
    private static final String NUMBER_OF_BATCHES_PROPERTY_NAME = "atlassian.test.suite.numbatches";
    private static final String BATCH_NO_PROPERTY_NAME = "atlassian.test.suite.batch";
    private static final String PARALLEL_PROPERTY_NAME = "atlassian.test.suite.parallel";
    private final SystemPropertyBasedSuite realSuite = new SystemPropertyBasedSuite();

    public static Test suite() {
        return SUITE.createTest();
    }

    private static TestSuiteBuilder createFuncTestBuilder() {
        String b = System.getProperty(NUMBER_OF_BATCHES_PROPERTY_NAME);
        String n = System.getProperty(BATCH_NO_PROPERTY_NAME);
        boolean parallel = Boolean.getBoolean(PARALLEL_PROPERTY_NAME);
        if (parallel && b != null) {
            int numBatches = Integer.parseInt(b);
            return new TestSuiteBuilder().maxBatch(numBatches).parallel(true).log(true);
        }
        if (b != null && n != null) {
            String batchInfo = "Batch " + n + " of " + b;
            try {
                int numBatches = Integer.parseInt(b);
                int batch = Integer.parseInt(n);
                if (batch > 0 && batch <= numBatches) {
                    FuncTestOut.out.println(batchInfo);
                    return new TestSuiteBuilder(batch, numBatches).log(true);
                }
                FuncTestOut.out.println("Batch mode FAIL. Batch information looks wrong-arse: " + batchInfo);
            }
            catch (NumberFormatException e) {
                FuncTestOut.err.println("Batch mode FAIL. Batch information cannot be properly interpreted: " + batchInfo);
                e.printStackTrace(FuncTestOut.err);
            }
        }
        return new TestSuiteBuilder().log(true);
    }

    public int countTestCases() {
        return this.createTest().countTestCases();
    }

    public void run(TestResult result) {
        this.createTest().run(result);
    }

    private Test createTest() {
        Collection<Class<? extends TestCase>> tests = this.getTests();
        return CategorisingTestSuite.createFuncTestBuilder().addTests(tests).build();
    }

    private Collection<Class<? extends TestCase>> getTests() {
        List<Class<? extends TestCase>> allTestsInPackage = TestClassUtils.getJUni3TestClasses(this.realSuite.webTestPackage(), true);
        ArrayList filtered = Lists.newArrayList((Iterable)Iterables.filter(allTestsInPackage, (Predicate)new CategoryMatchPredicate(this.realSuite.includes(), this.realSuite.excludes())));
        Collections.sort(filtered, FunctionalCategoryComparator.INSTANCE);
        return new LinkedHashSet<Class<? extends TestCase>>(filtered);
    }

    public static class CategoryMatchPredicate
    implements Predicate<Class<? extends TestCase>> {
        private final Set<Category> included;
        private final Set<Category> excluded;

        public CategoryMatchPredicate(Set<Category> includedCategories, Set<Category> excludedCategories) {
            this.included = includedCategories.size() > 0 ? EnumSet.copyOf(includedCategories) : EnumSet.noneOf(Category.class);
            this.excluded = excludedCategories.size() > 0 ? EnumSet.copyOf(excludedCategories) : EnumSet.noneOf(Category.class);
        }

        public boolean apply(@Nullable Class<? extends TestCase> input) {
            return this.hasCorrectCategoryAnnotation(input);
        }

        private boolean hasCorrectCategoryAnnotation(Class<? extends TestCase> testClass) {
            Set<Category> categories = this.categories(testClass);
            if (categories.isEmpty()) {
                return this.included == null;
            }
            for (Category each : categories) {
                if (this.excluded == null || !this.excluded.contains((Object)each)) continue;
                return false;
            }
            for (Category each : categories) {
                if (this.included != null && !this.included.contains((Object)each)) continue;
                return true;
            }
            return false;
        }

        private Set<Category> categories(Class<? extends TestCase> testClass) {
            WebTest annotation = testClass.getAnnotation(WebTest.class);
            if (annotation == null || annotation.value().length == 0) {
                return EnumSet.noneOf(Category.class);
            }
            return EnumSet.copyOf(Arrays.asList(annotation.value()));
        }
    }
}

