/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiMaps {
    public static <K, V, C extends Collection<V>> MultiMap<K, V, C> create(Map<K, C> basedOn, Supplier<C> collectionFactory) {
        return new MMap(basedOn, collectionFactory);
    }

    public static <K, V, C extends Collection<V>> MultiMap<K, V, C> create(Supplier<C> collectionFactory) {
        return new MMap(new HashMap(), collectionFactory);
    }

    static class MMap<K, V, C extends Collection<V>>
    extends AbstractMap<K, C>
    implements MultiMap<K, V, C> {
        private final Map<K, C> delegate;
        private final Supplier<C> collectionFactory;

        public MMap(Map<K, C> delegate, Supplier<C> collectionFactory) {
            this.delegate = delegate;
            this.collectionFactory = collectionFactory;
        }

        public C getAll(K key) {
            return (C)((Collection)this.delegate.get(key));
        }

        @Override
        public C allValues() {
            Collection result = (Collection)this.collectionFactory.get();
            for (Collection collection : this.values()) {
                result.addAll(collection);
            }
            return (C)result;
        }

        @Override
        public Set<Map.Entry<K, C>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public C put(K key, C value) {
            return (C)((Collection)this.delegate.put(key, value));
        }

        @Override
        public boolean putSingle(K key, V value) {
            Collection collection = (Collection)this.delegate.get(key);
            if (collection == null) {
                collection = (Collection)this.collectionFactory.get();
                this.delegate.put(key, collection);
            }
            return collection.add(value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends C> t) {
            this.delegate.putAll(t);
        }

        @Override
        public Collection<C> values() {
            return this.delegate.values();
        }

        @Override
        public <Val extends V> boolean contains(Val value) {
            for (Collection collection : this.values()) {
                if (!collection.contains(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsValue(Collection<?> value) {
            return super.containsValue(value);
        }

        @Override
        public void copyTo(Collection<V> copyTo) {
            for (Collection collection : this.values()) {
                copyTo.addAll(collection);
            }
        }

        @Override
        public int sizeAll() {
            int result = 0;
            for (Collection collection : this.values()) {
                result += collection.size();
            }
            return result;
        }
    }
}

