/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import java.util.List;

public class ListOrderComparator<T>
implements Comparator<T> {
    private final Resolver<T, Integer> resolver;

    public ListOrderComparator(final List<T> list) {
        Assertions.notNull("list", list);
        this.resolver = new Resolver<T, Integer>(){

            @Override
            public Integer get(T descriptor) {
                int result = list.indexOf(descriptor);
                Assertions.not("unknown element: index < 0", result < 0);
                return result;
            }
        };
    }

    @Override
    public int compare(T o1, T o2) {
        return this.resolver.get(o1).compareTo(this.resolver.get(o2));
    }
}

