/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public class UriQueryParser {
    private static final Pattern correctness = Pattern.compile("(([^&=]+)=([^&]*))?(&([^&=]+)=([^&]*))*");
    private static final Pattern extractor = Pattern.compile("([^&=]+)=([^&]*)");

    public Map<String, String> parse(URI uri) throws URISyntaxException {
        return this.parse(uri.getQuery() == null ? "" : uri.getQuery());
    }

    public Map<String, String> parse(String urlQueryParametersString) throws URISyntaxException {
        if (!this.validate(urlQueryParametersString)) {
            throw new URISyntaxException(urlQueryParametersString, "Not a query parameter list.");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Scanner scanner = new Scanner(urlQueryParametersString.trim());
        while (scanner.findWithinHorizon(extractor, 0) != null) {
            builder.put((Object)scanner.match().group(1), (Object)scanner.match().group(2));
        }
        return builder.build();
    }

    @VisibleForTesting
    boolean validate(String urlQueryParametersString) {
        return correctness.matcher(urlQueryParametersString.trim()).matches();
    }
}

