/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hallelujah;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseFailure;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;
import com.atlassian.buildeng.hallelujah.api.server.AbstractServerListener;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseProvider;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseResultCollector;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class FailSlowTestsListener
extends AbstractServerListener {
    private static final long SECOND_IN_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long MAX_EXPECTED_JIRA_SETUP = TimeUnit.MINUTES.toMillis(5L);
    private static final String TIMEOUT_MESSAGE = "timeout";
    private final long maxAllowedDurationMS;
    private final ConcurrentMap<String, Boolean> visitedRunners = Maps.newConcurrentMap();
    private final String failMessage;

    public FailSlowTestsListener(long maxAllowedDuration, TimeUnit unit) {
        this.maxAllowedDurationMS = unit.toMillis(maxAllowedDuration);
        this.failMessage = "Test failed because its execution exceeded " + this.maxAllowedDurationMS + " ms";
    }

    public boolean onResultReceived(ServerTestCaseResultCollector serverTestCaseResultCollector, ServerTestCaseProvider serverTestCaseProvider, TestCaseResult testCaseResult) {
        long maxTime = this.visitedRunners.putIfAbsent(testCaseResult.runnerId, Boolean.TRUE) == null ? this.maxAllowedDurationMS + MAX_EXPECTED_JIRA_SETUP : this.maxAllowedDurationMS;
        if (testCaseResult.passed && this.timeExceded(maxTime, testCaseResult)) {
            testCaseResult.passed = false;
            testCaseResult.failure = this.getTestCaseFailure();
        }
        return true;
    }

    private TestCaseFailure getTestCaseFailure() {
        TestCaseFailure failure = new TestCaseFailure();
        failure.message = this.failMessage;
        failure.type = TIMEOUT_MESSAGE;
        failure.log = "";
        return failure;
    }

    private boolean timeExceded(long maxTime, TestCaseResult testCaseResult) {
        return testCaseResult.duration * (double)SECOND_IN_MS > (double)maxTime;
    }
}

