/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rules;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HeaderOnlyWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.rules.ExternalResource;
import org.xml.sax.SAXException;

public class RestRule
extends ExternalResource {
    private final FuncTestCase testCase;
    private String baseUrl;

    public RestRule(FuncTestCase testCase) {
        this.testCase = testCase;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseUrlPlus(String ... paths) {
        return this.getBaseUrlPlus(Arrays.asList(paths));
    }

    public String getBaseUrlPlus(Iterable<String> paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.startsWith("/") ? path.substring(1) : path;
            }
        });
        String path = pathsNoLeadingSlashes != null ? StringUtils.join((Collection)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/') : "";
        return String.format("%s/%s", this.getBaseUrl(), path);
    }

    public URI getBaseUriPlus(Iterable<String> paths) {
        try {
            return new URI(this.getBaseUrlPlus(paths));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getBaseUriPlus(String ... paths) {
        return this.getBaseUriPlus(Arrays.asList(paths));
    }

    public String getRestApiUrl(String ... paths) {
        List<String> list = CollectionBuilder.newBuilder("rest", "api", "2").addAll(paths).asList();
        return this.getBaseUrlPlus(list);
    }

    public URI getRestApiUri(String ... paths) {
        return this.getRestApiUri(Arrays.asList(paths));
    }

    public URI getRestApiUri(Iterable<String> paths) {
        ArrayList all = Lists.newArrayList((Object[])new String[]{"rest", "api", "2"});
        all.addAll(Lists.newArrayList(paths));
        return this.getBaseUriPlus(all);
    }

    public JSONObject getJSON(String url, String ... expand) throws JSONException {
        String queryString = expand != null && expand.length > 0 ? "?expand=" + StringUtils.join((Object[])expand, (char)',') : "";
        this.testCase.getTester().gotoPage(url + queryString);
        return new JSONObject(this.testCase.getTester().getDialog().getResponseText());
    }

    public WebResponse GET(String url) throws IOException, SAXException {
        return this.GET(url, Collections.emptyMap());
    }

    public WebResponse GET(String url, Map<String, String> headers) throws IOException, SAXException {
        this.testCase.getTester().getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        for (Map.Entry<String, String> headerField : headers.entrySet()) {
            this.testCase.getTester().getDialog().getWebClient().setHeaderField(headerField.getKey(), headerField.getValue());
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.getBaseUrlPlus(url));
        return this.testCase.getTester().getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse DELETE(String url) throws IOException, SAXException {
        this.testCase.getTester().getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HeaderOnlyWebRequest delete = new HeaderOnlyWebRequest(this.getBaseUrlPlus(url)){

            public String getMethod() {
                return "DELETE";
            }

            protected void completeRequest(URLConnection connection) throws IOException {
                ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
                super.completeRequest(connection);
            }
        };
        return this.testCase.getTester().getDialog().getWebClient().sendRequest((WebRequest)delete);
    }

    public WebResponse POST(String url, JSONObject json) throws IOException, SAXException {
        return this.POST(url, json.toString());
    }

    public WebResponse POST(String url, String postBody) throws IOException, SAXException {
        this.testCase.getTester().getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PostMethodWebRequest request = new PostMethodWebRequest(this.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.testCase.getTester().getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse PUT(String url, JSONObject json) throws IOException, SAXException {
        return this.PUT(url, json.toString());
    }

    public WebResponse PUT(String url, String postBody) throws IOException, SAXException {
        this.testCase.getTester().getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PutMethodWebRequest request = new PutMethodWebRequest(this.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.testCase.getTester().getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public void before() {
        this.baseUrl = this.testCase.getEnvironmentData().getBaseUrl().toExternalForm();
    }

    public void after() {
        HttpUnitOptions.resetDefaultCharacterSet();
    }
}

