/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.CleanAttachmentsRule;
import com.atlassian.jira.functest.rule.CleanDirectoryRule;
import com.atlassian.jira.functest.rule.CopyAttachmentsRule;
import com.atlassian.jira.functest.rule.CopyDirectoryRule;
import com.atlassian.jira.functest.rule.EnableAttachmentsRule;
import com.atlassian.jira.testkit.client.AttachmentsControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.File;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class Rules {
    public static TestRule prepareAttachments(JIRAEnvironmentData environmentData, String sourceSubPath) {
        Backdoor backdoor = new Backdoor(environmentData);
        AttachmentsControl attachmentsControl = backdoor.attachments();
        return Rules.chain().around(Rules.enableAttachments(attachmentsControl)).around(Rules.cleanAttachments(attachmentsControl)).around(Rules.copyAttachments(environmentData, sourceSubPath, attachmentsControl));
    }

    public static RuleChain chain() {
        return RuleChain.emptyRuleChain();
    }

    public static TestRule enableAttachments(AttachmentsControl attachmentsControl) {
        return new EnableAttachmentsRule(attachmentsControl);
    }

    public static TestRule cleanAttachments(AttachmentsControl attachmentsControl) {
        return new CleanAttachmentsRule(attachmentsControl);
    }

    public static TestRule copyAttachments(JIRAEnvironmentData environmentData, String sourceSubPath, AttachmentsControl attachmentsControl) {
        return new CopyAttachmentsRule(environmentData, sourceSubPath, attachmentsControl);
    }

    public static TestRule cleanDirectory(File directory) {
        return new CleanDirectoryRule(directory);
    }

    public static TestRule copyDirectory(File sourceDirectory, File targetDirectory) {
        return new CopyDirectoryRule(sourceDirectory, targetDirectory);
    }
}

