/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.rule.Rules;
import com.atlassian.jira.testkit.client.AttachmentsControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.File;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class CopyAttachmentsRule
implements TestRule {
    private final JIRAEnvironmentData environmentData;
    private final String sourceSubPath;
    private final AttachmentsControl attachmentsControl;

    CopyAttachmentsRule(JIRAEnvironmentData environmentData, String sourceSubPath, AttachmentsControl attachmentsControl) {
        this.environmentData = environmentData;
        this.sourceSubPath = sourceSubPath;
        this.attachmentsControl = attachmentsControl;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                File dataDirectory = CopyAttachmentsRule.this.environmentData.getXMLDataLocation();
                File sourceDirectory = new File(dataDirectory, CopyAttachmentsRule.this.sourceSubPath);
                String attachmentPath = CopyAttachmentsRule.this.attachmentsControl.getAttachmentPath();
                File targetDirectory = new File(attachmentPath);
                TestRule copyDirectoryRule = Rules.copyDirectory(sourceDirectory, targetDirectory);
                copyDirectoryRule.apply(base, description).evaluate();
            }
        };
    }
}

