/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class URIMatcher
extends TypeSafeMatcher<URI> {
    private final URI expected;

    URIMatcher(URI expected) {
        this.expected = expected;
    }

    public static URIMatcher isSameURI(URI uri) {
        return new URIMatcher(uri);
    }

    protected boolean matchesSafely(URI receivedUriToMatch) {
        block7: {
            try {
                if (!this.expected.equals(receivedUriToMatch)) {
                    if (new URI(receivedUriToMatch.getScheme(), receivedUriToMatch.getUserInfo(), receivedUriToMatch.getHost(), receivedUriToMatch.getPort(), receivedUriToMatch.getPath(), null, receivedUriToMatch.getFragment()).equals(new URI(this.expected.getScheme(), this.expected.getUserInfo(), this.expected.getHost(), this.expected.getPort(), this.expected.getPath(), null, this.expected.getFragment()))) {
                        if (this.expected.getQuery() == null && receivedUriToMatch.getQuery() == null) {
                            return true;
                        }
                        if (this.expected.getQuery() != null && receivedUriToMatch.getQuery() != null && receivedUriToMatch.getQuery().length() == this.expected.getQuery().length()) {
                            String uriToMatchQuery = receivedUriToMatch.getQuery();
                            String expectedQuery = this.expected.getQuery();
                            HashSet uriToMatchParams = Sets.newHashSet((Object[])uriToMatchQuery.split("&"));
                            HashSet expectedParams = Sets.newHashSet((Object[])expectedQuery.split("&"));
                            if (expectedParams.containsAll(uriToMatchParams)) {
                                return true;
                            }
                            uriToMatchParams = Sets.newHashSet((Object[])uriToMatchQuery.split(";"));
                            expectedParams = Sets.newHashSet((Object[])expectedQuery.split(";"));
                            return expectedParams.containsAll(uriToMatchParams);
                        }
                    }
                    break block7;
                }
                return true;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("URI similar to (same base URI and same params + values ").appendText(this.expected.toString());
    }
}

