/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.functest.framework.backdoor.LicenseRoleControl;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class LicenseRoleBeanMatcher
extends TypeSafeDiagnosingMatcher<LicenseRoleControl.LicenseRoleBean> {
    private final String id;
    private final String name;
    private Set<String> groups = Sets.newHashSet();
    private String primaryGroup;

    public static LicenseRoleBeanMatcher forBusinessUser() {
        return new LicenseRoleBeanMatcher(LicenseRoleControl.BUSINESS_USER, "Business User");
    }

    public LicenseRoleBeanMatcher(String id, String name) {
        this.id = id.toLowerCase(Locale.ENGLISH);
        this.name = name;
    }

    protected boolean matchesSafely(LicenseRoleControl.LicenseRoleBean item, Description mismatchDescription) {
        if (Objects.equal((Object)this.name, (Object)item.getName()) && this.groups.containsAll(item.getGroups()) && Objects.equal((Object)this.id, (Object)item.getId()) && Objects.equal((Object)this.primaryGroup, (Object)item.getPrimaryGroup())) {
            return true;
        }
        mismatchDescription.appendValue((Object)String.format("[name: %s, groups: %s, id: %s, primary: %s]", item.getName(), item.getGroups(), item.getId(), item.getPrimaryGroup()));
        return false;
    }

    public void describeTo(Description description) {
        description.appendText(String.format("[name: %s, groups: %s, id: %s, primary: %s]", this.name, this.groups, this.id, this.primaryGroup));
    }

    public LicenseRoleBeanMatcher setGroups(String ... groups) {
        this.groups = Sets.newHashSet((Object[])groups);
        return this;
    }

    public LicenseRoleBeanMatcher setPrimaryGroup(String primaryGroup) {
        this.primaryGroup = primaryGroup;
        return this;
    }
}

