/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.meterware.httpunit.WebResponse;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class HeaderValue
extends TypeSafeMatcher<WebResponse> {
    private final String headerName;
    private final Matcher<? super String> valueMatcher;

    public static Matcher<WebResponse> header(String headerName, Matcher<? super String> headerValue) {
        return new HeaderValue(headerName, headerValue);
    }

    public HeaderValue(String headerName, Matcher<? super String> headerValue) {
        this.headerName = headerName;
        this.valueMatcher = headerValue;
    }

    public boolean matchesSafely(WebResponse response) {
        String[] values;
        for (String value : values = response.getHeaderFields(this.headerName)) {
            if (!this.valueMatcher.matches((Object)value)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a WebResponse where the header ").appendValue((Object)this.headerName).appendText(" is present and the value ").appendDescriptionOf(this.valueMatcher);
    }
}

