/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.functest.matcher.DocumentMatcher;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BuildNumberMatcher
extends DocumentMatcher {
    private final int expectedBuildNumber;

    public static BuildNumberMatcher hasBuildNumber(int buildNumber) {
        return new BuildNumberMatcher(buildNumber);
    }

    public BuildNumberMatcher(int expectedBuildNumber) {
        this.expectedBuildNumber = expectedBuildNumber;
    }

    @Override
    protected boolean matchesDocument(@Nullable Document doc) throws Exception {
        return doc != null && this.readBuildNumberFrom(doc) == this.expectedBuildNumber;
    }

    public void describeTo(Description description) {
        description.appendText("a backup file with buildnumber equal to " + this.expectedBuildNumber);
    }

    protected int readBuildNumberFrom(Document doc) throws Exception {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression findOsPropertyId = xpath.compile("//OSPropertyEntry[@propertyKey='jira.version.patched']");
        Node osPropertyEntry = (Node)findOsPropertyId.evaluate(doc, XPathConstants.NODE);
        if (osPropertyEntry != null) {
            String osPropertyId = osPropertyEntry.getAttributes().getNamedItem("id").getTextContent();
            XPathExpression findOsPropertyString = xpath.compile(String.format("//OSPropertyString[@id='%s']", osPropertyId));
            Node osPropertyString = (Node)findOsPropertyString.evaluate(doc, XPathConstants.NODE);
            if (osPropertyString != null) {
                return Integer.valueOf(osPropertyString.getAttributes().getNamedItem("value").getTextContent());
            }
        }
        throw new RuntimeException();
    }
}

