/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.url;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtil {
    private static final Logger log = LoggerFactory.getLogger(URLUtil.class);
    private static final Pattern URL_PATTERN = Pattern.compile("(.*)\\?([^&]+)(.*)");

    public static boolean compareURLStrings(String controlLink, String testLink) {
        if (testLink.indexOf(controlLink) != -1) {
            return true;
        }
        if (controlLink.indexOf("?") != -1) {
            Map<String, String> testParams;
            String[] controlStrings = controlLink.split("\\?");
            String[] testStrings = testLink.split("\\?");
            if (testStrings[0].indexOf(controlStrings[0]) == -1) {
                log.info("Tested URL '" + testStrings[0] + "' did not containt control URL '" + controlStrings[0] + "'");
                return false;
            }
            Map<String, String> controlParams = URLUtil.getParameters(controlStrings[1]);
            if (!controlParams.equals(testParams = URLUtil.getParameters(testStrings[1]))) {
                log.info("Parameters of the tested URL '" + testLink + "' don't equal the control URL '" + controlLink + "'");
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getQueryParamValueFromUrl(String url, String paramName) {
        String[] urlParts = url.split("\\?");
        if (urlParts.length == 1) {
            return null;
        }
        return URLUtil.getParameters(urlParts[1]).get(paramName);
    }

    public static String getQueryParamValueFromUrl(URL url, String paramName) {
        return URLUtil.getQueryParamValueFromUrl(url.toString(), paramName);
    }

    private static Map<String, String> getParameters(String controlQueryString) {
        StringTokenizer tokenizer = new StringTokenizer(controlQueryString, "&=");
        HashMap<String, String> controlParams = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String paramKey = tokenizer.nextToken();
            String paramValue = tokenizer.nextToken();
            controlParams.put(paramKey, paramValue);
        }
        return controlParams;
    }

    public static String addXsrfToken(String token, String url) {
        Matcher m = URL_PATTERN.matcher(url);
        if (m.matches()) {
            return m.group(1) + "?atl_token=" + token + "&" + m.group(2) + m.group(3);
        }
        return url + "?atl_token=" + token;
    }

    public static String encode(String urlParam) {
        try {
            return URLEncoder.encode(urlParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "ThisCanNeverHappenInJava";
        }
    }

    public static String decode(String urlParam) {
        try {
            return URLDecoder.decode(urlParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "ThisCanNeverHappenInJava";
        }
    }
}

