/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.url;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedURL {
    private String mUrl;
    private String mProtocol;
    private int mPort;
    private String mHost;
    private String mPath;
    private String mFile;
    private String mQuery;
    private final Map<String, String> simpleQueryParms;
    private final Map<String, List<String>> multiQueryParams;

    public ParsedURL(String url) {
        this.mUrl = url == null ? "" : url;
        this.simpleQueryParms = new TreeMap<String, String>();
        this.multiQueryParams = new TreeMap<String, List<String>>();
        this.parse();
    }

    private void parse() {
        String r = this.mUrl;
        int i = r.indexOf("://");
        if (i < 0) {
            r = r.startsWith("/") ? "http://" + r : "http:///" + r;
            i = r.indexOf("://");
        }
        this.mProtocol = r.substring(0, i);
        if ((i = (r = r.substring(i + "://".length())).indexOf(47)) < 0) {
            i = r.indexOf(63);
        }
        String server = i >= 0 ? r.substring(0, i) : r;
        r = i >= 0 ? r.substring(i) : "";
        i = server.indexOf(58);
        if (i >= 0) {
            this.mHost = server.substring(0, i);
            String port = server.substring(i + 1);
            this.mPort = port.length() > 0 ? Integer.parseInt(port) : -1;
        } else {
            this.mHost = server;
            this.mPort = -1;
        }
        this.mFile = r.length() > 0 ? r.substring(0) : "";
        if (!r.startsWith("/")) {
            this.mPath = "";
        } else {
            i = r.indexOf(63);
            if (i >= 0) {
                this.mPath = r.substring(0, i);
                r = r.substring(i);
            } else {
                this.mPath = r;
                r = "";
            }
        }
        if (r.startsWith("?")) {
            this.mQuery = r.substring(1);
        }
        this.parseQueryParms();
    }

    private void parseQueryParms() {
        String query = this.getQuery();
        if (query != null) {
            String[] parmBits;
            for (String parmBit : parmBits = query.split("&")) {
                Matcher matcher = Pattern.compile("(.*)=(.*)").matcher(parmBit);
                if (!matcher.find()) continue;
                String name = matcher.group(1);
                String value = matcher.group(2);
                this.simpleQueryParms.put(name, value);
                List<String> values = this.multiQueryParams.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.multiQueryParams.put(name, values);
                }
                values.add(value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mProtocol).append("://").append(this.mHost);
        if (this.mPort != -1) {
            sb.append(":").append(this.mPort);
        }
        sb.append(this.mPath);
        int count = 0;
        for (Map.Entry<String, List<String>> entry : this.multiQueryParams.entrySet()) {
            List<String> values = entry.getValue();
            for (String value : values) {
                sb.append(count == 0 ? "?" : "&");
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(value);
                ++count;
            }
        }
        return sb.toString();
    }

    public String getProtocol() {
        return this.nvl(this.mProtocol);
    }

    public String getHost() {
        return this.nvl(this.mHost);
    }

    public int getPort() {
        return this.mPort;
    }

    public String getFile() {
        return this.nvl(this.mFile);
    }

    public String getPath() {
        return this.nvl(this.mPath);
    }

    public String getQuery() {
        return this.nvl(this.mQuery);
    }

    public Map<String, String> getQueryParameters() {
        return this.simpleQueryParms;
    }

    public Map<String, String> getQueryParameters(String ... names) {
        if (names == null) {
            return Collections.emptyMap();
        }
        HashSet<String> onlyKeys = new HashSet<String>(Arrays.asList(names));
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.simpleQueryParms.entrySet()) {
            if (!onlyKeys.contains(entry.getKey())) continue;
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public Map<String, String> getQueryParametersIgnoring(String ... names) {
        if (names == null) {
            return Collections.emptyMap();
        }
        HashSet<String> ignoredKeys = new HashSet<String>(Arrays.asList(names));
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.simpleQueryParms.entrySet()) {
            if (ignoredKeys.contains(entry.getKey())) continue;
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public String getQueryParameter(String name) {
        return this.simpleQueryParms.get(name);
    }

    public Map<String, List<String>> getMultiQueryParameters() {
        return this.multiQueryParams;
    }

    public Map<String, List<String>> getMultiQueryParameters(String ... names) {
        if (names == null) {
            return Collections.emptyMap();
        }
        HashSet<String> onlyKeys = new HashSet<String>(Arrays.asList(names));
        TreeMap<String, List<String>> returnMap = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.multiQueryParams.entrySet()) {
            if (!onlyKeys.contains(entry.getKey())) continue;
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public Map<String, List<String>> getMultiQueryParametersIgnoring(String ... names) {
        if (names == null) {
            return Collections.emptyMap();
        }
        HashSet<String> ignoredKeys = new HashSet<String>(Arrays.asList(names));
        TreeMap<String, List<String>> returnMap = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.multiQueryParams.entrySet()) {
            if (ignoredKeys.contains(entry.getKey())) continue;
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public List<String> getMultiQueryParameter(String name) {
        return this.multiQueryParams.get(name);
    }

    private String nvl(String s) {
        return s == null ? "" : s;
    }
}

