/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.env;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class EnvironmentUtils
extends AbstractFuncTestUtil {
    private static final String INFO_OS = "Operating System";
    private static final String OS_WINDOWS = "WINDOWS";
    public static final float JDK_1_5_VERSION = 1.5f;
    private final Navigation navigation;

    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData) {
        this(tester, environmentData, new NavigationImpl(tester, environmentData));
    }

    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
    }

    public boolean isOnWindows() {
        return this.isOnOperatingSystem(OS_WINDOWS);
    }

    private boolean isOnOperatingSystem(String os) {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        try {
            WebTable systemInfoTable = this.tester.getDialog().getResponse().getTableWithID("system_info_table");
            for (int i = 0; i < systemInfoTable.getRowCount(); ++i) {
                String key = systemInfoTable.getCellAsText(i, 0);
                if (key == null || !key.contains(INFO_OS)) continue;
                String value = systemInfoTable.getCellAsText(i, 1);
                if (value == null) break;
                return value.toUpperCase().contains(os.toUpperCase());
            }
            throw new RuntimeException("System Info page does not contain 'Operating System' information!");
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing the System Infor page", e);
        }
    }

    public float getJiraJavaVersion() {
        String JVM__HTML_TABLE_TD;
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        String responseText = this.tester.getDialog().getResponseText();
        int idx = responseText.indexOf("<strong>Java Version</strong>");
        if (idx != -1 && (idx = responseText.indexOf(JVM__HTML_TABLE_TD = "<td class=\"cell-type-value\">", idx)) != -1) {
            int lastDecimalIdx;
            int firstDecimalIdx;
            String jvmVersion;
            if ((jvmVersion = responseText.substring(idx += JVM__HTML_TABLE_TD.length(), responseText.indexOf("</td>", idx))).contains("_")) {
                jvmVersion = jvmVersion.substring(0, jvmVersion.indexOf("_"));
            }
            if ((firstDecimalIdx = jvmVersion.indexOf(".")) != (lastDecimalIdx = jvmVersion.lastIndexOf("."))) {
                jvmVersion = jvmVersion.substring(0, lastDecimalIdx);
            }
            try {
                return Float.parseFloat(jvmVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public boolean isSunJVM() {
        String jvmVendor = this.getSystemInfoProperty("Java VM");
        return jvmVendor != null && jvmVendor.contains("HotSpot");
    }

    public boolean isJavaBeforeJdk15() {
        return this.getJiraJavaVersion() < 1.5f;
    }

    public boolean isOracle() {
        return this.isDatabaseEqualTo("oracle");
    }

    private boolean isDatabaseEqualTo(String database) {
        String databaseType = this.getSystemInfoProperty("Database type");
        return databaseType != null && databaseType.toLowerCase().contains(database.toLowerCase());
    }

    public String getSystemInfoProperty(String propertyLabel) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("system_info_table");
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!table.getTableCell(i, 0).asText().contains(propertyLabel)) continue;
            return table.getTableCell(i, 1).asText();
        }
        return null;
    }

    public boolean isJvmWithPermGen() {
        String JVM__HTML_TABLE_TD;
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        String responseText = this.tester.getDialog().getResponseText();
        int idx = responseText.indexOf("<strong>Total PermGen Memory</strong>");
        if (idx != -1 && (idx = responseText.indexOf(JVM__HTML_TABLE_TD = "<td class=\"cell-type-value\">", idx)) != -1) {
            String jvmPermGen;
            if ((jvmPermGen = responseText.substring(idx += JVM__HTML_TABLE_TD.length(), responseText.indexOf("</td>", idx))).contains(" ")) {
                jvmPermGen = jvmPermGen.substring(0, jvmPermGen.indexOf(" "));
            }
            try {
                return Float.parseFloat(jvmPermGen) > 0.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

