/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.dom;

import com.atlassian.jira.functest.framework.util.dom.DomBetterNode;
import com.atlassian.jira.functest.framework.util.dom.DomNodeCopier;
import com.atlassian.jira.functest.framework.util.dom.DomNodeOutputter;
import com.atlassian.jira.util.DomFactory;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomKit {
    private static final ThreadLocal nonvalidatingDocumentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            return DomKit.buildDocumentBuilder();
        }
    };
    private static final boolean convertTagsToLowerCaseOnOutput = false;

    private static DocumentBuilder buildDocumentBuilder() {
        return DomFactory.createDocumentBuilder();
    }

    public static DocumentBuilder getNonValidatingDocumentBuilder() {
        return (DocumentBuilder)nonvalidatingDocumentBuilders.get();
    }

    public static Element getHtmlElement(Document document) {
        return DomKit.getFirstElementByTag(document, "HTML");
    }

    public static Element getBodyElement(Document document) {
        return DomKit.getFirstElementByTag(document, "BODY");
    }

    public static Element getFirstParentByTag(Element element, String parentTagName) {
        for (Element el = (Element)element.getParentNode(); el != null; el = (Element)el.getParentNode()) {
            if (!el.getTagName().equalsIgnoreCase(parentTagName)) continue;
            return el;
        }
        return null;
    }

    static Element getFirstElementByTag(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        nodeList = document.getElementsByTagName(tagName.toLowerCase());
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Text[] getTextNodes(Element element) {
        ArrayList<Text> textNodeList = new ArrayList<Text>();
        DomKit.walkDOMAndGatherTextNodes(element, textNodeList);
        return textNodeList.toArray(new Text[textNodeList.size()]);
    }

    public static String getCollapsedText(Node node) {
        ArrayList<String> textList = new ArrayList<String>();
        DomKit.walkDOMAndGatherText(node, textList);
        StringBuffer sb = new StringBuffer();
        for (String text : textList) {
            text = DomKit.canonicalTextNode(text);
            DomKit.smooshTogether(sb, text);
        }
        return sb.toString().trim();
    }

    public static String getRawText(Node node) {
        ArrayList<String> textList = new ArrayList<String>();
        DomKit.walkDOMAndGatherText(node, textList);
        StringBuilder sb = new StringBuilder();
        for (String aTextList : textList) {
            sb.append(aTextList);
        }
        return sb.toString();
    }

    private static StringBuffer smooshTogether(StringBuffer sb, String text) {
        if (DomKit.endsWithWhitespace(sb.toString()) && DomKit.startsWithWhitespace(text)) {
            sb = DomKit.rightTrim(sb);
            text = DomKit.leftTrim(text);
            sb.append(" ");
        }
        sb.append(text);
        return sb;
    }

    private static String canonicalTextNode(String textNodeStr) {
        String[] cleanupStrs;
        for (String cleanupStr : cleanupStrs = new String[]{"\u00a0"}) {
            int si = textNodeStr.indexOf(cleanupStr);
            if (si == -1) continue;
            int nbsplen = cleanupStr.length();
            StringBuilder sb = new StringBuilder(textNodeStr);
            while (si != -1) {
                sb.replace(si, si + nbsplen, " ");
                ++si;
                si = sb.indexOf(cleanupStr, si);
            }
            textNodeStr = sb.toString();
        }
        boolean hasFrontWhiteSpace = DomKit.startsWithWhitespace(textNodeStr);
        boolean hasBackWhiteSpace = DomKit.endsWithWhitespace(textNodeStr);
        textNodeStr = textNodeStr.trim();
        if (hasFrontWhiteSpace) {
            textNodeStr = " " + textNodeStr;
        }
        if (hasBackWhiteSpace) {
            textNodeStr = textNodeStr + " ";
        }
        if (DomKit.isAllWhitespace(textNodeStr)) {
            textNodeStr = " ";
        }
        return textNodeStr;
    }

    private static boolean startsWithWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        return len > 0 && Character.isWhitespace(chars[0]);
    }

    private static boolean endsWithWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        return len > 0 && Character.isWhitespace(chars[len - 1]);
    }

    private static boolean isAllWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static String leftTrim(String s) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars = s.toCharArray()) {
            if (sb.length() == 0 && Character.isWhitespace(aChar)) continue;
            sb.append(aChar);
        }
        return sb.toString();
    }

    private static StringBuffer rightTrim(StringBuffer sb) {
        int len = sb.length();
        if (len > 0) {
            for (int index = sb.length() - 1; index >= 0 && Character.isWhitespace(sb.charAt(index)); --index) {
                sb.deleteCharAt(index);
            }
        }
        return sb;
    }

    private static void walkDOMAndGatherText(Node node, List<String> textList) {
        DomKit.walkDOMAndGatherImpl(node, textList, new Function<Text, String>(){

            public String apply(Text input) {
                return input.getData();
            }
        });
    }

    private static void walkDOMAndGatherTextNodes(Node node, List<Text> textList) {
        DomKit.walkDOMAndGatherImpl(node, textList, Functions.identity());
    }

    private static <T> void walkDOMAndGatherImpl(Node node, List<? super T> textList, Function<Text, T> function) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                textList.add(function.apply((Object)((Text)child)));
            }
            if (child.getNodeType() != 1) continue;
            DomKit.walkDOMAndGatherImpl(child, textList, function);
        }
    }

    public static String getInnerHTML(Node node) {
        StringBuilder sb = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nodeList.item(i);
            sb.append(DomKit.getHTML(child));
        }
        return sb.toString();
    }

    public static String getHTML(Node node) {
        StringBuffer sb = new StringBuffer();
        DomKit.useDOM(node, sb);
        return sb.toString();
    }

    private static void useDOM(Node node, StringBuffer sb) {
        new DomNodeOutputter(node, sb, false);
    }

    public static Node copyDOM(Node srcNode, boolean convertTagsToLowerCase) {
        return new DomNodeCopier(srcNode, convertTagsToLowerCase).getCopiedNode();
    }

    public static Node betterNode(Node node) {
        return DomBetterNode.betterNode(node);
    }
}

