/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.functest.framework.util.FilteredSearcherGroup;
import com.atlassian.jira.functest.framework.util.SearchResults;
import com.atlassian.jira.functest.framework.util.Searcher;
import com.atlassian.jira.functest.framework.util.Searchers;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;

public class SearchersClient
extends RestApiClient<SearchersClient> {
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    public SearchersClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.environmentData = environmentData;
    }

    public List<Searcher> allSearchers(String jqlContext) {
        return this.asList(this.getSearchers((String)jqlContext).searchers);
    }

    private List<Searcher> asList(Searchers searchers) {
        ArrayList set = Lists.newArrayList();
        for (FilteredSearcherGroup group : searchers.getGroups()) {
            for (Searcher searcher : group.getSearchers()) {
                set.add(searcher);
            }
        }
        return set;
    }

    public SearchResults getSearchersBasic(String ... params) {
        return (SearchResults)this.basic(params).get(SearchResults.class);
    }

    public SearchResults getSearchers(String jqlContext) {
        return (SearchResults)this.searchers(jqlContext).get(SearchResults.class);
    }

    public Response getSearchersResponse(final String jqlContext) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)SearchersClient.this.searchers(jqlContext).get(ClientResponse.class);
            }
        }, String.class);
    }

    private WebResource basic(String ... params) {
        WebResource resource = this.createResource().path("QueryComponent!Default.jspa").queryParam("decorator", "none");
        for (int i = 0; i < params.length; i += 2) {
            resource = resource.queryParam(params[i], params[i + 1]);
        }
        return resource;
    }

    private WebResource searchers(String jqlContext) {
        WebResource resource = this.createResource().path("secure/QueryComponent!Jql.jspa").queryParam("decorator", "none");
        if (null != jqlContext) {
            resource = resource.queryParam("jql", jqlContext);
        }
        return resource;
    }

    protected WebResource createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm());
    }
}

